/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.license;

import com.tangosol.io.Base64OutputStream;
import com.tangosol.license.LicenseException;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.UID;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class LicensedObject
extends Base {
    private static boolean m_fConfigured;
    private static Map m_mapLicenses;
    private static Map m_mapChecked;

    public static void main(String[] asArg) {
        LicensedObject.out();
        LicensedObject.out("Registered Licenses:");
        LicenseData[] aLicense = LicensedObject.getLicenseData();
        int c = aLicense.length;
        for (int i = 0; i < c; ++i) {
            LicensedObject.out();
            LicensedObject.out(aLicense[i]);
        }
        LicensedObject.out();
    }

    public LicensedObject() {
        if (!m_mapChecked.containsKey(this.getClass())) {
            LicenseData[] aLicense = this.getClassLicenseData();
            if (aLicense == null || aLicense.length == 0) {
                throw new LicenseException("The necessary edition to perform the operation is not available; \"" + this.toString() + "\" is required.");
            }
            String sFailure = null;
            int c = aLicense.length;
            for (int i = 0; i < c && (sFailure = LicensedObject.getLicenseFailure(aLicense[i])) != null; ++i) {
            }
            if (sFailure != null) {
                throw new LicenseException(sFailure);
            }
            m_mapChecked.put(this.getClass(), null);
        }
    }

    public LicenseData[] getClassLicenseData() {
        return LicensedObject.getClassLicenseData(this.getClass());
    }

    public static LicenseData[] getClassLicenseData(Class clz) {
        m_fConfigured = true;
        while (clz != null) {
            List list = (List)m_mapLicenses.get(clz.getName());
            if (list != null) {
                return list.toArray(new LicenseData[list.size()]);
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    public static LicenseData[] getLicenseData() {
        m_fConfigured = true;
        Map map = m_mapLicenses;
        ArrayList list = new ArrayList();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            list.addAll((List)iter.next());
        }
        return list.toArray(new LicenseData[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLicenseData(LicenseData[] aLicense) {
        SafeHashMap<String, LinkedList<LicenseData>> map = m_mapLicenses;
        if (map == null) {
            m_mapLicenses = map = new SafeHashMap<String, LinkedList<LicenseData>>();
        }
        SafeHashMap<String, LinkedList<LicenseData>> safeHashMap = map;
        synchronized (safeHashMap) {
            if (m_fConfigured) {
                throw new LicenseException("The license information has already been configured.");
            }
            for (LicenseData license : aLicense) {
                LinkedList<LicenseData> list = (LinkedList<LicenseData>)map.get(license.sClass);
                if (list == null) {
                    list = new LinkedList<LicenseData>();
                    map.put(license.sClass, list);
                }
                list.add(license);
            }
            m_fConfigured = true;
        }
    }

    public static void retain(String sEdition, int nLicenseType, UID uid) {
        LicensedObject.retain(sEdition, nLicenseType);
        for (LicenseData license : LicensedObject.getLicenseData()) {
            if (!Base.equals(license.uid, uid)) continue;
            LinkedList<LicenseData> list = new LinkedList<LicenseData>();
            list.add(license);
            SafeHashMap<String, LinkedList<LicenseData>> map = new SafeHashMap<String, LinkedList<LicenseData>>();
            map.put(license.sClass, list);
            m_mapLicenses = map;
            m_mapChecked = new SafeHashMap();
            return;
        }
        throw new IllegalArgumentException("Unknown license key: " + String.valueOf(uid));
    }

    public static void retain(String sEdition, int nLicenseType) {
        LicenseData[] aLicense = LicensedObject.getLicenseData();
        Iterator iterByClass = m_mapLicenses.values().iterator();
        while (iterByClass.hasNext()) {
            List list = (List)iterByClass.next();
            Iterator iterLicenses = list.iterator();
            while (iterLicenses.hasNext()) {
                LicenseData license = (LicenseData)iterLicenses.next();
                if (Base.equals(license.sEdition, sEdition) && license.nLicenseType == nLicenseType) continue;
                iterLicenses.remove();
            }
            if (!list.isEmpty()) continue;
            iterByClass.remove();
        }
        m_mapChecked.clear();
    }

    public static boolean isExpired() {
        LicenseData[] aLicense = LicensedObject.getLicenseData();
        int c = aLicense.length;
        for (int i = 0; i < c; ++i) {
            if (LicensedObject.getLicenseFailure(aLicense[i]) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean containsEdition(Class clzEdition) {
        return m_mapLicenses.containsKey(clzEdition.getName());
    }

    public static void ensureEdition(Class clzEdition) {
        Object o;
        try {
            o = clzEdition.newInstance();
        }
        catch (Exception e) {
            throw LicensedObject.ensureRuntimeException(e.getCause());
        }
        if (!LicensedObject.containsEdition(clzEdition) && LicensedObject.class.isAssignableFrom(clzEdition)) {
            throw new LicenseException("The necessary edition to perform the operation is not available; \"" + String.valueOf(o) + "\" is required.");
        }
    }

    public static void printLicense() {
        LicensedObject.printLicense(LicensedObject.getLicenseData());
    }

    public static void printLicense(Class clz, String sName) {
        LicensedObject.printLicense(LicensedObject.getClassLicenseData(clz));
    }

    private static void printLicense(LicenseData[] aLicense) {
        HashMap mapPublicEval = new HashMap();
        HashMap mapByAgreement = new HashMap();
        int nTypeMax = 0;
        for (LicenseData license : aLicense) {
            String sRestrict;
            HashMap<UID, LicenseData> mapByUid;
            String sProduct;
            HashMap<CallSite, HashMap<UID, LicenseData>> mapByRestrict;
            int nType;
            Integer IType;
            HashMap mapByProduct;
            String sLicensee;
            HashMap mapByType;
            if (license.nLicenseType == 0) {
                String sProduct2;
                String sTerm = license.lDateFrom + "|" + license.lDateTo;
                ArrayList<String> list = (ArrayList<String>)mapPublicEval.get(sTerm);
                if (list == null) {
                    list = new ArrayList<String>();
                    mapPublicEval.put((CallSite)((Object)sTerm), list);
                }
                if (list.contains(sProduct2 = license.sSoftware)) continue;
                list.add(sProduct2);
                continue;
            }
            String sAgreement = license.sAgreement;
            HashMap mapByLicensee = (HashMap)mapByAgreement.get(sAgreement);
            if (mapByLicensee == null) {
                mapByLicensee = new HashMap();
                mapByAgreement.put(sAgreement, mapByLicensee);
            }
            if ((mapByType = (HashMap)mapByLicensee.get(sLicensee = license.sLicensee + "|" + license.fOem)) == null) {
                mapByType = new HashMap();
                mapByLicensee.put((CallSite)((Object)sLicensee), mapByType);
            }
            if ((mapByProduct = (HashMap)mapByType.get(IType = Integer.valueOf(nType = license.nLicenseType))) == null) {
                mapByProduct = new HashMap();
                mapByType.put(IType, mapByProduct);
            }
            if ((mapByRestrict = (HashMap<CallSite, HashMap<UID, LicenseData>>)mapByProduct.get(sProduct = license.sSoftware)) == null) {
                mapByRestrict = new HashMap<CallSite, HashMap<UID, LicenseData>>();
                mapByProduct.put(sProduct, mapByRestrict);
            }
            if ((mapByUid = (HashMap<UID, LicenseData>)mapByRestrict.get(sRestrict = license.sSite + "|" + license.sApplication + "|" + license.lDateFrom + "|" + license.lDateTo)) == null) {
                mapByUid = new HashMap<UID, LicenseData>();
                mapByRestrict.put((CallSite)((Object)sRestrict), mapByUid);
            }
            mapByUid.put(license.uid, license);
            if (nType <= nTypeMax) continue;
            nTypeMax = nType;
        }
        String sBlock = LicensedObject.dup('*', 78);
        StringBuffer sb = new StringBuffer();
        sb.append('\n').append(sBlock).append("\n*").append("\n* " + CacheFactory.PRODUCT + " is licensed by Oracle.").append("\n*\n");
        for (Map.Entry entry : mapPublicEval.entrySet()) {
            String sTerm = (String)entry.getKey();
            List list = (List)entry.getValue();
            String[] asDate = LicensedObject.parseDelimitedString(sTerm, '|');
            long lDateFrom = Long.parseLong(asDate[0]);
            long lDateTo = Long.parseLong(asDate[1]);
            int cDaysLeft = (int)((lDateTo - System.currentTimeMillis()) / 86400000L);
            String sMessage = "Licensed for evaluation use from " + LicensedObject.formatDate(lDateFrom) + " until " + LicensedObject.formatDate(lDateTo) + " (" + (String)(cDaysLeft < 0 ? "expired" : cDaysLeft + " days remaining") + ")";
            sb.append(LicensedObject.breakLines(sMessage, 76, "* "));
            Iterator iterProductNames = list.iterator();
            while (iterProductNames.hasNext()) {
                sb.append("\n*   ").append(iterProductNames.next());
            }
            sb.append("\n*\n");
        }
        for (Map.Entry entryAgreement : mapByAgreement.entrySet()) {
            String sAgreement = (String)entryAgreement.getKey();
            Map mapByLicensee = (Map)entryAgreement.getValue();
            for (Map.Entry entryLicensee : mapByLicensee.entrySet()) {
                String sLicenseeInfo = (String)entryLicensee.getKey();
                String[] asLicenseeInfo = LicensedObject.parseDelimitedString(sLicenseeInfo, '|');
                String sLicensee = asLicenseeInfo[0];
                boolean fOem = Boolean.valueOf(asLicenseeInfo[1]);
                Map mapByType = (Map)entryLicensee.getValue();
                for (Map.Entry entryType : mapByType.entrySet()) {
                    int nLicenseType = (Integer)entryType.getKey();
                    Map mapByProduct = (Map)entryType.getValue();
                    String sType = switch (nLicenseType) {
                        case 0 -> "evaluation";
                        case 1 -> "development";
                        case 2 -> "production";
                        default -> "<unknown>";
                    };
                    StringBuffer sbTerms = new StringBuffer();
                    if (fOem || sAgreement != null) {
                        sbTerms.append("Licensed for ");
                        if (fOem) {
                            sbTerms.append("OEM ");
                        }
                        sbTerms.append(sType).append(" use to ").append(LicensedObject.formatString(sLicensee)).append(" in accordance with the terms of the ");
                        if (sAgreement == null) {
                            sbTerms.append("Oracle ").append(sType).append(" license (see http://www.tangosol.com/license.jsp):");
                        } else {
                            sbTerms.append(sAgreement).append(':');
                        }
                    } else {
                        sbTerms.append("Licensed to ").append(LicensedObject.formatString(sLicensee)).append(" for ").append(sType).append(" use in accordance with the").append(" terms of the Oracle ").append(sType).append(" license (see http://www.tangosol.com/license.jsp):");
                    }
                    sb.append(LicensedObject.breakLines(sbTerms.toString(), 76, "* ")).append("\n*\n");
                    for (Map.Entry entryProduct : mapByProduct.entrySet()) {
                        String sSoftware = (String)entryProduct.getKey();
                        Map mapByRestrict = (Map)entryProduct.getValue();
                        sb.append("*   ").append(sSoftware).append('\n');
                        for (Map.Entry entryRestrict : mapByRestrict.entrySet()) {
                            Map mapByUid = (Map)entryRestrict.getValue();
                            for (Map.Entry entryLicense : mapByUid.entrySet()) {
                                UID uid = (UID)entryLicense.getKey();
                                LicenseData license = (LicenseData)entryLicense.getValue();
                                Object sDesc = license.cSeats > 0 ? license.cSeats + " seats" : (license.cUsers > 0 ? license.cUsers + " users" : (license.cServers > 0 ? license.cServers + " servers" : (license.cSockets > 0 ? license.cSockets + " CPU-sockets" : (license.cCpus > 0 ? license.cCpus + " CPU-cores" : "Unlimited use"))));
                                if (license.sSite != null) {
                                    sDesc = (String)sDesc + " at site \"" + LicensedObject.formatString(license.sSite) + "\"";
                                }
                                if (license.sApplication != null) {
                                    sDesc = (String)sDesc + " in application \"" + LicensedObject.formatString(license.sApplication) + "\"";
                                }
                                if (license.lDateTo > 0L) {
                                    int cDaysLeft = (int)((license.lDateTo - System.currentTimeMillis()) / 86400000L);
                                    String sDate = LicensedObject.formatDate(license.lDateTo);
                                    sDesc = cDaysLeft < 0 ? (String)sDesc + " (expired " + sDate + ")" : (cDaysLeft <= 30 ? (String)sDesc + " (expires " + sDate + ", " + cDaysLeft + " days remaining)" : (String)sDesc + " (expires " + sDate + ")");
                                }
                                sb.append("*     ").append(LicensedObject.toHex(uid.toByteArray())).append("  ").append(LicensedObject.breakLines((String)sDesc, 77, "*" + LicensedObject.dup(' ', 39), false)).append('\n');
                            }
                        }
                        sb.append("*\n");
                    }
                }
            }
        }
        if (nTypeMax != 2) {
            sb.append("* A production license is required for production use.").append(" For more information,\n").append("* see http://www.tangosol.com/license.jsp.").append("\n*\n");
        }
        sb.append("* Copyright (c) Oracle Corp.").append("\n*\n").append(sBlock).append('\n');
        LicensedObject.out(sb.toString());
    }

    static String formatDate(long ldt) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(ldt);
        int nYear = calendar.get(1);
        int nMonth = calendar.get(2) + 1;
        int nDay = calendar.get(5);
        return LicensedObject.toDecString(nYear, Math.max(4, LicensedObject.getMaxDecDigits(nYear))) + "-" + LicensedObject.toDecString(nMonth, Math.max(2, LicensedObject.getMaxDecDigits(nMonth))) + "-" + LicensedObject.toDecString(nDay, Math.max(2, LicensedObject.getMaxDecDigits(nDay)));
    }

    static String formatString(String s) {
        return s.replaceAll("[*\\s]*[\n\r\u0085\u2028\u2029][*\\s]*", " ");
    }

    public static String getLicenseFailure(LicenseData data) {
        if (data.lDateFrom > 0L || data.lDateTo > 0L) {
            long lDateFrom = data.lDateFrom;
            long lDateTo = data.lDateTo;
            if (lDateFrom <= 0L) {
                lDateFrom = 0L;
            }
            lDateTo = lDateTo <= 0L ? Long.MAX_VALUE : (lDateTo += 345600000L);
            long lDate = System.currentTimeMillis();
            if (lDate < lDateFrom || lDate > lDateTo) {
                return "The necessary edition to perform the operation has expired.";
            }
        }
        return null;
    }

    static {
        if (!m_fConfigured) {
            m_mapLicenses = new SafeHashMap();
        }
        m_mapChecked = new SafeHashMap();
    }

    public static class LicenseData
    implements Serializable {
        public static final int TYPE_EVAL = 0;
        public static final int TYPE_DEV = 1;
        public static final int TYPE_PROD = 2;
        public static final String NAME_EVAL = "evaluation";
        public static final String NAME_DEV = "development";
        public static final String NAME_PROD = "production";
        public static final String URL_EVAL = "http://www.tangosol.com/license-eval.htm";
        public static final String URL_DEV = "http://www.tangosol.com/license-develop.htm";
        public static final String URL_PROD = "http://www.tangosol.com/license-prod.htm";
        public final String sSoftware;
        public final String sEdition;
        public final String sLicensee;
        public final boolean fOem;
        public final String sAgreement;
        public final int nLicenseType;
        public final String sClass;
        public final String sSite;
        public final String sApplication;
        public final long lDateFrom;
        public final long lDateTo;
        public final long lDateRenew;
        public final int cSeats;
        public final int cUsers;
        public final int cServers;
        public final int cSockets;
        public final int cCpus;
        public final UID uid;

        public LicenseData(String sSoftware, String sEdition, String sLicensee, boolean fOem, String sAgreement, int nLicenseType, String sClass, String sSite, String sApplication, long lDateFrom, long lDateTo, long lDateRenew, int cSeats, int cUsers, int cServers, int cSockets, int cCpus, UID uid) {
            this.sSoftware = sSoftware;
            this.sEdition = sEdition;
            this.sLicensee = sLicensee;
            this.fOem = fOem;
            this.sAgreement = sAgreement;
            this.nLicenseType = nLicenseType;
            this.sClass = sClass;
            this.sSite = sSite;
            this.sApplication = sApplication;
            this.lDateFrom = lDateFrom;
            this.lDateTo = lDateTo;
            this.lDateRenew = lDateRenew;
            this.cSeats = cSeats;
            this.cUsers = cUsers;
            this.cServers = cServers;
            this.cSockets = cSockets;
            this.cCpus = cCpus;
            this.uid = uid;
        }

        public String toUri() {
            return new String(Base64OutputStream.encode(this.toString().getBytes()));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Software            :  ").append(this.sSoftware).append('\n');
            sb.append("Licensee            :  ").append(LicensedObject.formatString(this.sLicensee));
            if (this.fOem) {
                sb.append(" (OEM use only)");
            }
            sb.append('\n');
            if (this.sAgreement != null) {
                sb.append("License Agreement   :  ").append(this.sAgreement).append('\n');
            }
            if (this.uid != null) {
                sb.append("License Key         :  ").append(this.uid).append('\n');
            }
            sb.append("License Type        :  ").append(switch (this.nLicenseType) {
                case 0 -> NAME_EVAL;
                case 1 -> NAME_DEV;
                case 2 -> NAME_PROD;
                default -> "<unknown>";
            }).append('\n');
            if (this.sSite != null) {
                sb.append("Site Restriction    :  ").append(LicensedObject.formatString(this.sSite)).append('\n');
            }
            if (this.sApplication != null) {
                sb.append("Only for Application:  ").append(LicensedObject.formatString(this.sApplication)).append('\n');
            }
            if (this.lDateFrom > 0L || this.lDateTo > 0L) {
                if (this.lDateFrom <= 0L) {
                    sb.append("Termination Date    :  ").append(LicensedObject.formatDate(this.lDateTo));
                } else if (this.lDateTo <= 0L) {
                    sb.append("Effective Date      :  ").append(LicensedObject.formatDate(this.lDateFrom));
                } else {
                    sb.append("License Term        :  ").append(LicensedObject.formatDate(this.lDateFrom)).append(" to ").append(LicensedObject.formatDate(this.lDateTo));
                }
                long lDateNow = System.currentTimeMillis();
                if (lDateNow < (this.lDateFrom <= 0L ? 0L : this.lDateFrom) || lDateNow > (this.lDateTo <= 0L ? Long.MAX_VALUE : this.lDateTo)) {
                    sb.append(" (expired)");
                }
                sb.append('\n');
            }
            if (this.cSeats > 0) {
                sb.append("Maximum Seats       :  ").append(this.cSeats).append('\n');
            }
            if (this.cUsers > 0) {
                sb.append("Maximum Users       :  ").append(this.cUsers).append('\n');
            }
            if (this.cServers > 0) {
                sb.append("Maximum Servers     :  ").append(this.cServers).append('\n');
            }
            if (this.cSockets > 0) {
                sb.append("Maximum CPU Sockets :  ").append(this.cSockets).append('\n');
            }
            if (this.cCpus > 0) {
                sb.append("Maximum CPU Cores   :  ").append(this.cCpus).append('\n');
            }
            return sb.toString();
        }
    }
}

