/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.schema.handler;

import com.oracle.coherence.common.base.Formatting;
import com.oracle.coherence.common.schema.AbstractPropertyHandler;
import com.oracle.coherence.common.schema.AbstractTypeHandler;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.util.AsmUtils;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.tree.AnnotationNode;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.FieldNode;
import com.tangosol.io.pof.DateMode;
import com.tangosol.io.pof.schema.PofArray;
import com.tangosol.io.pof.schema.PofCollection;
import com.tangosol.io.pof.schema.PofDate;
import com.tangosol.io.pof.schema.PofList;
import com.tangosol.io.pof.schema.PofMap;
import com.tangosol.io.pof.schema.PofProperty;
import com.tangosol.io.pof.schema.PofSet;
import com.tangosol.io.pof.schema.PofType;
import com.tangosol.io.pof.schema.annotation.Portable;
import com.tangosol.io.pof.schema.annotation.PortableArray;
import com.tangosol.io.pof.schema.annotation.PortableDate;
import com.tangosol.io.pof.schema.annotation.PortableList;
import com.tangosol.io.pof.schema.annotation.PortableMap;
import com.tangosol.io.pof.schema.annotation.PortableSet;
import com.tangosol.io.pof.schema.annotation.PortableType;
import java.nio.charset.StandardCharsets;

public class ClassFileHandler {
    private static final Class[] PORTABLE_ANNOTATIONS = new Class[]{Portable.class, PortableArray.class, PortableDate.class, PortableList.class, PortableMap.class, PortableSet.class};

    public static class ClassFilePropertyHandler
    extends AbstractPropertyHandler<PofProperty, FieldNode> {
        @Override
        public PofProperty createProperty(ExtensibleProperty parent) {
            return new PofProperty(parent);
        }

        @Override
        public void importProperty(PofProperty property, FieldNode source, Schema schema) {
            property.setName(source.name);
            AnnotationNode an = AsmUtils.getAnnotation(source, PORTABLE_ANNOTATIONS);
            if (an != null) {
                property.setSince((Integer)AsmUtils.getAnnotationAttribute(an, "since"));
                property.setOrder((Integer)AsmUtils.getAnnotationAttribute(an, "order"));
                if (an.desc.endsWith("PortableDate;")) {
                    property.setInfo(new PofDate((DateMode)((Object)AsmUtils.getAnnotationAttribute(an, "mode")), (Boolean)AsmUtils.getAnnotationAttribute(an, "includeTimezone")));
                }
                if (an.desc.endsWith("PortableArray;")) {
                    property.setInfo(new PofArray(((Type)AsmUtils.getAnnotationAttribute(an, "elementClass")).getClassName(), (Boolean)AsmUtils.getAnnotationAttribute(an, "useRawEncoding")));
                }
                if (an.desc.endsWith("PortableCollection;")) {
                    property.setInfo(new PofCollection(((Type)AsmUtils.getAnnotationAttribute(an, "clazz")).getClassName(), ((Type)AsmUtils.getAnnotationAttribute(an, "elementClass")).getClassName()));
                }
                if (an.desc.endsWith("PortableList;")) {
                    property.setInfo(new PofList(((Type)AsmUtils.getAnnotationAttribute(an, "clazz")).getClassName(), ((Type)AsmUtils.getAnnotationAttribute(an, "elementClass")).getClassName()));
                }
                if (an.desc.endsWith("PortableSet;")) {
                    property.setInfo(new PofSet(((Type)AsmUtils.getAnnotationAttribute(an, "clazz")).getClassName(), ((Type)AsmUtils.getAnnotationAttribute(an, "elementClass")).getClassName()));
                }
                if (an.desc.endsWith("PortableMap;")) {
                    property.setInfo(new PofMap(((Type)AsmUtils.getAnnotationAttribute(an, "clazz")).getClassName(), ((Type)AsmUtils.getAnnotationAttribute(an, "keyClass")).getClassName(), ((Type)AsmUtils.getAnnotationAttribute(an, "valueClass")).getClassName()));
                }
            }
        }
    }

    public static class ClassFileTypeHandler
    extends AbstractTypeHandler<PofType, ClassNode> {
        @Override
        public PofType createType(ExtensibleType parent) {
            return new PofType(parent);
        }

        @Override
        public void importType(PofType type, ClassNode source, Schema schema) {
            AnnotationNode an = AsmUtils.getAnnotation(source, PortableType.class);
            if (an != null) {
                int id = (Integer)AsmUtils.getAnnotationAttribute(an, "id");
                type.setId(id > 0 ? id : Math.abs(Formatting.toCrc(type.getFullName().getBytes(StandardCharsets.UTF_8))));
                type.setVersion((Integer)AsmUtils.getAnnotationAttribute(an, "version"));
            }
        }
    }
}

