/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.reflect.AbstractPofPath;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.util.Arrays;

public class SimplePofPath
extends AbstractPofPath {
    private int[] m_aiElements;

    public SimplePofPath() {
    }

    public SimplePofPath(int nIndex) {
        this.m_aiElements = new int[]{nIndex};
    }

    public SimplePofPath(int[] anIndices) {
        SimplePofPath.azzert(anIndices != null, "Indices array must not be null");
        this.m_aiElements = anIndices;
    }

    @Override
    protected int[] getPathElements() {
        return this.m_aiElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimplePofPath) {
            SimplePofPath that = (SimplePofPath)o;
            return Arrays.equals(this.m_aiElements, that.m_aiElements);
        }
        return false;
    }

    public int hashCode() {
        int[] ai = this.m_aiElements;
        return HashHelper.hash(ai, ai.length);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(indices=" + SimplePofPath.toDelimitedString(this.m_aiElements, ".") + ")";
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aiElements = in.readIntArray(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        int[] aiElements = this.m_aiElements;
        if (aiElements == null) {
            throw new NotActiveException("SimplePofPath was constructed without indices");
        }
        out.writeIntArray(0, aiElements);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_aiElements = (int[])ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int[] aiElements = this.m_aiElements;
        if (aiElements == null) {
            throw new NotActiveException("SimplePofPath was constructed without indices");
        }
        ExternalizableHelper.writeObject(out, aiElements);
    }
}

