/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.generator;

import com.oracle.coherence.common.schema.ClassFileSchemaSource;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.SchemaBuilder;
import com.oracle.coherence.common.schema.util.AsmUtils;
import com.tangosol.internal.asm.ClassReader;
import com.tangosol.internal.asm.ClassWriter;
import com.tangosol.internal.asm.Label;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.commons.Method;
import com.tangosol.internal.asm.tree.AnnotationNode;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.FieldNode;
import com.tangosol.internal.asm.tree.MethodNode;
import com.tangosol.io.pof.DateMode;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.io.pof.schema.PofArray;
import com.tangosol.io.pof.schema.PofCollection;
import com.tangosol.io.pof.schema.PofDate;
import com.tangosol.io.pof.schema.PofMap;
import com.tangosol.io.pof.schema.PofProperty;
import com.tangosol.io.pof.schema.PofType;
import com.tangosol.io.pof.schema.annotation.PortableType;
import com.tangosol.io.pof.schema.annotation.internal.Instrumented;
import com.tangosol.io.pof.schema.annotation.internal.PofIndex;
import com.tangosol.util.Binary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class PortableTypeGenerator {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Set<Integer> RAW_ENCODING_TYPES = Set.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(6), Integer.valueOf(8));
    private static final AnnotationNode JSONB_TRANSIENT = new AnnotationNode("Ljakarta/json/bind/annotation/JsonbTransient;");
    private Schema m_schema;
    private Logger m_log;
    private boolean m_fDebug;
    private ClassNode m_classNode;
    private PofType m_type;
    private TreeMap<Integer, SortedSet<PofProperty>> m_mapProperties = new TreeMap();
    private Map<String, FieldNode> m_mapFields;

    public PortableTypeGenerator(Schema schema, InputStream in) throws IOException {
        this(schema, in, false);
    }

    public PortableTypeGenerator(Schema schema, InputStream in, boolean fDebug) throws IOException {
        this(schema, in, fDebug, (Logger)new CoherenceLogger());
    }

    public PortableTypeGenerator(Schema schema, InputStream in, boolean fDebug, Logger logger) throws IOException {
        this(schema, new ClassReader(in), fDebug, logger);
    }

    public PortableTypeGenerator(Schema schema, byte[] bytes, int nOffset, int nLen, boolean fDebug, Logger logger) {
        this(schema, new ClassReader(bytes, nOffset, nLen), fDebug, logger);
    }

    public PortableTypeGenerator(Schema schema, ClassReader reader, boolean fDebug, Logger logger) {
        this.m_schema = schema;
        this.m_fDebug = fDebug;
        this.m_log = logger;
        ClassNode cn = new ClassNode();
        reader.accept(cn, 0);
        this.m_classNode = cn;
        ExtensibleType type = this.m_schema.findTypeByJavaName(AsmUtils.javaName(cn.name));
        if (type != null) {
            this.m_type = type.getExtension(PofType.class);
        }
    }

    public boolean instrumentClass() {
        String fullName = AsmUtils.javaName(this.m_classNode.name);
        if (this.m_type != null && this.m_type.getId() != 0 && !this.isEnum() && !this.isInstrumented()) {
            this.m_log.info("Instrumenting type " + fullName);
            this.ensureTypeId();
            this.populatePropertyMap();
            this.populateFieldMap();
            this.implementDeserializationConstructor();
            this.implementEvolvableObject();
            AsmUtils.addAnnotation(this.m_classNode, new AnnotationNode(Type.getDescriptor(Instrumented.class)));
            return true;
        }
        String reason = this.m_type == null ? "Type does not exist in the schema or PofType extension is not defined" : (this.isEnum() ? "Type is an enumeration" : "Type is already instrumented");
        this.m_log.debug("Skipping type " + fullName + ". " + reason);
        return false;
    }

    public byte[] getClassBytes() {
        ClassWriter writer = new ClassWriter(1);
        this.m_classNode.accept(writer);
        return writer.toByteArray();
    }

    public void writeClass(OutputStream out) throws IOException {
        out.write(this.getClassBytes());
    }

    private void implementEvolvableObject() {
        boolean fDelegateToSuper = this.isPofType(this.m_classNode.superName);
        this.m_classNode.interfaces.add("com/tangosol/io/pof/EvolvableObject");
        FieldNode evolvable = new FieldNode(130, "__evolvable$" + this.m_type.getId(), "Lcom/tangosol/io/Evolvable;", null, null);
        AsmUtils.addAnnotation(evolvable, JSONB_TRANSIENT);
        this.m_classNode.fields.add(evolvable);
        FieldNode holder = new FieldNode(130, "__evolvableHolder$", "Lcom/tangosol/io/pof/EvolvableHolder;", null, null);
        AsmUtils.addAnnotation(holder, JSONB_TRANSIENT);
        this.m_classNode.fields.add(holder);
        this.implementGetEvolvable(fDelegateToSuper, evolvable, holder);
        if (!fDelegateToSuper) {
            this.implementGetEvolvableHolder(holder);
        }
        this.implementWriteExternal();
    }

    private void implementDeserializationConstructor() {
        MethodNode ctor = this.findMethod("<init>", "(Lcom/tangosol/io/pof/PofReader;)V");
        if (ctor == null) {
            ctor = new MethodNode(1, "<init>", "(Lcom/tangosol/io/pof/PofReader;)V", null, new String[]{"java/io/IOException"});
            boolean fDelegateToSuper = this.isPofType(this.m_classNode.superName);
            ctor.visitCode();
            ctor.visitVarInsn(25, 0);
            if (fDelegateToSuper) {
                ctor.visitVarInsn(25, 1);
                ctor.visitMethodInsn(183, this.m_classNode.superName, "<init>", "(Lcom/tangosol/io/pof/PofReader;)V", false);
            } else {
                MethodNode defaultCtor = this.findMethod("<init>", "()V");
                String owner = defaultCtor == null ? this.m_classNode.superName : this.m_classNode.name;
                ctor.visitMethodInsn(183, owner, "<init>", "()V", false);
            }
            ctor.visitVarInsn(25, 1);
            ctor.visitLdcInsn(this.m_type.getId());
            ctor.visitMethodInsn(185, "com/tangosol/io/pof/PofReader", "createNestedPofReader", "(I)Lcom/tangosol/io/pof/PofReader;", true);
            ctor.visitVarInsn(58, 2);
            int cPofFields = 0;
            for (int version : this.m_mapProperties.keySet()) {
                ctor.visitVarInsn(25, 2);
                ctor.visitLdcInsn(version);
                ctor.visitMethodInsn(185, "com/tangosol/io/pof/PofReader", "version", "(I)Lcom/tangosol/io/pof/PofReader;", true);
                ctor.visitVarInsn(58, 3);
                SortedSet<PofProperty> properties = this.m_mapProperties.get(version);
                for (PofProperty property : properties) {
                    FieldNode field = this.field(property);
                    if (field == null) {
                        this.m_log.debug("Field for property " + property.getName() + " was not found");
                        continue;
                    }
                    if ((field.access & 8) != 0 || (field.access & 0x80) != 0) continue;
                    int nPofIndex = cPofFields++;
                    Type type = Type.getType(field.desc);
                    if (this.isDebugEnabled()) {
                        ctor.visitLdcInsn("reading attribute " + nPofIndex + " (" + property.getName() + ") from the POF stream");
                        ctor.visitMethodInsn(184, "com/tangosol/io/pof/generator/DebugLogger", "log", "(Ljava/lang/String;)V", false);
                    }
                    ctor.visitVarInsn(25, 0);
                    ctor.visitVarInsn(25, 3);
                    ctor.visitLdcInsn(nPofIndex);
                    ReadMethod readMethod = this.getReadMethod(property, type);
                    readMethod.createTemplate(ctor, property, type);
                    ctor.visitMethodInsn(185, "com/tangosol/io/pof/PofReader", readMethod.getName(), readMethod.getDescriptor(), true);
                    if (type.getSort() == 10 || "readObjectArray".equals(readMethod.getName())) {
                        ctor.visitTypeInsn(192, type.getInternalName());
                    }
                    ctor.visitFieldInsn(181, this.m_classNode.name, field.name, field.desc);
                }
            }
            ctor.visitVarInsn(25, 0);
            ctor.visitVarInsn(25, 2);
            ctor.visitMethodInsn(182, this.m_classNode.name, "readEvolvable", "(Lcom/tangosol/io/pof/PofReader;)V", false);
            ctor.visitInsn(177);
            ctor.visitMaxs(0, 0);
            ctor.visitEnd();
            this.m_classNode.methods.add(ctor);
            this.m_log.debug("Implemented deserialization constructor");
        } else if ((ctor.access & 1) == 0) {
            this.m_log.debug("Class " + this.m_classNode.name + " has a non-public deserialization constructor. Making it public.");
            ctor.access = 1;
        }
    }

    private void implementGetEvolvable(boolean fDelegateToSuper, FieldNode evolvable, FieldNode holder) {
        MethodNode mn = new MethodNode(1, "getEvolvable", "(I)Lcom/tangosol/io/Evolvable;", null, null);
        AsmUtils.addAnnotation(mn, JSONB_TRANSIENT);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, this.m_classNode.name, evolvable.name, evolvable.desc);
        Label l0 = new Label();
        mn.visitJumpInsn(199, l0);
        mn.visitVarInsn(25, 0);
        mn.visitTypeInsn(187, "com/tangosol/io/SimpleEvolvable");
        mn.visitInsn(89);
        mn.visitLdcInsn(this.m_type.getVersion());
        mn.visitMethodInsn(183, "com/tangosol/io/SimpleEvolvable", "<init>", "(I)V", false);
        mn.visitFieldInsn(181, this.m_classNode.name, evolvable.name, evolvable.desc);
        mn.visitLabel(l0);
        mn.visitFrame(3, 0, null, 0, null);
        mn.visitVarInsn(21, 1);
        mn.visitLdcInsn(this.m_type.getId());
        Label l1 = new Label();
        mn.visitJumpInsn(159, l1);
        mn.visitVarInsn(25, 0);
        mn.visitMethodInsn(182, this.m_classNode.name, "getEvolvableHolder", "()Lcom/tangosol/io/pof/EvolvableHolder;", false);
        mn.visitMethodInsn(182, "com/tangosol/io/pof/EvolvableHolder", "isEmpty", "()Z", false);
        Label l2 = new Label();
        mn.visitJumpInsn(153, l2);
        mn.visitLabel(l1);
        mn.visitFrame(3, 0, null, 0, null);
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, this.m_classNode.name, evolvable.name, evolvable.desc);
        Label l3 = new Label();
        mn.visitJumpInsn(167, l3);
        mn.visitLabel(l2);
        mn.visitFrame(3, 0, null, 0, null);
        if (fDelegateToSuper) {
            mn.visitVarInsn(25, 0);
            mn.visitVarInsn(21, 1);
            mn.visitMethodInsn(183, this.m_classNode.superName, "getEvolvable", "(I)Lcom/tangosol/io/Evolvable;", false);
        } else {
            mn.visitVarInsn(25, 0);
            mn.visitMethodInsn(182, this.m_classNode.name, "getEvolvableHolder", "()Lcom/tangosol/io/pof/EvolvableHolder;", false);
            mn.visitVarInsn(21, 1);
            mn.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            mn.visitMethodInsn(182, "com/tangosol/io/pof/EvolvableHolder", "get", "(Ljava/lang/Integer;)Lcom/tangosol/io/Evolvable;", false);
        }
        mn.visitLabel(l3);
        mn.visitFrame(4, 0, null, 1, new Object[]{"com/tangosol/io/Evolvable"});
        mn.visitInsn(176);
        mn.visitMaxs(0, 0);
        mn.visitEnd();
        if (!this.hasMethod(mn)) {
            this.m_classNode.methods.add(mn);
        }
        this.m_log.debug("Implemented method: " + mn.name);
    }

    private void implementGetEvolvableHolder(FieldNode holder) {
        MethodNode mn = new MethodNode(1, "getEvolvableHolder", "()Lcom/tangosol/io/pof/EvolvableHolder;", null, null);
        AsmUtils.addAnnotation(mn, JSONB_TRANSIENT);
        mn.visitCode();
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, this.m_classNode.name, holder.name, holder.desc);
        Label l0 = new Label();
        mn.visitJumpInsn(199, l0);
        mn.visitVarInsn(25, 0);
        mn.visitTypeInsn(187, "com/tangosol/io/pof/EvolvableHolder");
        mn.visitInsn(89);
        mn.visitMethodInsn(183, "com/tangosol/io/pof/EvolvableHolder", "<init>", "()V", false);
        mn.visitFieldInsn(181, this.m_classNode.name, holder.name, holder.desc);
        mn.visitLabel(l0);
        mn.visitFrame(3, 0, null, 0, null);
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, this.m_classNode.name, holder.name, holder.desc);
        mn.visitInsn(176);
        mn.visitMaxs(0, 0);
        mn.visitEnd();
        if (!this.hasMethod(mn)) {
            this.m_classNode.methods.add(mn);
        }
        this.m_log.debug("Implemented method: " + mn.name);
    }

    private void implementWriteExternal() {
        MethodNode mn = new MethodNode(1, "writeExternal", "(Lcom/tangosol/io/pof/PofWriter;)V", null, new String[]{"java/io/IOException"});
        mn.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        boolean fDelegateToSuper = this.isPofType(this.m_classNode.superName);
        mn.visitVarInsn(25, 1);
        mn.visitMethodInsn(185, "com/tangosol/io/pof/PofWriter", "getUserTypeId", "()I", true);
        mn.visitLdcInsn(this.m_type.getId());
        mn.visitJumpInsn(160, l0);
        int cPofFields = 0;
        for (int version : this.m_mapProperties.keySet()) {
            SortedSet<PofProperty> properties = this.m_mapProperties.get(version);
            for (PofProperty property : properties) {
                FieldNode field = this.field(property);
                if ((field.access & 8) != 0 || (field.access & 0x80) != 0) continue;
                int nPofIndex = cPofFields++;
                this.addPofIndex(field, nPofIndex);
                Type type = Type.getType(field.desc);
                if (this.isDebugEnabled()) {
                    mn.visitLdcInsn("writing attribute " + nPofIndex + " (" + property.getName() + ") to POF stream");
                    mn.visitMethodInsn(184, "com/tangosol/io/pof/generator/DebugLogger", "log", "(Ljava/lang/String;)V", false);
                }
                mn.visitVarInsn(25, 1);
                mn.visitLdcInsn(nPofIndex);
                mn.visitVarInsn(25, 0);
                mn.visitFieldInsn(180, this.m_classNode.name, field.name, field.desc);
                if (this.isRawEncodingSupported(type)) {
                    if (property.isArray()) {
                        PofArray pofArray = property.asArray();
                        mn.visitLdcInsn(pofArray.isUseRawEncoding());
                    } else {
                        mn.visitLdcInsn(false);
                    }
                }
                WriteMethod writeMethod = this.getWriteMethod(property, type);
                writeMethod.pushUniformTypes(mn);
                mn.visitMethodInsn(185, "com/tangosol/io/pof/PofWriter", writeMethod.getName(), writeMethod.getDescriptor(), true);
            }
        }
        if (fDelegateToSuper) {
            mn.visitJumpInsn(167, l1);
        }
        mn.visitLabel(l0);
        mn.visitFrame(3, 0, null, 0, null);
        if (fDelegateToSuper) {
            mn.visitVarInsn(25, 0);
            mn.visitVarInsn(25, 1);
            mn.visitMethodInsn(183, this.m_classNode.superName, "writeExternal", "(Lcom/tangosol/io/pof/PofWriter;)V", false);
            mn.visitLabel(l1);
            mn.visitFrame(3, 0, null, 0, null);
        }
        mn.visitInsn(177);
        mn.visitMaxs(0, 0);
        mn.visitEnd();
        if (!this.hasMethod(mn)) {
            this.m_classNode.methods.add(mn);
        }
        this.m_log.debug("Implemented method: " + mn.name);
    }

    private boolean isRawEncodingSupported(Type type) {
        return type.getSort() == 9 && RAW_ENCODING_TYPES.contains(type.getElementType().getSort());
    }

    public static void instrumentClasses(File classDir, Schema schema) throws IOException {
        PortableTypeGenerator.instrumentClasses(classDir, schema, false, new ConsoleLogger());
    }

    public static void instrumentClasses(File classDir, Schema schema, boolean fDebug, Logger logger) throws IOException {
        if (!classDir.exists()) {
            throw new IllegalArgumentException("Specified path [" + classDir.getAbsolutePath() + "] does not exist");
        }
        if (!classDir.isDirectory()) {
            throw new IllegalArgumentException("Specified path [" + classDir.getAbsolutePath() + "] is not a directory");
        }
        File[] files = classDir.listFiles();
        if (files != null) {
            for (File file : files) {
                PortableTypeGenerator gen;
                if (file.isDirectory()) {
                    PortableTypeGenerator.instrumentClasses(file, schema, fDebug, logger);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                try (FileInputStream in = new FileInputStream(file);){
                    gen = new PortableTypeGenerator(schema, in, fDebug, logger);
                }
                if (!gen.instrumentClass()) continue;
                try (FileOutputStream out = new FileOutputStream(file);){
                    gen.writeClass(out);
                    out.flush();
                }
            }
        }
    }

    public static byte[] instrumentClass(File fileClass, byte[] abByteCode, int nOffset, int nLen, Properties properties) {
        return PortableTypeGenerator.instrumentClass(fileClass, abByteCode, nOffset, nLen, properties, Collections.emptyMap());
    }

    public static byte[] instrumentClass(File fileClass, byte[] abByteCode, int nOffset, int nLen, Properties properties, Map<String, ?> env) {
        boolean fDebug;
        PortableTypeGenerator generator;
        Schema schema = (Schema)env.get("schema");
        if (schema == null) {
            schema = PortableTypeGenerator.createSchema(fileClass, env);
        }
        if ((generator = new PortableTypeGenerator(schema, abByteCode, nOffset, nLen, fDebug = Boolean.parseBoolean(properties.getProperty("debug", "false")), new NullLogger())).instrumentClass()) {
            return generator.getClassBytes();
        }
        return null;
    }

    public static Schema createSchema(File fileClass, Map<String, ?> env) {
        ClassFileSchemaSource schemaSource = new ClassFileSchemaSource().withClassFile(fileClass).withTypeFilter(ClassFileSchemaSource.Filters.hasAnnotation(PortableType.class)).withMissingPropertiesAsObject();
        List listLibs = (List)env.get("libs");
        if (listLibs != null) {
            listLibs.stream().filter(f -> f.isFile() && f.getName().endsWith(".jar")).forEach(schemaSource::withClassesFromJarFile);
            listLibs.stream().filter(File::isDirectory).forEach(schemaSource::withClassesFromDirectory);
        }
        return new SchemaBuilder().addSchemaSource(schemaSource).build();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: PortableTypeGenerator <classDir> [-debug]");
            System.exit(0);
        }
        File classDir = new File(args[0]);
        boolean fDebug = args.length >= 2 && args[1].equals("-debug");
        Schema schema = new SchemaBuilder().addSchemaSource(new ClassFileSchemaSource().withClassesFromDirectory(classDir)).build();
        PortableTypeGenerator.instrumentClasses(classDir, schema, fDebug, new ConsoleLogger());
    }

    private void ensureTypeId() {
        int nIdxId;
        AnnotationNode pt = AsmUtils.getAnnotation(this.m_classNode, PortableType.class);
        if (pt.values == null) {
            pt.values = new ArrayList<Object>();
        }
        if ((nIdxId = pt.values.indexOf("id")) == -1) {
            pt.values.add("id");
            pt.values.add(this.m_type.getId());
        }
    }

    private void populateFieldMap() {
        List<FieldNode> fields = this.m_classNode.fields;
        this.m_mapFields = new HashMap<String, FieldNode>(fields.size());
        for (FieldNode fn : fields) {
            this.m_mapFields.put(fn.name, fn);
        }
    }

    private void populatePropertyMap() {
        int count = 0;
        for (PofProperty p : this.m_type.getProperties()) {
            this.addProperty(p.getSince(), p);
            ++count;
        }
        this.m_log.debug("Found " + count + " properties across " + this.m_mapProperties.size() + " class version(s)");
    }

    private void addProperty(int version, PofProperty property) {
        SortedSet properties = this.m_mapProperties.computeIfAbsent(version, k -> new TreeSet());
        properties.add(property);
    }

    private boolean isPofType(String sInternalName) {
        ExtensibleType type = this.m_schema.findTypeByJavaName(AsmUtils.javaName(sInternalName));
        PofType pofType = type == null ? null : type.getExtension(PofType.class);
        return pofType != null && pofType.getId() > 0;
    }

    private FieldNode field(String name) {
        return this.m_mapFields.get(name);
    }

    private FieldNode field(Property property) {
        return this.field(property.getName());
    }

    private static Type type(String sJavaName) {
        return sJavaName == null ? OBJECT_TYPE : Type.getType("L" + AsmUtils.internalName(sJavaName) + ";");
    }

    private boolean isEnum() {
        return (this.m_classNode.access & 0x4000) == 16384;
    }

    private boolean isInstrumented() {
        return AsmUtils.hasAnnotation(this.m_classNode, Instrumented.class);
    }

    private MethodNode findMethod(String sName, String sDesc) {
        for (MethodNode node : this.m_classNode.methods) {
            if (!node.name.equals(sName) || !node.desc.equals(sDesc)) continue;
            return node;
        }
        return null;
    }

    private boolean hasMethod(MethodNode mn) {
        for (MethodNode node : this.m_classNode.methods) {
            if (!mn.name.equals(node.name) || !mn.desc.equals(node.desc)) continue;
            return true;
        }
        return false;
    }

    private boolean isDebugEnabled() {
        return this.m_fDebug;
    }

    protected void addPofIndex(FieldNode fn, int nIndex) {
        AnnotationNode an = new AnnotationNode(Type.getDescriptor(PofIndex.class));
        an.values = Arrays.asList("value", nIndex);
        AsmUtils.addAnnotation(fn, an);
    }

    private ReadMethod getReadMethod(PofProperty property, Type type) {
        switch (type.getSort()) {
            case 1: {
                return new ReadMethod("readBoolean", "(I)Z");
            }
            case 3: {
                return new ReadMethod("readByte", "(I)B");
            }
            case 2: {
                return new ReadMethod("readChar", "(I)C");
            }
            case 4: {
                return new ReadMethod("readShort", "(I)S");
            }
            case 5: {
                return new ReadMethod("readInt", "(I)I");
            }
            case 7: {
                return new ReadMethod("readLong", "(I)J");
            }
            case 6: {
                return new ReadMethod("readFloat", "(I)F");
            }
            case 8: {
                return new ReadMethod("readDouble", "(I)D");
            }
            case 9: {
                if ("[Z".equals(type.getDescriptor())) {
                    return new ReadMethod("readBooleanArray", "(I)[Z");
                }
                if ("[B".equals(type.getDescriptor())) {
                    return new ReadMethod("readByteArray", "(I)[B");
                }
                if ("[C".equals(type.getDescriptor())) {
                    return new ReadMethod("readCharArray", "(I)[C");
                }
                if ("[S".equals(type.getDescriptor())) {
                    return new ReadMethod("readShortArray", "(I)[S");
                }
                if ("[I".equals(type.getDescriptor())) {
                    return new ReadMethod("readIntArray", "(I)[I");
                }
                if ("[J".equals(type.getDescriptor())) {
                    return new ReadMethod("readLongArray", "(I)[J");
                }
                if ("[F".equals(type.getDescriptor())) {
                    return new ReadMethod("readFloatArray", "(I)[F");
                }
                if ("[D".equals(type.getDescriptor())) {
                    return new ReadMethod("readDoubleArray", "(I)[D");
                }
                return new ObjectArrayReadMethod();
            }
        }
        String sClassName = type.getClassName();
        if (sClassName.equals(String.class.getName())) {
            return new ReadMethod("readString", "(I)Ljava/lang/String;");
        }
        if (sClassName.equals(Date.class.getName())) {
            return new ReadMethod("readDate", "(I)Ljava/util/Date;");
        }
        if (sClassName.equals(LocalDate.class.getName())) {
            return new ReadMethod("readLocalDate", "(I)Ljava/time/LocalDate;");
        }
        if (sClassName.equals(LocalDateTime.class.getName())) {
            return new ReadMethod("readLocalDateTime", "(I)Ljava/time/LocalDateTime;");
        }
        if (sClassName.equals(LocalTime.class.getName())) {
            return new ReadMethod("readLocalTime", "(I)Ljava/time/LocalTime;");
        }
        if (sClassName.equals(OffsetDateTime.class.getName())) {
            return new ReadMethod("readOffsetDateTime", "(I)Ljava/time/OffsetDateTime;");
        }
        if (sClassName.equals(OffsetTime.class.getName())) {
            return new ReadMethod("readOffsetTime", "(I)Ljava/time/OffsetTime;");
        }
        if (sClassName.equals(ZonedDateTime.class.getName())) {
            return new ReadMethod("readZonedDateTime", "(I)Ljava/time/ZonedDateTime;");
        }
        if (sClassName.equals(RawDate.class.getName())) {
            return new ReadMethod("readRawDate", "(I)Lcom/tangosol/io/pof/RawDate;");
        }
        if (sClassName.equals(RawDateTime.class.getName())) {
            return new ReadMethod("readRawDateTime", "(I)Lcom/tangosol/io/pof/RawDateTime;");
        }
        if (sClassName.equals(RawDayTimeInterval.class.getName())) {
            return new ReadMethod("readRawDayTimeInterval", "(I)Lcom/tangosol/io/pof/RawDayTimeInterval;");
        }
        if (sClassName.equals(RawQuad.class.getName())) {
            return new ReadMethod("readRawQuad", "(I)Lcom/tangosol/io/pof/RawQuad;");
        }
        if (sClassName.equals(RawTime.class.getName())) {
            return new ReadMethod("readRawTime", "(I)Lcom/tangosol/io/pof/RawTime;");
        }
        if (sClassName.equals(RawTimeInterval.class.getName())) {
            return new ReadMethod("readRawTimeInterval", "(I)Lcom/tangosol/io/pof/RawTimeInterval;");
        }
        if (sClassName.equals(RawYearMonthInterval.class.getName())) {
            return new ReadMethod("readRawYearMonthInterval", "(I)Lcom/tangosol/io/pof/RawYearMonthInterval;");
        }
        if (sClassName.equals(BigDecimal.class.getName())) {
            return new ReadMethod("readBigDecimal", "(I)Ljava/math/BigDecimal;");
        }
        if (sClassName.equals(BigInteger.class.getName())) {
            return new ReadMethod("readBigInteger", "(I)Ljava/math/BigInteger;");
        }
        if (sClassName.equals(Binary.class.getName())) {
            return new ReadMethod("readBinary", "(I)Lcom/tangosol/util/Binary;");
        }
        if (property.isCollection()) {
            return new CollectionReadMethod();
        }
        if (property.isMap()) {
            return new MapReadMethod();
        }
        return new ReadMethod("readObject", "(I)Ljava/lang/Object;");
    }

    private WriteMethod getWriteMethod(PofProperty property, Type type) {
        switch (type.getSort()) {
            case 1: {
                return new WriteMethod("writeBoolean", "(IZ)V");
            }
            case 3: {
                return new WriteMethod("writeByte", "(IB)V");
            }
            case 2: {
                return new WriteMethod("writeChar", "(IC)V");
            }
            case 8: {
                return new WriteMethod("writeDouble", "(ID)V");
            }
            case 6: {
                return new WriteMethod("writeFloat", "(IF)V");
            }
            case 5: {
                return new WriteMethod("writeInt", "(II)V");
            }
            case 7: {
                return new WriteMethod("writeLong", "(IJ)V");
            }
            case 4: {
                return new WriteMethod("writeShort", "(IS)V");
            }
            case 9: {
                if ("[Z".equals(type.getDescriptor())) {
                    return new WriteMethod("writeBooleanArray", "(I[Z)V");
                }
                if ("[B".equals(type.getDescriptor())) {
                    return new WriteMethod("writeByteArray", "(I[B)V");
                }
                if ("[C".equals(type.getDescriptor())) {
                    return new WriteMethod("writeCharArray", "(I[CZ)V");
                }
                if ("[D".equals(type.getDescriptor())) {
                    return new WriteMethod("writeDoubleArray", "(I[DZ)V");
                }
                if ("[F".equals(type.getDescriptor())) {
                    return new WriteMethod("writeFloatArray", "(I[FZ)V");
                }
                if ("[I".equals(type.getDescriptor())) {
                    return new WriteMethod("writeIntArray", "(I[IZ)V");
                }
                if ("[J".equals(type.getDescriptor())) {
                    return new WriteMethod("writeLongArray", "(I[JZ)V");
                }
                if ("[S".equals(type.getDescriptor())) {
                    return new WriteMethod("writeShortArray", "(I[SZ)V");
                }
                return this.getObjectArrayWriteMethod(property, type);
            }
        }
        String sClassName = type.getClassName();
        if (sClassName.equals(String.class.getName())) {
            return new WriteMethod("writeString", "(ILjava/lang/String;)V");
        }
        if (sClassName.equals(BigDecimal.class.getName())) {
            return new WriteMethod("writeBigDecimal", "(ILjava/math/BigDecimal;)V");
        }
        if (sClassName.equals(BigInteger.class.getName())) {
            return new WriteMethod("writeBigInteger", "(ILjava/math/BigInteger;)V");
        }
        if (sClassName.equals(Binary.class.getName())) {
            return new WriteMethod("writeBinary", "(ILcom/tangosol/util/Binary;)V");
        }
        if (sClassName.equals(LocalDate.class.getName())) {
            return new WriteMethod("writeDate", "(ILjava/time/LocalDate;)V");
        }
        if (sClassName.equals(LocalDateTime.class.getName())) {
            return new WriteMethod("writeDateTime", "(ILjava/time/LocalDateTime;)V");
        }
        if (sClassName.equals(LocalTime.class.getName())) {
            return new WriteMethod("writeTime", "(ILjava/time/LocalTime;)V");
        }
        if (sClassName.equals(OffsetDateTime.class.getName())) {
            return new WriteMethod("writeDateTimeWithZone", "(ILjava/time/OffsetDateTime;)V");
        }
        if (sClassName.equals(OffsetTime.class.getName())) {
            return new WriteMethod("writeTimeWithZone", "(ILjava/time/OffsetTime;)V");
        }
        if (sClassName.equals(ZonedDateTime.class.getName())) {
            return new WriteMethod("writeDateTimeWithZone", "(ILjava/time/ZonedDateTime;)V");
        }
        if (sClassName.equals(Date.class.getName())) {
            return this.getDateWriteMethod(property, type);
        }
        if (sClassName.equals("java.sql.Timestamp")) {
            return this.getDateWriteMethod(property, type);
        }
        if (property.isCollection()) {
            return this.getCollectionWriteMethod(property, type);
        }
        if (property.isMap()) {
            return this.getMapWriteMethod(property, type);
        }
        if (sClassName.equals(RawDate.class.getName())) {
            return new WriteMethod("writeRawDate", "(ILcom/tangosol/io/pof/RawDate;)V");
        }
        if (sClassName.equals(RawDateTime.class.getName())) {
            return new WriteMethod("writeRawDateTime", "(ILcom/tangosol/io/pof/RawDateTime;)V");
        }
        if (sClassName.equals(RawDayTimeInterval.class.getName())) {
            return new WriteMethod("writeRawDayTimeInterval", "(ILcom/tangosol/io/pof/RawDayTimeInterval;)V");
        }
        if (sClassName.equals(RawQuad.class.getName())) {
            return new WriteMethod("writeRawQuad", "(ILcom/tangosol/io/pof/RawQuad;)V");
        }
        if (sClassName.equals(RawTime.class.getName())) {
            return new WriteMethod("writeRawTime", "(ILcom/tangosol/io/pof/RawTime;)V");
        }
        if (sClassName.equals(RawTimeInterval.class.getName())) {
            return new WriteMethod("writeRawTimeInterval", "(ILcom/tangosol/io/pof/RawTimeInterval;)V");
        }
        if (sClassName.equals(RawYearMonthInterval.class.getName())) {
            return new WriteMethod("writeRawYearMonthInterval", "(ILcom/tangosol/io/pof/RawYearMonthInterval;)V");
        }
        return new WriteMethod("writeObject", "(ILjava/lang/Object;)V");
    }

    private WriteMethod getDateWriteMethod(PofProperty property, Type type) {
        Object name = "writeDateTime";
        String desc = "(I" + type.getDescriptor() + ")V";
        PofDate pd = property.asDate();
        if (pd != null) {
            DateMode mode = pd.getMode();
            switch (mode) {
                case DATE: {
                    name = "writeDate";
                    break;
                }
                case TIME: {
                    name = "writeTime";
                    break;
                }
                case DATE_TIME: {
                    name = "writeDateTime";
                }
            }
            if (mode != DateMode.DATE && pd.isIncludeTimezone()) {
                name = (String)name + "WithZone";
            }
        }
        return new WriteMethod((String)name, desc);
    }

    private WriteMethod getCollectionWriteMethod(PofProperty property, Type type) {
        Type elementClass = OBJECT_TYPE;
        PofCollection col = property.asCollection();
        if (col != null) {
            elementClass = PortableTypeGenerator.type(col.getElementClass());
        }
        return new CollectionWriteMethod(elementClass);
    }

    private WriteMethod getMapWriteMethod(PofProperty property, Type type) {
        Type keyClass = OBJECT_TYPE;
        Type valueClass = OBJECT_TYPE;
        PofMap map = property.asMap();
        if (map != null && !OBJECT_TYPE.equals(keyClass = PortableTypeGenerator.type(map.getKeyClass()))) {
            valueClass = PortableTypeGenerator.type(map.getValueClass());
        }
        return new MapWriteMethod(keyClass, valueClass);
    }

    private WriteMethod getObjectArrayWriteMethod(PofProperty property, Type type) {
        Type elementClass = OBJECT_TYPE;
        PofArray array = property.asArray();
        if (array != null) {
            elementClass = PortableTypeGenerator.type(array.getElementClass());
        }
        return new ObjectArrayWriteMethod(elementClass);
    }

    public static class CoherenceLogger
    implements Logger {
        @Override
        public void debug(String message) {
            com.oracle.coherence.common.base.Logger.finer(message);
        }

        @Override
        public void info(String message) {
            com.oracle.coherence.common.base.Logger.info(message);
        }
    }

    public static interface Logger {
        public void debug(String var1);

        public void info(String var1);
    }

    private static class ReadMethod
    extends Method {
        ReadMethod(String name, String desc) {
            super(name, desc);
        }

        public void createTemplate(MethodNode mn, PofProperty property, Type type) {
        }
    }

    private static class WriteMethod
    extends Method {
        WriteMethod(String name, String desc) {
            super(name, desc);
        }

        public void pushUniformTypes(MethodNode mn) {
        }
    }

    public static class ConsoleLogger
    implements Logger {
        @Override
        public void debug(String message) {
            System.out.println("[DEBUG] " + message);
        }

        @Override
        public void info(String message) {
            System.out.println("[INFO] " + message);
        }
    }

    public static class NullLogger
    implements Logger {
        @Override
        public void debug(String message) {
        }

        @Override
        public void info(String message) {
        }
    }

    private static class ObjectArrayReadMethod
    extends ReadMethod {
        ObjectArrayReadMethod() {
            super("readObjectArray", "(I[Ljava/lang/Object;)[Ljava/lang/Object;");
        }

        @Override
        public void createTemplate(MethodNode mn, PofProperty field, Type type) {
            mn.visitInsn(3);
            mn.visitTypeInsn(189, type.getElementType().getInternalName());
        }
    }

    private class CollectionReadMethod
    extends ReadMethod {
        CollectionReadMethod() {
            this("readCollection", "(ILjava/util/Collection;)Ljava/util/Collection;");
        }

        CollectionReadMethod(String name, String desc) {
            super(name, desc);
        }

        @Override
        public void createTemplate(MethodNode mn, PofProperty property, Type type) {
            Type clazz = this.getCollectionType(property);
            if (clazz.equals(Type.getType(Object.class))) {
                clazz = this.getDefaultClass(property, type);
            }
            mn.visitLdcInsn(clazz);
            mn.visitMethodInsn(184, Type.getInternalName(AsmUtils.class), "createInstance", "(Ljava/lang/Class;)Ljava/lang/Object;", false);
        }

        protected Type getCollectionType(PofProperty property) {
            PofCollection col = property.asCollection();
            return PortableTypeGenerator.type(col.getCollectionClass());
        }

        protected Type getDefaultClass(PofProperty property, Type type) {
            if (property.isSet()) {
                return Type.getType(HashSet.class);
            }
            if (property.isList()) {
                return Type.getType(ArrayList.class);
            }
            if (property.isMap()) {
                return Type.getType(HashMap.class);
            }
            throw new IllegalStateException("Property " + PortableTypeGenerator.this.m_classNode.name + "." + property.getName() + " must have explicitly defined class or factory");
        }
    }

    private class MapReadMethod
    extends CollectionReadMethod {
        MapReadMethod() {
            super("readMap", "(ILjava/util/Map;)Ljava/util/Map;");
        }

        @Override
        protected Type getCollectionType(PofProperty property) {
            PofMap map = property.asMap();
            return PortableTypeGenerator.type(map.getMapClass());
        }
    }

    private static class CollectionWriteMethod
    extends WriteMethod {
        private Type m_elementClass;

        CollectionWriteMethod(Type elementClass) {
            this("writeCollection", CollectionWriteMethod.createDescriptor(elementClass), elementClass);
        }

        CollectionWriteMethod(String name, String desc, Type elementClass) {
            super(name, desc);
            this.m_elementClass = elementClass;
        }

        private static String createDescriptor(Type elementClass) {
            Object desc = "(ILjava/util/Collection;";
            if (CollectionWriteMethod.isUniform(elementClass)) {
                desc = (String)desc + "Ljava/lang/Class;";
            }
            return (String)desc + ")V";
        }

        static boolean isUniform(Type elementClass) {
            return !OBJECT_TYPE.equals(elementClass);
        }

        @Override
        public void pushUniformTypes(MethodNode mn) {
            if (CollectionWriteMethod.isUniform(this.m_elementClass)) {
                mn.visitLdcInsn(this.m_elementClass);
            }
        }
    }

    private static class MapWriteMethod
    extends WriteMethod {
        private Type m_keyClass;
        private Type m_valueClass;

        MapWriteMethod(Type keyClass, Type valueClass) {
            super("writeMap", MapWriteMethod.createDescriptor(keyClass, valueClass));
            this.m_keyClass = keyClass;
            this.m_valueClass = valueClass;
        }

        private static String createDescriptor(Type keyClass, Type valueClass) {
            Object desc = "(ILjava/util/Map;";
            if (MapWriteMethod.isUniform(keyClass)) {
                desc = (String)desc + "Ljava/lang/Class;";
                if (MapWriteMethod.isUniform(valueClass)) {
                    desc = (String)desc + "Ljava/lang/Class;";
                }
            }
            return (String)desc + ")V";
        }

        static boolean isUniform(Type elementClass) {
            return !OBJECT_TYPE.equals(elementClass);
        }

        @Override
        public void pushUniformTypes(MethodNode mn) {
            if (MapWriteMethod.isUniform(this.m_keyClass)) {
                mn.visitLdcInsn(this.m_keyClass);
                if (MapWriteMethod.isUniform(this.m_valueClass)) {
                    mn.visitLdcInsn(this.m_valueClass);
                }
            }
        }
    }

    private static class ObjectArrayWriteMethod
    extends CollectionWriteMethod {
        ObjectArrayWriteMethod(Type elementClass) {
            super("writeObjectArray", ObjectArrayWriteMethod.createDescriptor(elementClass), elementClass);
        }

        private static String createDescriptor(Type elementClass) {
            Object desc = "(I[Ljava/lang/Object;";
            if (ObjectArrayWriteMethod.isUniform(elementClass)) {
                desc = (String)desc + "Ljava/lang/Class;";
            }
            return (String)desc + ")V";
        }
    }

    public static class JavaLogger
    implements Logger {
        private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(PortableTypeGenerator.class.getName());

        @Override
        public void debug(String message) {
            LOG.fine(message);
        }

        @Override
        public void info(String message) {
            LOG.info(message);
        }
    }
}

