/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.util.Binary;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.IntFunction;

class VersionedPofReader
implements PofReader {
    private final PofReader f_in;
    private final int f_nVersion;
    private final boolean f_fRead;

    public VersionedPofReader(PofReader in, int nImplVersion) {
        this.f_in = in;
        this.f_nVersion = nImplVersion;
        this.f_fRead = in.getVersionId() >= nImplVersion;
    }

    @Override
    public boolean readBoolean(int iProp) throws IOException {
        return this.f_fRead && this.f_in.readBoolean(iProp);
    }

    @Override
    public byte readByte(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readByte(iProp) : (byte)0;
    }

    @Override
    public char readChar(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readChar(iProp) : (char)'\u0000';
    }

    @Override
    public short readShort(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readShort(iProp) : (short)0;
    }

    @Override
    public int readInt(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readInt(iProp) : 0;
    }

    @Override
    public long readLong(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readLong(iProp) : 0L;
    }

    @Override
    public float readFloat(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readFloat(iProp) : 0.0f;
    }

    @Override
    public double readDouble(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readDouble(iProp) : 0.0;
    }

    @Override
    public boolean[] readBooleanArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readBooleanArray(iProp) : null;
    }

    @Override
    public byte[] readByteArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readByteArray(iProp) : null;
    }

    @Override
    public char[] readCharArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readCharArray(iProp) : null;
    }

    @Override
    public short[] readShortArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readShortArray(iProp) : null;
    }

    @Override
    public int[] readIntArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readIntArray(iProp) : null;
    }

    @Override
    public long[] readLongArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readLongArray(iProp) : null;
    }

    @Override
    public float[] readFloatArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readFloatArray(iProp) : null;
    }

    @Override
    public double[] readDoubleArray(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readDoubleArray(iProp) : null;
    }

    @Override
    public BigInteger readBigInteger(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readBigInteger(iProp) : null;
    }

    @Override
    public RawQuad readRawQuad(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawQuad(iProp) : null;
    }

    @Override
    public BigDecimal readBigDecimal(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readBigDecimal(iProp) : null;
    }

    @Override
    public Binary readBinary(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readBinary(iProp) : null;
    }

    @Override
    public String readString(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readString(iProp) : null;
    }

    @Override
    public Date readDate(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readDate(iProp) : null;
    }

    @Override
    public LocalDate readLocalDate(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readLocalDate(iProp) : null;
    }

    @Override
    public LocalDateTime readLocalDateTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readLocalDateTime(iProp) : null;
    }

    @Override
    public LocalTime readLocalTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readLocalTime(iProp) : null;
    }

    @Override
    public OffsetDateTime readOffsetDateTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readOffsetDateTime(iProp) : null;
    }

    @Override
    public OffsetTime readOffsetTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readOffsetTime(iProp) : null;
    }

    @Override
    public ZonedDateTime readZonedDateTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readZonedDateTime(iProp) : null;
    }

    @Override
    public RawDate readRawDate(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawDate(iProp) : null;
    }

    @Override
    public RawTime readRawTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawTime(iProp) : null;
    }

    @Override
    public RawDateTime readRawDateTime(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawDateTime(iProp) : null;
    }

    @Override
    public RawYearMonthInterval readRawYearMonthInterval(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawYearMonthInterval(iProp) : null;
    }

    @Override
    public RawTimeInterval readRawTimeInterval(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawTimeInterval(iProp) : null;
    }

    @Override
    public RawDayTimeInterval readRawDayTimeInterval(int iProp) throws IOException {
        return this.f_fRead ? this.f_in.readRawDayTimeInterval(iProp) : null;
    }

    @Override
    public <T> T readObject(int iProp) throws IOException {
        return this.f_fRead ? (T)this.f_in.readObject(iProp) : null;
    }

    @Override
    @Deprecated
    public Object[] readObjectArray(int iProp, Object[] ao) throws IOException {
        return this.f_fRead ? this.f_in.readObjectArray(iProp, ao) : null;
    }

    @Override
    public <T> T[] readArray(int iProp, IntFunction<T[]> supplier) throws IOException {
        return this.f_fRead ? this.f_in.readArray(iProp, supplier) : null;
    }

    @Override
    public <T> LongArray<T> readLongArray(int iProp, LongArray<T> array) throws IOException {
        return this.f_fRead ? this.f_in.readLongArray(iProp, array) : null;
    }

    @Override
    public <T, C extends Collection<T>> C readCollection(int iProp, C coll) throws IOException {
        return this.f_fRead ? (C)this.f_in.readCollection(iProp, coll) : null;
    }

    @Override
    public <K, V, M extends Map<K, V>> M readMap(int iProp, M map) throws IOException {
        return this.f_fRead ? (M)this.f_in.readMap(iProp, map) : null;
    }

    @Override
    public PofContext getPofContext() {
        return this.f_in.getPofContext();
    }

    @Override
    public void setPofContext(PofContext ctx) {
        this.f_in.setPofContext(ctx);
    }

    @Override
    public int getUserTypeId() {
        return this.f_in.getUserTypeId();
    }

    @Override
    public int getVersionId() {
        return this.f_in.getVersionId();
    }

    @Override
    public void registerIdentity(Object o) {
        this.f_in.registerIdentity(o);
    }

    @Override
    public PofReader createNestedPofReader(int iProp) throws IOException {
        return new VersionedPofReader(this.f_in.createNestedPofReader(iProp), this.f_nVersion);
    }

    @Override
    public Binary readRemainder() throws IOException {
        return this.f_in.readRemainder();
    }
}

