/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableException;
import com.tangosol.util.ImmutableArrayList;
import java.io.IOException;

public class ThrowablePofSerializer
implements PofSerializer {
    public void serialize(PofWriter out, Object o) throws IOException {
        ThrowablePofSerializer.writeThrowable(out, (Throwable)o);
        out.writeRemainder(null);
    }

    public Object deserialize(PofReader in) throws IOException {
        PortableException e = new PortableException();
        in.registerIdentity(e);
        e.readExternal(in);
        in.readRemainder();
        return e;
    }

    static void writeThrowable(PofWriter out, Throwable t) throws IOException {
        Object[] asTrace;
        String sName;
        if (t instanceof PortableException) {
            PortableException e = (PortableException)t;
            sName = e.getName();
            asTrace = e.getFullStackTrace();
        } else {
            StackTraceElement[] aoTrace = t.getStackTrace();
            sName = t.getClass().getName();
            asTrace = new String[aoTrace.length];
            int c = aoTrace.length;
            for (int i = 0; i < c; ++i) {
                asTrace[i] = "at " + String.valueOf(aoTrace[i]);
            }
        }
        out.writeString(0, sName);
        out.writeString(1, t.getMessage());
        out.writeCollection(2, new ImmutableArrayList(asTrace), String.class);
        out.writeObject(3, t.getCause());
    }
}

