/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHelper;
import java.sql.Time;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RawTime
extends PofHelper {
    private static final int TZ_NONE = 0;
    private static final int TZ_UTC = 1;
    private static final int TZ_OFFSET = 2;
    private int m_nHour;
    private int m_nMinute;
    private int m_nSecond;
    private int m_nNano;
    private int m_nTimeZoneType;
    private int m_nHourOffset;
    private int m_nMinuteOffset;

    public RawTime(int nHour, int nMinute, int nSecond, int nNano, boolean fUTC) {
        this(nHour, nMinute, nSecond, nNano);
        this.m_nTimeZoneType = fUTC ? 1 : 0;
    }

    public RawTime(int nHour, int nMinute, int nSecond, int nNano, int nHourOffset, int nMinuteOffset) {
        this(nHour, nMinute, nSecond, nNano);
        RawTime.checkTimeZone(nHourOffset, nMinuteOffset);
        this.m_nTimeZoneType = 2;
        this.m_nHourOffset = nHourOffset;
        this.m_nMinuteOffset = nMinuteOffset;
    }

    private RawTime(int nHour, int nMinute, int nSecond, int nNano) {
        RawTime.checkTime(nHour, nMinute, nSecond, nNano);
        this.m_nHour = nHour;
        this.m_nMinute = nMinute;
        this.m_nSecond = nSecond;
        this.m_nNano = nNano;
    }

    public int getHour() {
        return this.m_nHour;
    }

    public int getMinute() {
        return this.m_nMinute;
    }

    public int getSecond() {
        return this.m_nSecond;
    }

    public int getNano() {
        return this.m_nNano;
    }

    public boolean hasTimezone() {
        return this.m_nTimeZoneType != 0;
    }

    public boolean isUTC() {
        return this.m_nTimeZoneType == 1;
    }

    public int getHourOffset() {
        return this.m_nHourOffset;
    }

    public int getMinuteOffset() {
        return this.m_nMinuteOffset;
    }

    public static RawTime from(Object o) {
        RawTime t;
        RawTime rawTime = o instanceof LocalTime ? RawTime.from((LocalTime)o) : (o instanceof OffsetTime ? RawTime.from((OffsetTime)o) : (o instanceof Time ? RawTime.from((Time)o) : (t = o instanceof Date ? RawTime.from((Date)o) : null)));
        if (t == null) {
            throw new IllegalArgumentException("Object " + String.valueOf(o) + " cannot be converted to RawTime");
        }
        return t;
    }

    public static RawTime from(LocalTime time) {
        return new RawTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), false);
    }

    public static RawTime from(OffsetTime time) {
        ZoneOffset of = time.getOffset();
        if (of.compareTo(ZoneOffset.UTC) == 0) {
            return new RawTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), true);
        }
        int nOfHour = of.getTotalSeconds() / 3600;
        int nOfMinute = of.getTotalSeconds() % 3600 / 60;
        return new RawTime(time.getHour(), time.getMinute(), time.getSecond(), time.getNano(), nOfHour, nOfMinute);
    }

    public static RawTime from(Time time) {
        return RawTime.from(time.toLocalTime());
    }

    public static RawTime from(Date date) {
        return RawTime.from(date.toInstant().atOffset(ZoneOffset.ofTotalSeconds(date.getTimezoneOffset() * 60)).toOffsetTime());
    }

    public LocalTime toLocalTime() {
        return LocalTime.of(this.getHour(), this.getMinute(), this.getSecond(), this.getNano());
    }

    public OffsetTime toOffsetTime() {
        if (this.hasTimezone()) {
            ZoneOffset of = this.isUTC() ? ZoneOffset.UTC : ZoneOffset.ofHoursMinutes(this.getHourOffset(), this.getMinuteOffset());
            return OffsetTime.of(this.getHour(), this.getMinute(), this.getSecond(), this.getNano(), of);
        }
        throw new IllegalStateException("Unable to convert RawTime into OffsetTime because time zone information is missing.");
    }

    public Time toSqlTime() {
        return new Time(this.getHour(), this.getMinute(), this.getSecond());
    }

    public Date toJavaDate() {
        TimeZone timezone = null;
        if (this.hasTimezone()) {
            StringBuffer sb = new StringBuffer();
            sb.append("GMT");
            if (!this.isUTC()) {
                int cHours = this.getHourOffset();
                int cMinutes = this.getMinuteOffset();
                if (cHours < 0) {
                    sb.append('-');
                    cHours = -cHours;
                } else {
                    sb.append('+');
                }
                sb.append(cHours).append(':').append(RawTime.toDecString(cMinutes, 2));
            }
            timezone = RawTime.getTimeZone(sb.toString());
        }
        Calendar calendar = timezone == null ? Calendar.getInstance() : Calendar.getInstance(timezone);
        calendar.set(11, this.getHour());
        calendar.set(12, this.getMinute());
        calendar.set(13, this.getSecond());
        calendar.set(14, this.getNano() / 1000000);
        return calendar.getTime();
    }

    public boolean equals(Object o) {
        if (o instanceof RawTime) {
            RawTime that = (RawTime)o;
            return this == that || this.getHour() == that.getHour() && this.getMinute() == that.getMinute() && this.getSecond() == that.getSecond() && this.getNano() == that.getNano() && this.isUTC() == that.isUTC() && this.getHourOffset() == that.getHourOffset() && this.getMinuteOffset() == that.getMinuteOffset();
        }
        return false;
    }

    public int hashCode() {
        return this.getHour() << 2 ^ this.getMinute() << 1 ^ this.getSecond() ^ this.getNano();
    }

    public String toString() {
        return this.hasTimezone() && !this.isUTC() ? RawTime.formatTime(this.getHour(), this.getMinute(), this.getSecond(), this.getNano(), this.getHourOffset(), this.getMinuteOffset()) : RawTime.formatTime(this.getHour(), this.getMinute(), this.getSecond(), this.getNano(), this.isUTC());
    }
}

