/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHelper;
import java.time.LocalDate;
import java.util.Date;

public class RawDate
extends PofHelper {
    private int m_nYear;
    private int m_nMonth;
    private int m_nDay;

    public RawDate(int nYear, int nMonth, int nDay) {
        RawDate.checkDate(nYear, nMonth, nDay);
        this.m_nYear = nYear;
        this.m_nMonth = nMonth;
        this.m_nDay = nDay;
    }

    public int getYear() {
        return this.m_nYear;
    }

    public int getMonth() {
        return this.m_nMonth;
    }

    public int getDay() {
        return this.m_nDay;
    }

    public static RawDate from(Object o) {
        RawDate d;
        RawDate rawDate = o instanceof LocalDate ? RawDate.from((LocalDate)o) : (o instanceof java.sql.Date ? RawDate.from((java.sql.Date)o) : (d = o instanceof Date ? RawDate.from((Date)o) : null));
        if (d == null) {
            throw new IllegalArgumentException("Object " + String.valueOf(o) + " cannot be converted to RawDate");
        }
        return d;
    }

    public static RawDate from(LocalDate date) {
        return new RawDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static RawDate from(java.sql.Date date) {
        return RawDate.from(date.toLocalDate());
    }

    public static RawDate from(Date date) {
        return new RawDate(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.getYear(), this.getMonth(), this.getDay());
    }

    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.getYear() - 1900, this.getMonth() - 1, this.getDay());
    }

    public Date toJavaDate() {
        return new Date(this.getYear() - 1900, this.getMonth() - 1, this.getDay());
    }

    public boolean equals(Object o) {
        if (o instanceof RawDate) {
            RawDate that = (RawDate)o;
            return this == that || this.getYear() == that.getYear() && this.getMonth() == that.getMonth() && this.getDay() == that.getDay();
        }
        return false;
    }

    public int hashCode() {
        return this.getYear() << 2 ^ this.getMonth() << 1 ^ this.getDay();
    }

    public String toString() {
        return RawDate.formatDate(this.getYear(), this.getMonth(), this.getDay());
    }
}

