/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.io.pof.VersionedPofReader;
import com.tangosol.util.Binary;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.IntFunction;

public interface PofReader {
    default public PofReader version(int nImplVersion) {
        return new VersionedPofReader(this, nImplVersion);
    }

    public boolean readBoolean(int var1) throws IOException;

    public byte readByte(int var1) throws IOException;

    public char readChar(int var1) throws IOException;

    public short readShort(int var1) throws IOException;

    public int readInt(int var1) throws IOException;

    public long readLong(int var1) throws IOException;

    public float readFloat(int var1) throws IOException;

    public double readDouble(int var1) throws IOException;

    public boolean[] readBooleanArray(int var1) throws IOException;

    public byte[] readByteArray(int var1) throws IOException;

    public char[] readCharArray(int var1) throws IOException;

    public short[] readShortArray(int var1) throws IOException;

    public int[] readIntArray(int var1) throws IOException;

    public long[] readLongArray(int var1) throws IOException;

    public float[] readFloatArray(int var1) throws IOException;

    public double[] readDoubleArray(int var1) throws IOException;

    public BigInteger readBigInteger(int var1) throws IOException;

    public RawQuad readRawQuad(int var1) throws IOException;

    public BigDecimal readBigDecimal(int var1) throws IOException;

    public Binary readBinary(int var1) throws IOException;

    public String readString(int var1) throws IOException;

    public Date readDate(int var1) throws IOException;

    public LocalDate readLocalDate(int var1) throws IOException;

    public LocalDateTime readLocalDateTime(int var1) throws IOException;

    public LocalTime readLocalTime(int var1) throws IOException;

    public OffsetDateTime readOffsetDateTime(int var1) throws IOException;

    public OffsetTime readOffsetTime(int var1) throws IOException;

    default public ZonedDateTime readZonedDateTime(int iProp) throws IOException {
        return this.readOffsetDateTime(iProp).toZonedDateTime();
    }

    public RawDate readRawDate(int var1) throws IOException;

    public RawTime readRawTime(int var1) throws IOException;

    public RawDateTime readRawDateTime(int var1) throws IOException;

    public RawYearMonthInterval readRawYearMonthInterval(int var1) throws IOException;

    public RawTimeInterval readRawTimeInterval(int var1) throws IOException;

    public RawDayTimeInterval readRawDayTimeInterval(int var1) throws IOException;

    public <T> T readObject(int var1) throws IOException;

    @Deprecated
    public Object[] readObjectArray(int var1, Object[] var2) throws IOException;

    public <T> T[] readArray(int var1, IntFunction<T[]> var2) throws IOException;

    public <T> LongArray<T> readLongArray(int var1, LongArray<T> var2) throws IOException;

    public <T, C extends Collection<T>> C readCollection(int var1, C var2) throws IOException;

    public <K, V, M extends Map<K, V>> M readMap(int var1, M var2) throws IOException;

    public PofContext getPofContext();

    public void setPofContext(PofContext var1);

    public int getUserTypeId();

    public int getVersionId();

    public void registerIdentity(Object var1);

    public PofReader createNestedPofReader(int var1) throws IOException;

    public Binary readRemainder() throws IOException;
}

