/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.OutputStreaming;
import com.tangosol.io.pof.PofWriter;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class PofOutputStream
extends OutputStream
implements OutputStreaming,
DataOutput,
ObjectOutput {
    private PofWriter m_out;
    private int m_nProp;

    public PofOutputStream(PofWriter out) {
        this.m_out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.m_out.writeByte(this.nextIndex(), (byte)b);
    }

    @Override
    public void write(byte[] ab) throws IOException {
        this.m_out.writeByteArray(this.nextIndex(), ab);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        if (of > 0 || cb < ab.length) {
            byte[] abOrig = ab;
            ab = new byte[cb];
            System.arraycopy(abOrig, of, ab, 0, cb);
        }
        this.m_out.writeByteArray(this.nextIndex(), ab);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeBoolean(boolean f) throws IOException {
        this.m_out.writeBoolean(this.nextIndex(), f);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.m_out.writeByte(this.nextIndex(), (byte)b);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.m_out.writeShort(this.nextIndex(), (short)n);
    }

    @Override
    public void writeChar(int ch) throws IOException {
        this.m_out.writeChar(this.nextIndex(), (char)ch);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(this.nextIndex(), n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.m_out.writeLong(this.nextIndex(), l);
    }

    @Override
    public void writeFloat(float fl) throws IOException {
        this.m_out.writeFloat(this.nextIndex(), fl);
    }

    @Override
    public void writeDouble(double dfl) throws IOException {
        this.m_out.writeDouble(this.nextIndex(), dfl);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int cb = s.length();
        byte[] ab = new byte[cb];
        s.getBytes(0, cb, ab, 0);
        this.m_out.writeByteArray(this.nextIndex(), ab);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.m_out.writeCharArray(this.nextIndex(), s.toCharArray());
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.m_out.writeString(this.nextIndex(), s);
    }

    @Override
    public void writeObject(Object o) throws IOException {
        this.m_out.writeObject(this.nextIndex(), o);
    }

    public PofWriter getPofWriter() {
        return this.m_out;
    }

    public int nextIndex() {
        return this.m_nProp++;
    }
}

