/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.collections.NullableConcurrentMap;
import com.tangosol.internal.classgraph.AnnotationParameterValue;
import com.tangosol.internal.classgraph.AnnotationParameterValueList;
import com.tangosol.internal.classgraph.ClassGraph;
import com.tangosol.internal.classgraph.ClassInfo;
import com.tangosol.internal.classgraph.ScanResult;
import com.tangosol.io.pof.generator.PortableTypeGenerator;
import com.tangosol.io.pof.schema.annotation.PortableType;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class PofIndexer {
    public static final String DEFAULT_INDEX_FILE_NAME = "META-INF/pof.idx";
    private String m_sIndexFileName = "META-INF/pof.idx";
    private final ClassLoader m_classLoader;
    private boolean m_fIgnoreClasspath = false;
    private Set<String> m_packagesToScan = new HashSet<String>();
    private List<Class> m_classes = new ArrayList<Class>();
    private List<File> m_jarFiles = new ArrayList<File>();
    private List<File> m_classesDirectories = new ArrayList<File>();
    private List<Pattern> m_includeFilterPatterns = new ArrayList<Pattern>();
    private PortableTypeGenerator.Logger m_log;

    public PofIndexer() {
        this(Classes.getContextClassLoader(), new PortableTypeGenerator.CoherenceLogger());
    }

    public PofIndexer(PortableTypeGenerator.Logger logger) {
        this(Classes.getContextClassLoader(), logger);
    }

    public PofIndexer(ClassLoader classLoader) {
        this(classLoader, new PortableTypeGenerator.CoherenceLogger());
    }

    public PofIndexer(ClassLoader classLoader, PortableTypeGenerator.Logger logger) {
        this.m_classLoader = classLoader == null ? PofIndexer.class.getClassLoader() : classLoader;
        this.m_log = logger;
    }

    public void createIndexInDirectory(File pofIndexFileDirectory) {
        if (pofIndexFileDirectory.isFile()) {
            throw new IllegalArgumentException(String.format("pofIndexFileDirectory '%s' must not be a file.", pofIndexFileDirectory.getAbsolutePath()));
        }
        File pofIndexFile = new File(pofIndexFileDirectory, this.m_sIndexFileName);
        pofIndexFile.getParentFile().mkdirs();
        this.createIndex(pofIndexFile);
    }

    public void createIndex(File pofIndexFile) {
        this.m_log.info(String.format("Creating POF index file at '%s'.", pofIndexFile.getAbsolutePath()));
        Map<String, Integer> portableClasses = this.discoverPortableTypes();
        this.m_log.info(String.format("Discovered %s class(es) annotated with `%s`.", portableClasses, PortableType.class.getName()));
        Properties pofProperties = new Properties();
        for (Map.Entry<String, Integer> entry : portableClasses.entrySet()) {
            pofProperties.put(entry.getKey(), entry.getValue() != null ? String.valueOf(entry.getValue()) : "");
        }
        try (FileOutputStream out = new FileOutputStream(pofIndexFile);){
            pofProperties.store(out, null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Unable to create FileOutputStream for POF Index File '%s'.", pofIndexFile.getAbsolutePath()), e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Something went wrong while storing the POF index classnames to the underlying FileOutputStream with the specified POF Index File '%s'.", pofIndexFile.getAbsolutePath()), e);
        }
    }

    protected Map<String, Integer> discoverPortableTypes() {
        NullableConcurrentMap<String, Integer> mapPortableTypes = new NullableConcurrentMap<String, Integer>();
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(this.m_classLoader);
        if (!this.m_packagesToScan.isEmpty()) {
            classGraph.acceptPackages(this.m_packagesToScan.toArray(new String[0]));
        }
        if (!this.m_classes.isEmpty()) {
            classGraph.acceptClasses((String[])this.m_classes.stream().map(Class::getName).toArray(String[]::new));
        }
        ArrayList<URL> classPathUris = new ArrayList<URL>();
        if (!this.m_fIgnoreClasspath) {
            classPathUris.addAll(classGraph.getClasspathURLs());
        }
        if (!this.m_jarFiles.isEmpty()) {
            List<URL> urls = this.m_jarFiles.stream().map(this::createJarURL).toList();
            classPathUris.addAll(urls);
        }
        if (!this.m_classesDirectories.isEmpty()) {
            classPathUris.addAll(this.m_classesDirectories.stream().map(file -> {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toList());
        }
        classGraph.overrideClasspath(classPathUris);
        try (ScanResult result = classGraph.scan();){
            for (ClassInfo classInfo : result.getClassesWithAnnotation(PortableType.class)) {
                int portableTypeId;
                AnnotationParameterValueList annotationParameterValues = classInfo.getAnnotationInfo(PortableType.class).getParameterValues();
                AnnotationParameterValue idValue = (AnnotationParameterValue)annotationParameterValues.get("id");
                if (idValue != null) {
                    portableTypeId = (Integer)idValue.getValue();
                    if (portableTypeId == -1) {
                        throw new IllegalStateException("The PortableType annotation on class " + classInfo.getName() + " did not have a required POF id.");
                    }
                } else {
                    throw new IllegalStateException("The PortableType annotation on class " + classInfo.getName() + " did not have a required POF id.");
                }
                mapPortableTypes.put(classInfo.getName(), portableTypeId);
            }
        }
        if (this.m_includeFilterPatterns.isEmpty()) {
            return mapPortableTypes;
        }
        SafeHashMap<String, Integer> mapFilteredPortableTypes = new SafeHashMap<String, Integer>();
        mapPortableTypes.entrySet().stream().filter(mapEntry -> {
            for (Pattern includePattern : this.m_includeFilterPatterns) {
                if (!includePattern.matcher((CharSequence)mapEntry.getKey()).matches()) continue;
                return true;
            }
            return false;
        }).forEach(mapEntry -> mapFilteredPortableTypes.put((String)mapEntry.getKey(), (Integer)mapEntry.getValue()));
        return mapFilteredPortableTypes;
    }

    public int getPortableTypeIdForClassName(String classname) {
        try {
            PortableType portableType = Class.forName(classname, true, this.m_classLoader).getAnnotation(PortableType.class);
            int portableTypeId = portableType.id();
            return portableTypeId;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Did not find PortableType class " + classname);
        }
    }

    public Map<URL, Properties> loadIndexes() {
        LiteMap<URL, Properties> mapIndexes = new LiteMap<URL, Properties>();
        String sIndexFileName = this.m_sIndexFileName;
        try {
            Iterable<URL> iterUrls = Resources.findResources(sIndexFileName, this.m_classLoader);
            for (URL url : iterUrls) {
                try {
                    InputStream input = url.openStream();
                    try {
                        Properties pofProperties = new Properties();
                        pofProperties.load(input);
                        mapIndexes.put(url, pofProperties);
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    Logger.warn("Unable to read POF index file " + String.valueOf(url) + ", error is " + ignore.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mapIndexes;
    }

    public void setIndexFileName(String sIndexFileName) {
        this.m_sIndexFileName = sIndexFileName;
    }

    public void setPackagesToScan(Set<String> packagesToScan) {
        this.m_packagesToScan = packagesToScan;
    }

    public void setIncludeFilterPatterns(Set<String> m_includeFilterPatterns) {
        this.m_includeFilterPatterns.addAll(m_includeFilterPatterns.stream().map(patternString -> Pattern.compile(patternString)).toList());
    }

    public URI createJarURI(File jarFile) {
        try {
            return new URI("jar", String.valueOf(jarFile.toURI()) + "!/", null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unable to convert '%s' to a Jar URI.", jarFile.getAbsolutePath()), e);
        }
    }

    public URL createJarURL(File jarFile) {
        URI jarUri = this.createJarURI(jarFile);
        try {
            return jarUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public PofIndexer ignoreClasspath(boolean fIgnoreClasspath) {
        this.m_fIgnoreClasspath = fIgnoreClasspath;
        return this;
    }

    public PofIndexer withClassesFromDirectory(Collection<File> directories) {
        this.m_classesDirectories.addAll(directories);
        return this;
    }

    public PofIndexer withClassesFromJarFile(List<File> jarFiles) {
        this.m_jarFiles.addAll(jarFiles);
        return this;
    }

    public PofIndexer withClasses(List<Class> clazzes) {
        this.m_classes.addAll(clazzes);
        return this;
    }

    public PofIndexer withIndexFileName(String indexFileName) {
        this.m_sIndexFileName = indexFileName;
        return this;
    }
}

