/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.BinaryDeltaCompressor;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofConstants;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import java.io.IOException;

public class PofDeltaCompressor
extends BinaryDeltaCompressor
implements DeltaCompressor,
PofConstants {
    @Override
    public ReadBuffer createDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        ReadBuffer.BufferInput inOld = bufOld.getBufferInput();
        ReadBuffer.BufferInput inNew = bufNew.getBufferInput();
        try {
            ChangeTracker tracker = new ChangeTracker(inOld, inNew);
            this.diffValue(inOld, inNew, tracker);
            Base.azzert(inOld.available() == 0 && inNew.available() == 0);
            return tracker.getDelta();
        }
        catch (Exception e) {
            Base.err(e);
            Base.err("(Reverting to default binary delta algorithm.)");
            return super.createDelta(bufOld, bufNew);
        }
    }

    protected void diffValue(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        inOld.mark(10);
        inNew.mark(10);
        int nOldType = inOld.readPackedInt();
        int nNewType = inNew.readPackedInt();
        if (nOldType == -31 || nNewType == -31) {
            boolean fBothId = true;
            int nOldId = -1;
            if (nOldType == -31) {
                nOldId = inOld.readPackedInt();
            } else {
                fBothId = false;
                inOld.reset();
            }
            int nNewId = -1;
            if (nNewType == -31) {
                nNewId = inNew.readPackedInt();
            } else {
                fBothId = false;
                inNew.reset();
            }
            tracker.advance(fBothId && nOldId == nNewId);
            nOldType = inOld.readPackedInt();
            nNewType = inNew.readPackedInt();
        }
        if (nOldType == nNewType) {
            tracker.advance(true);
            this.diffUniformValue(inOld, inNew, tracker, nOldType);
        } else {
            PofHelper.skipUniformValue(inOld, nOldType);
            PofHelper.skipUniformValue(inNew, nNewType);
            tracker.advance(false);
        }
    }

    protected void diffUniformValue(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker, int nType) throws IOException {
        if (nType >= 0) {
            this.diffUserType(inOld, inNew, tracker);
        } else {
            switch (nType) {
                case -11: 
                case -2: 
                case -1: {
                    this.diffPackedInt(inOld, inNew, tracker);
                    break;
                }
                case -3: {
                    this.diffPackedLong(inOld, inNew, tracker);
                    break;
                }
                case -4: {
                    tracker.advance(PofHelper.readBigInteger(inOld).equals(PofHelper.readBigInteger(inNew)));
                    break;
                }
                case -5: {
                    tracker.advance(inOld.readInt() == inNew.readInt());
                    break;
                }
                case -6: {
                    tracker.advance(inOld.readLong() == inNew.readLong());
                    break;
                }
                case -7: {
                    tracker.advance(inOld.readLong() == inNew.readLong() & inOld.readLong() == inNew.readLong());
                    break;
                }
                case -8: {
                    tracker.advance(PofHelper.readBigDecimal(inOld, 4).equals(PofHelper.readBigDecimal(inNew, 4)));
                    break;
                }
                case -9: {
                    tracker.advance(PofHelper.readBigDecimal(inOld, 8).equals(PofHelper.readBigDecimal(inNew, 8)));
                    break;
                }
                case -10: {
                    tracker.advance(PofHelper.readBigDecimal(inOld, 16).equals(PofHelper.readBigDecimal(inNew, 16)));
                    break;
                }
                case -12: {
                    tracker.advance(inOld.readUnsignedByte() == inNew.readUnsignedByte());
                    break;
                }
                case -14: {
                    tracker.advance(PofHelper.readChar(inOld) == PofHelper.readChar(inNew));
                    break;
                }
                case -15: 
                case -13: {
                    boolean fSame;
                    int cbOld = inOld.readPackedInt();
                    int cbNew = inNew.readPackedInt();
                    boolean bl = fSame = cbOld == cbNew;
                    if (fSame) {
                        tracker.advance(true);
                        if (cbOld <= 0) break;
                        tracker.advance(inOld.readBuffer(cbOld).toBinary().equals(inNew.readBuffer(cbNew).toBinary()));
                        break;
                    }
                    inOld.skipBytes(cbOld);
                    inNew.skipBytes(cbNew);
                    tracker.advance(false);
                    break;
                }
                case -16: {
                    this.diffPackedInts(inOld, inNew, tracker, 3);
                    break;
                }
                case -17: {
                    this.diffPackedInts(inOld, inNew, tracker, 2);
                    break;
                }
                case -18: {
                    this.diffPackedInts(inOld, inNew, tracker, 4);
                    this.diffTimeZone(inOld, inNew, tracker);
                    break;
                }
                case -19: {
                    this.diffPackedInts(inOld, inNew, tracker, 4);
                    break;
                }
                case -20: {
                    this.diffPackedInts(inOld, inNew, tracker, 7);
                    this.diffTimeZone(inOld, inNew, tracker);
                    break;
                }
                case -21: {
                    this.diffPackedInts(inOld, inNew, tracker, 5);
                    break;
                }
                case -24: 
                case -22: {
                    this.diffCollection(inOld, inNew, tracker);
                    break;
                }
                case -25: 
                case -23: {
                    this.diffUniformCollection(inOld, inNew, tracker);
                    break;
                }
                case -26: {
                    this.diffSparseArray(inOld, inNew, tracker);
                    break;
                }
                case -27: {
                    this.diffUniformSparseArray(inOld, inNew, tracker);
                    break;
                }
                case -28: {
                    this.diffMap(inOld, inNew, tracker);
                    break;
                }
                case -29: {
                    this.diffUniformKeysMap(inOld, inNew, tracker);
                    break;
                }
                case -30: {
                    this.diffUniformMap(inOld, inNew, tracker);
                    break;
                }
                case -32: {
                    this.diffPackedInt(inOld, inNew, tracker);
                    break;
                }
                case -64: 
                case -63: 
                case -62: 
                case -61: 
                case -60: 
                case -59: 
                case -58: 
                case -57: 
                case -56: 
                case -55: 
                case -54: 
                case -53: 
                case -52: 
                case -51: 
                case -50: 
                case -49: 
                case -48: 
                case -47: 
                case -46: 
                case -45: 
                case -44: 
                case -43: 
                case -42: 
                case -41: 
                case -40: 
                case -39: 
                case -38: 
                case -37: 
                case -36: 
                case -35: 
                case -34: 
                case -33: {
                    tracker.advance(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("nType=" + nType + ", old/new offset=" + inOld.getOffset() + "/" + inNew.getOffset());
                }
            }
        }
    }

    protected void diffUserType(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        this.diffSparseArray(inOld, inNew, tracker);
    }

    protected void diffCollection(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int cNew;
        int cOld = inOld.readPackedInt();
        boolean fSame = cOld == (cNew = inNew.readPackedInt());
        tracker.advance(fSame);
        int c = Math.min(cOld, cNew);
        for (int i = 0; i < c; ++i) {
            this.diffValue(inOld, inNew, tracker);
        }
        if (!fSame) {
            int iTo;
            ReadBuffer.BufferInput in;
            if (cOld > cNew) {
                in = inOld;
                iFrom = cNew;
                iTo = cOld;
            } else {
                in = inNew;
                iFrom = cOld;
                iTo = cNew;
            }
            for (int i = iFrom; i < iTo; ++i) {
                PofHelper.skipValue(in);
            }
            tracker.advance(false);
        }
    }

    protected void diffUniformCollection(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int nNewType;
        int nOldType = inOld.readPackedInt();
        boolean fSameType = nOldType == (nNewType = inNew.readPackedInt());
        tracker.advance(fSameType);
        int cOld = inOld.readPackedInt();
        int cNew = inNew.readPackedInt();
        boolean fSameCount = cOld == cNew;
        tracker.advance(fSameCount);
        if (fSameType) {
            int c = Math.min(cOld, cNew);
            for (int i = 0; i < c; ++i) {
                this.diffUniformValue(inOld, inNew, tracker, nOldType);
            }
            if (!fSameCount) {
                int iTo;
                ReadBuffer.BufferInput in;
                if (cOld > cNew) {
                    in = inOld;
                    iFrom = cNew;
                    iTo = cOld;
                } else {
                    in = inNew;
                    iFrom = cOld;
                    iTo = cNew;
                }
                for (int i = iFrom; i < iTo; ++i) {
                    PofHelper.skipUniformValue(in, nOldType);
                }
                tracker.advance(false);
            }
        } else {
            int i;
            for (i = 0; i < cOld; ++i) {
                PofHelper.skipUniformValue(inOld, nOldType);
            }
            for (i = 0; i < cNew; ++i) {
                PofHelper.skipUniformValue(inNew, nNewType);
            }
            tracker.advance(false);
        }
    }

    protected void diffSparseArray(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        this.diffPackedInt(inOld, inNew, tracker);
        while (true) {
            ReadBuffer.BufferInput inSkip;
            ReadBuffer.BufferInput inReset;
            inOld.mark(5);
            inNew.mark(5);
            int nNextOld = inOld.readPackedInt();
            int nNextNew = inNew.readPackedInt();
            if (nNextOld == nNextNew) {
                tracker.advance(true);
                if (nNextOld == -1) break;
                this.diffValue(inOld, inNew, tracker);
                continue;
            }
            if (nNextOld == -1 || nNextOld > nNextNew && nNextNew != -1) {
                inReset = inOld;
                inSkip = inNew;
            } else {
                inReset = inNew;
                inSkip = inOld;
            }
            inReset.reset();
            PofHelper.skipValue(inSkip);
            tracker.advance(false);
        }
    }

    protected void diffUniformSparseArray(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        block8: {
            int i;
            int nNewType;
            int nOldType = inOld.readPackedInt();
            boolean fSameType = nOldType == (nNewType = inNew.readPackedInt());
            tracker.advance(fSameType);
            int cOld = inOld.readPackedInt();
            int cNew = inNew.readPackedInt();
            boolean fSameCount = cOld == cNew;
            tracker.advance(fSameCount);
            if (fSameType) {
                while (true) {
                    ReadBuffer.BufferInput inSkip;
                    ReadBuffer.BufferInput inReset;
                    inOld.mark(5);
                    inNew.mark(5);
                    int nNextOld = inOld.readPackedInt();
                    int nNextNew = inNew.readPackedInt();
                    if (nNextOld == nNextNew) {
                        tracker.advance(true);
                        if (nNextOld != -1) {
                            this.diffUniformValue(inOld, inNew, tracker, nOldType);
                            continue;
                        }
                        break block8;
                    }
                    if (nNextOld == -1 || nNextOld > nNextNew) {
                        inReset = inOld;
                        inSkip = inNew;
                    } else {
                        inReset = inNew;
                        inSkip = inOld;
                    }
                    inReset.reset();
                    PofHelper.skipUniformValue(inSkip, nOldType);
                    tracker.advance(false);
                }
            }
            for (i = 0; i < cOld && inOld.readPackedInt() >= 0; ++i) {
                PofHelper.skipUniformValue(inOld, nOldType);
            }
            for (i = 0; i < cNew && inNew.readPackedInt() >= 0; ++i) {
                PofHelper.skipUniformValue(inNew, nNewType);
            }
            tracker.advance(false);
        }
    }

    protected void diffMap(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int cNew;
        int cOld = inOld.readPackedInt();
        boolean fSame = cOld == (cNew = inNew.readPackedInt());
        tracker.advance(fSame);
        int c = Math.min(cOld, cNew);
        for (int i = 0; i < c; ++i) {
            this.diffValue(inOld, inNew, tracker);
            this.diffValue(inOld, inNew, tracker);
        }
        if (!fSame) {
            int iTo;
            ReadBuffer.BufferInput in;
            if (cOld > cNew) {
                in = inOld;
                iFrom = cNew;
                iTo = cOld;
            } else {
                in = inNew;
                iFrom = cOld;
                iTo = cNew;
            }
            for (int i = iFrom; i < iTo; ++i) {
                PofHelper.skipValue(in);
                PofHelper.skipValue(in);
            }
            tracker.advance(false);
        }
    }

    protected void diffUniformKeysMap(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int nNewType;
        int nOldType = inOld.readPackedInt();
        boolean fSameType = nOldType == (nNewType = inNew.readPackedInt());
        tracker.advance(fSameType);
        int cOld = inOld.readPackedInt();
        int cNew = inNew.readPackedInt();
        boolean fSameCount = cOld == cNew;
        tracker.advance(fSameCount);
        int c = Math.min(cOld, cNew);
        for (int i = 0; i < c; ++i) {
            if (fSameType) {
                this.diffUniformValue(inOld, inNew, tracker, nOldType);
            } else {
                PofHelper.skipUniformValue(inOld, nOldType);
                PofHelper.skipUniformValue(inNew, nNewType);
                tracker.advance(false);
            }
            this.diffValue(inOld, inNew, tracker);
        }
        if (!fSameCount) {
            int nType;
            int iTo;
            ReadBuffer.BufferInput in;
            if (cOld > cNew) {
                in = inOld;
                iFrom = cNew;
                iTo = cOld;
                nType = nOldType;
            } else {
                in = inNew;
                iFrom = cOld;
                iTo = cNew;
                nType = nNewType;
            }
            for (int i = iFrom; i < iTo; ++i) {
                PofHelper.skipUniformValue(in, nType);
                PofHelper.skipValue(in);
            }
            tracker.advance(false);
        }
    }

    protected void diffUniformMap(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int nNewKeyType;
        int nOldKeyType = inOld.readPackedInt();
        boolean fSameKeyType = nOldKeyType == (nNewKeyType = inNew.readPackedInt());
        tracker.advance(fSameKeyType);
        int nOldValType = inOld.readPackedInt();
        int nNewValType = inNew.readPackedInt();
        boolean fSameValType = nOldValType == nNewValType;
        tracker.advance(fSameValType);
        int cOld = inOld.readPackedInt();
        int cNew = inNew.readPackedInt();
        boolean fSameCount = cOld == cNew;
        tracker.advance(fSameCount);
        if (fSameKeyType || fSameValType) {
            int c = Math.min(cOld, cNew);
            for (int i = 0; i < c; ++i) {
                if (fSameKeyType) {
                    this.diffUniformValue(inOld, inNew, tracker, nOldKeyType);
                } else {
                    PofHelper.skipUniformValue(inOld, nOldKeyType);
                    PofHelper.skipUniformValue(inNew, nNewKeyType);
                    tracker.advance(false);
                }
                if (fSameValType) {
                    this.diffUniformValue(inOld, inNew, tracker, nOldValType);
                    continue;
                }
                PofHelper.skipUniformValue(inOld, nOldValType);
                PofHelper.skipUniformValue(inNew, nNewValType);
                tracker.advance(false);
            }
            if (!fSameCount) {
                int nValType;
                int nKeyType;
                int iTo;
                ReadBuffer.BufferInput in;
                if (cOld > cNew) {
                    in = inOld;
                    iFrom = cNew;
                    iTo = cOld;
                    nKeyType = nOldKeyType;
                    nValType = nOldValType;
                } else {
                    in = inNew;
                    iFrom = cOld;
                    iTo = cNew;
                    nKeyType = nNewKeyType;
                    nValType = nNewValType;
                }
                for (int i = iFrom; i < iTo; ++i) {
                    PofHelper.skipUniformValue(in, nKeyType);
                    PofHelper.skipUniformValue(in, nValType);
                }
                tracker.advance(false);
            }
        } else {
            int i;
            for (i = 0; i < cOld; ++i) {
                PofHelper.skipUniformValue(inOld, nOldKeyType);
                PofHelper.skipUniformValue(inOld, nOldValType);
            }
            for (i = 0; i < cNew; ++i) {
                PofHelper.skipUniformValue(inNew, nNewKeyType);
                PofHelper.skipUniformValue(inNew, nNewValType);
            }
            tracker.advance(false);
        }
    }

    protected void diffTimeZone(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        int nNewZoneType;
        boolean fSame;
        int nOldZoneType = inOld.readPackedInt();
        boolean bl = fSame = nOldZoneType == (nNewZoneType = inNew.readPackedInt());
        if (fSame) {
            tracker.advance(true);
            if (nOldZoneType == 2) {
                this.diffPackedInts(inOld, inNew, tracker, 2);
            }
        } else {
            if (nOldZoneType == 2) {
                PofHelper.skipPackedInts(inOld, 2);
            } else if (nNewZoneType == 2) {
                PofHelper.skipPackedInts(inNew, 2);
            }
            tracker.advance(false);
        }
    }

    protected void diffPackedInts(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker, int cInts) throws IOException {
        for (int i = 0; i < cInts; ++i) {
            this.diffPackedInt(inOld, inNew, tracker);
        }
    }

    protected void diffPackedInt(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        tracker.advance(inOld.readPackedInt() == inNew.readPackedInt());
    }

    protected void diffPackedLongs(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker, int cInts) throws IOException {
        for (int i = 0; i < cInts; ++i) {
            this.diffPackedLong(inOld, inNew, tracker);
        }
    }

    protected void diffPackedLong(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew, ChangeTracker tracker) throws IOException {
        tracker.advance(inOld.readPackedLong() == inNew.readPackedLong());
    }

    protected static class ChangeTracker {
        private static final int SAME = 0;
        private static final int DIFF = 1;
        private static final int FINAL = 2;
        private final ReadBuffer.BufferInput m_inOld;
        private final ReadBuffer.BufferInput m_inNew;
        private final WriteBuffer.BufferOutput m_outDelta;
        private int m_ofLastOldDiff;
        private int m_ofLastOldSame;
        private int m_ofLastNewWrite;
        private int m_ofLastNewDiff;
        private int m_ofLastNewSame;

        public ChangeTracker(ReadBuffer.BufferInput inOld, ReadBuffer.BufferInput inNew) throws IOException {
            this.m_inOld = inOld;
            this.m_inNew = inNew;
            this.m_outDelta = new BinaryWriteBuffer(Math.max(64, Math.min(1024, Math.max(inOld.getBuffer().length(), inNew.getBuffer().length())))).getAppendingBufferOutput();
            this.m_outDelta.write(-12);
        }

        public void advance(boolean fSame) throws IOException {
            this.update(fSame ? 0 : 1);
        }

        public Binary getDelta() throws IOException {
            WriteBuffer.BufferOutput outDelta = this.m_outDelta;
            this.update(2);
            outDelta.write(3);
            return outDelta.getBuffer().toBinary();
        }

        private void update(int nUpdate) throws IOException {
            int cbSame;
            boolean fSame;
            boolean fLast;
            int ofCurrOld = this.m_inOld.getOffset();
            int ofCurrNew = this.m_inNew.getOffset();
            int ofLastOldDiff = this.m_ofLastOldDiff;
            int ofLastOldSame = this.m_ofLastOldSame;
            int ofLastNewDiff = this.m_ofLastNewDiff;
            int ofLastNewSame = this.m_ofLastNewSame;
            boolean fPrevSame = ofLastOldSame > ofLastOldDiff || ofLastNewSame > ofLastNewDiff;
            boolean bl = fLast = nUpdate == 2;
            boolean bl2 = fLast ? !fPrevSame : (fSame = nUpdate == 0);
            if ((fSame || fLast) && ((cbSame = ofCurrNew - ofLastNewDiff) > 12 || fLast) && ofLastNewDiff > this.m_ofLastNewWrite) {
                int of = this.m_ofLastNewWrite;
                int cb = ofLastNewDiff - of;
                WriteBuffer.BufferOutput outDelta = this.m_outDelta;
                outDelta.write(2);
                outDelta.writePackedInt(cb);
                outDelta.writeBuffer(this.m_inNew.getBuffer(), of, cb);
                this.m_ofLastNewWrite = ofLastNewDiff;
            }
            if (fSame) {
                this.m_ofLastOldSame = ofCurrOld;
                this.m_ofLastNewSame = ofCurrNew;
            } else {
                int of;
                int cb;
                if (fPrevSame && (cb = ofLastOldSame - (of = this.m_ofLastOldDiff)) > 0) {
                    if (cb > 12 || fLast) {
                        WriteBuffer.BufferOutput outDelta = this.m_outDelta;
                        outDelta.write(1);
                        outDelta.writePackedInt(of);
                        outDelta.writePackedInt(cb);
                        this.m_ofLastNewWrite = ofLastNewSame;
                    } else {
                        this.m_ofLastOldSame = 0;
                        this.m_ofLastNewSame = 0;
                    }
                }
                this.m_ofLastOldDiff = ofCurrOld;
                this.m_ofLastNewDiff = ofCurrNew;
            }
        }
    }
}

