/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import java.util.TreeSet;

public class PofConfigLogger {
    public static void log(String ... asConfig) {
        SimpleElement xmlRoot = new SimpleElement("pof-config");
        XmlElement xmlUserTypes = xmlRoot.addElement("user-type-list");
        xmlUserTypes.addElement("include").setString("coherence-pof-config.xml");
        for (String sConfig : asConfig) {
            if (sConfig == null || sConfig.isEmpty()) continue;
            xmlUserTypes.addElement("include").setString(sConfig);
        }
        xmlRoot.addElement("enable-type-discovery").setBoolean(true);
        ConfigurablePofContext context = new ConfigurablePofContext(xmlRoot);
        context.ensureInitialized();
        ConfigurablePofContext.PofConfig pofConfig = context.getPofConfig();
        TreeSet<Integer> setId = new TreeSet<Integer>(pofConfig.m_mapClassNameByTypeId.keySet());
        int last = -1;
        Package pkgLast = context.getClass(0).getPackage();
        int pkgId = 0;
        for (Integer id : setId) {
            Class clz = context.getClass(id);
            Package pkg = clz.getPackage();
            if (!pkg.equals(pkgLast)) {
                System.out.println(pkgId + " - " + last + " " + pkgLast.getName());
                pkgLast = pkg;
                pkgId = id;
            }
            if (id == last + 1) {
                last = id;
                continue;
            }
            if (id != pkgId) {
                System.out.println(pkgId + " - " + (id - 1) + " " + pkgLast.getName());
                pkgId = id;
            }
            System.out.println(last + 1 + " - " + (id - 1) + " AVAILABLE");
            last = id;
        }
    }

    public static void main(String[] args) {
        PofConfigLogger.log(args);
    }
}

