/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;

public class ExternalizableLitePofSerializer
extends PofHelper
implements PofSerializer {
    protected final int m_nTypeId;

    public ExternalizableLitePofSerializer(int nTypeId) {
        ExternalizableLitePofSerializer.azzert(nTypeId >= 0, "user type identifier cannot be negative");
        this.m_nTypeId = nTypeId;
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        ExternalizableLite elValue;
        try {
            elValue = (ExternalizableLite)o;
        }
        catch (ClassCastException e) {
            String sClass = null;
            try {
                sClass = out.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String sActual = null;
            try {
                sActual = o.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred writing an ExternalizableLite user type to a POF stream: type-id=" + this.m_nTypeId + (String)(sClass == null ? "" : ", class-name=" + sClass) + (String)(sActual == null ? "" : ", actual class-name=" + sActual) + ", exception=\n" + String.valueOf(e));
        }
        elValue.writeExternal(new PofOutputStream(out));
        out.writeRemainder(null);
    }

    public Object deserialize(PofReader in) throws IOException {
        ExternalizableLite elValue;
        try {
            elValue = (ExternalizableLite)in.getPofContext().getClass(this.m_nTypeId).newInstance();
            in.registerIdentity(elValue);
        }
        catch (Exception e) {
            String sClass = null;
            try {
                sClass = in.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException("An exception occurred instantiating an ExternalizableLite user type from a POF stream: type-id=" + this.m_nTypeId + (String)(sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + String.valueOf(e));
        }
        elValue.readExternal(new PofInputStream(in));
        in.readRemainder();
        return elValue;
    }
}

