/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;

public class EnumPofSerializer<E extends Enum<E>>
implements PofSerializer<E> {
    @Override
    public void serialize(PofWriter writer, E e) throws IOException {
        if (!(e instanceof Enum)) {
            throw new IllegalArgumentException("EnumPofSerializer can only be used to serialize enum types.");
        }
        writer.writeString(0, ((Enum)e).name());
        writer.writeRemainder(null);
    }

    @Override
    public E deserialize(PofReader reader) throws IOException {
        PofContext ctx = reader.getPofContext();
        Class clz = ctx.getClass(reader.getUserTypeId());
        if (!clz.isEnum()) {
            throw new IllegalArgumentException("EnumPofSerializer can only be used to deserialize enum types.");
        }
        Object enumValue = Enum.valueOf(clz, reader.readString(0));
        reader.registerIdentity(enumValue);
        reader.readRemainder();
        return (E)enumValue;
    }
}

