/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.collections.NullableConcurrentMap;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.EnumPofSerializer;
import com.tangosol.io.pof.PofAnnotationSerializer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofConfigProvider;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofIndexer;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.io.pof.annotation.Portable;
import com.tangosol.io.pof.schema.annotation.PortableType;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.ExternalizableHelper;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Named(value="pof")
public class ConfigurablePofContext
implements PofContext,
ClassLoaderAware,
XmlConfigurable {
    public static final String PROPERTY_CONFIG = "coherence.pof.config";
    public static final String DEFAULT_RESOURCE = Config.getProperty("coherence.pof.config", "pof-config.xml");
    protected static final Class ROOT_LAMBDA_CLASS = FunctionalInterface.class;
    protected static final String DEFAULT_INDEX_FILE_NAME = "META-INF/pof.idx";
    private static final Map s_mapConfigurations = new WeakHashMap();
    private WeakReference<ClassLoader> m_refLoader;
    private boolean m_fEnableAutoTypeDiscovery = Config.getBoolean("coherence.pof.classpath.scanning.enabled", false);
    private String m_sUri;
    private XmlElement m_xml;
    private boolean m_fReferenceEnabled;
    private boolean m_fPreferJavaTime;
    private volatile PofConfig m_cfg;
    private String m_sIndexFileName = "META-INF/pof.idx";

    public ConfigurablePofContext() {
        this((String)null);
    }

    public ConfigurablePofContext(String sLocator) {
        this.m_sUri = sLocator;
    }

    public ConfigurablePofContext(XmlElement xml) {
        this.setConfig(xml);
    }

    public ConfigurablePofContext(ConfigurablePofContext that) {
        this.m_cfg = that.m_cfg;
        this.m_fReferenceEnabled = that.m_fReferenceEnabled;
        this.m_refLoader = that.m_refLoader;
        this.m_sUri = that.m_sUri;
        this.m_xml = that.m_xml;
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public synchronized void setConfig(XmlElement xml) {
        if (xml != null && !XmlHelper.isEmpty(xml)) {
            this.checkNotInitialized();
            if (this.m_sUri == null) {
                this.m_sUri = "xml:" + Base.toDecString(xml.toString().hashCode() & Integer.MAX_VALUE, 8);
            }
            this.m_xml = xml;
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        ClassLoader loader = null;
        WeakReference<ClassLoader> ref = this.m_refLoader;
        if (ref != null && (loader = (ClassLoader)ref.get()) == null) {
            throw new IllegalStateException("ClassLoader is no longer available");
        }
        return loader;
    }

    @Override
    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.checkNotInitialized();
        this.m_refLoader = loader == null ? null : new WeakReference<ClassLoader>(loader);
        this.initialize();
    }

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        this.ensureInitialized();
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        if (this.isReferenceEnabled() && !(o instanceof Evolvable)) {
            writer.enableReference();
        }
        try {
            writer.writeObject(-1, o);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        this.ensureInitialized();
        PofBufferReader reader = new PofBufferReader(in, this);
        try {
            return reader.readObject(-1);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public String getName() {
        return "pof";
    }

    @Override
    public PofSerializer getPofSerializer(int nTypeId) {
        this.ensureInitialized();
        PofSerializer serializer = this.m_cfg.m_mapSerByTypeId.get(nTypeId);
        if (serializer == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return serializer;
    }

    @Override
    public int getUserTypeIdentifier(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.getUserTypeIdentifier(o.getClass());
    }

    @Override
    public int getUserTypeIdentifier(Class clz) {
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + clz.getName());
        }
        return nTypeId;
    }

    @Override
    public int getUserTypeIdentifier(String sClass) {
        int nTypeId = this.getUserTypeIdentifierInternal(sClass);
        if (nTypeId < 0) {
            throw new IllegalArgumentException("unknown user type: " + sClass);
        }
        return nTypeId;
    }

    @Override
    public String getClassName(int nTypeId) {
        return this.m_cfg.m_mapClassNameByTypeId.get(nTypeId);
    }

    @Override
    public Class getClass(int nTypeId) {
        String sClass;
        Class clz;
        this.ensureInitialized();
        WeakReference<Class<?>> ref = this.m_cfg.m_mapClzByTypeId.get(nTypeId);
        Class clazz = clz = ref != null ? (Class)ref.get() : null;
        if (clz == null && (sClass = this.m_cfg.m_mapClassNameByTypeId.get(nTypeId)) != null && !sClass.isEmpty()) {
            clz = this.loadClass(sClass);
        }
        if (clz == null) {
            throw new IllegalArgumentException("unknown user type: " + nTypeId);
        }
        return clz;
    }

    @Override
    public boolean isUserType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        return this.isUserType(o.getClass());
    }

    @Override
    public boolean isUserType(Class clz) {
        return this.getUserTypeIdentifierInternal(clz) >= 0;
    }

    @Override
    public boolean isUserType(String sClass) {
        return this.getUserTypeIdentifierInternal(sClass) >= 0;
    }

    @Override
    public boolean isPreferJavaTime() {
        return this.m_fPreferJavaTime;
    }

    protected int getUserTypeIdentifierInternal(Class clz) {
        this.ensureInitialized();
        Integer ITypeId = this.m_cfg.m_mapTypeIdByClass.get(clz);
        return ITypeId == null ? this.getInheritedUserTypeIdentifier(clz) : ITypeId.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInheritedUserTypeIdentifier(Class clz) {
        Map<Class<?>, Integer> mapClzToId = this.m_cfg.m_mapTypeIdByClass;
        if (clz == null) {
            throw new IllegalArgumentException("class is required");
        }
        if (this.isSubclassAllowed()) {
            for (Class clzSuper = clz.getSuperclass(); clzSuper != null; clzSuper = clzSuper.getSuperclass()) {
                Integer ITypeId = mapClzToId.get(clzSuper);
                if (ITypeId == null) continue;
                mapClzToId.put(clz, ITypeId);
                return ITypeId;
            }
        }
        if (this.isInterfaceAllowed()) {
            Map<Class<?>, Integer> map = mapClzToId;
            synchronized (map) {
                for (Map.Entry<Class<?>, Integer> entry : mapClzToId.entrySet()) {
                    Class<?> clzCur = entry.getKey();
                    Integer ICurId = entry.getValue();
                    if (clzCur == null || ICurId == null || !clzCur.isInterface() || !clzCur.isAssignableFrom(clz)) continue;
                    mapClzToId.put(clz, ICurId);
                    return ICurId;
                }
            }
        }
        mapClzToId.put(clz, -1);
        return -1;
    }

    protected int getUserTypeIdentifierInternal(String sClass) {
        this.ensureInitialized();
        int nTypeId = -1;
        Map<String, Integer> mapNameToId = this.m_cfg.m_mapTypeIdByClassName;
        Integer ITypeId = mapNameToId.get(sClass);
        if (ITypeId == null) {
            if (sClass == null || sClass.length() == 0) {
                throw new IllegalArgumentException("class name is required");
            }
            if ((this.isSubclassAllowed() || this.isInterfaceAllowed() || this.isLambdaAllowed()) && (nTypeId = this.getUserTypeIdentifierInternal(this.loadClass(sClass))) >= 0) {
                mapNameToId.put(sClass, nTypeId);
            }
        } else {
            nTypeId = ITypeId;
        }
        return nTypeId;
    }

    protected boolean isInitialized() {
        return this.m_cfg != null;
    }

    protected String getConfigLocation() {
        return this.m_sUri;
    }

    protected PofConfig getPofConfig() {
        return this.m_cfg;
    }

    protected boolean isInterfaceAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_fInterfaceAllowed;
    }

    protected boolean isSubclassAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_fSubclassAllowed;
    }

    protected boolean isLambdaAllowed() {
        PofConfig cfg = this.m_cfg;
        return cfg != null && cfg.m_mapTypeIdByClass.containsKey(ROOT_LAMBDA_CLASS);
    }

    public boolean isReferenceEnabled() {
        return this.m_fReferenceEnabled;
    }

    public void setReferenceEnabled(boolean fReferenceEnabled) {
        this.m_fReferenceEnabled = fReferenceEnabled;
    }

    public void setPreferJavaTime(boolean fPreferJavaTime) {
        this.m_fPreferJavaTime = fPreferJavaTime;
    }

    public void setEnableAutoTypeDiscovery(boolean fEnableAutoTypeDiscovery) {
        this.m_fEnableAutoTypeDiscovery = fEnableAutoTypeDiscovery;
    }

    public void setIndexFileName(String sIndexFile) {
        this.m_sIndexFileName = sIndexFile;
    }

    public String getIndexFileName() {
        return this.m_sIndexFileName;
    }

    public String toString() {
        return this.getClass().getName() + " {location=" + this.m_sUri + "}";
    }

    protected void checkNotInitialized() {
        if (this.m_cfg != null) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void ensureInitialized() {
        if (this.m_cfg == null) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialize() {
        if (this.m_cfg == null) {
            PofConfig cfg;
            ConcurrentHashMap<String, PofConfig> mapConfigByURI;
            Map mapConfigByLoader;
            Map map = mapConfigByLoader = s_mapConfigurations;
            synchronized (map) {
                ClassLoader loader = this.getContextClassLoader();
                mapConfigByURI = (ConcurrentHashMap<String, PofConfig>)mapConfigByLoader.get(loader);
                if (mapConfigByURI == null) {
                    mapConfigByURI = new ConcurrentHashMap<String, PofConfig>();
                    mapConfigByLoader.put(loader, mapConfigByURI);
                }
            }
            String sURI = this.m_sUri;
            if (sURI == null) {
                this.m_sUri = sURI = DEFAULT_RESOURCE;
            }
            if ((cfg = (PofConfig)mapConfigByURI.get(sURI)) == null) {
                cfg = this.createPofConfig();
                ConcurrentHashMap<String, PofConfig> concurrentHashMap = mapConfigByURI;
                synchronized (concurrentHashMap) {
                    if (mapConfigByURI.containsKey(sURI)) {
                        cfg = (PofConfig)mapConfigByURI.get(sURI);
                    } else {
                        mapConfigByURI.put(sURI, cfg);
                    }
                }
            }
            this.m_cfg = cfg;
            this.m_fReferenceEnabled = cfg.m_fReferenceEnabled;
            this.m_fPreferJavaTime = cfg.m_fPreferJavaTime;
        }
    }

    protected Map<? extends String, ? extends Integer> discoverPortableTypes() {
        PofIndexer pofIndexer = new PofIndexer(this.getContextClassLoader());
        pofIndexer.setIndexFileName(this.getIndexFileName());
        Map<URL, Properties> mapIndexes = pofIndexer.loadIndexes();
        ConcurrentHashMap<String, Integer> mapPortableTypes = new ConcurrentHashMap<String, Integer>();
        if (mapIndexes.isEmpty() && this.m_fEnableAutoTypeDiscovery) {
            Logger.finer("No POF index files found. Executing auto-discovery of PortableType-annotated classes from the classpath. Be aware that this might be a time-consuming operation. The use of POF index files is preferred.");
            mapPortableTypes.putAll(pofIndexer.discoverPortableTypes());
            Logger.info(mapPortableTypes.size() + " class" + (mapPortableTypes.size() != 1 ? "es" : "") + " auto-discovered with PortableType annotation from classpath");
            return mapPortableTypes;
        }
        for (Map.Entry<URL, Properties> entry : mapIndexes.entrySet()) {
            Properties properties = entry.getValue();
            for (Map.Entry<Object, Object> mapEntry : properties.entrySet()) {
                String sClassName = (String)mapEntry.getKey();
                Integer pofId = mapEntry.getValue() != null && mapEntry.getValue() instanceof Integer ? Integer.valueOf((String)mapEntry.getValue()) : Integer.valueOf(pofIndexer.getPortableTypeIdForClassName(sClassName));
                mapPortableTypes.put(sClassName, pofId);
            }
            Logger.info(properties.size() + " class" + (properties.size() != 1 ? "es" : "") + " registered with PortableType annotation from index: " + String.valueOf(entry.getKey()));
        }
        return mapPortableTypes;
    }

    protected PofConfig createPofConfig() {
        Class<?> clz;
        Integer ITypeId;
        XmlElement xmlAllTypes;
        String sURI = this.m_sUri;
        XmlElement xmlConfig = this.m_xml;
        if (xmlConfig == null) {
            xmlConfig = XmlHelper.loadFileOrResourceOrDefault(sURI, "POF configuration", this.getContextClassLoader());
        }
        if ((xmlAllTypes = xmlConfig.getElement("user-type-list")) == null) {
            this.report(sURI, -1, null, null, "Missing <user-type-list> element");
        }
        ConfigurablePofContext.mergeIncludes(sURI, xmlConfig, this.getContextClassLoader());
        boolean fAllowInterfaces = xmlConfig.getSafeElement("allow-interfaces").getBoolean();
        boolean fAllowSubclasses = xmlConfig.getSafeElement("allow-subclasses").getBoolean();
        boolean fEnableReferences = xmlConfig.getSafeElement("enable-references").getBoolean();
        boolean fEnableTypeDiscovery = xmlConfig.getSafeElement("enable-type-discovery").getBoolean();
        boolean fEnableConfigDiscovery = xmlConfig.getSafeElement("enable-config-discovery").getBoolean(true);
        boolean fPreferJavaTime = xmlConfig.getSafeElement("prefer-java-time").getBoolean();
        ConcurrentHashMap<String, Integer> mapPortableTypes = new ConcurrentHashMap<String, Integer>();
        if (fEnableTypeDiscovery) {
            mapPortableTypes.putAll(this.discoverPortableTypes());
        }
        List listTypes = xmlAllTypes.getElementList();
        int nMaxTypeId = -1;
        boolean fSomeMissing = false;
        boolean fSomePresent = false;
        for (XmlElement xmlType : listTypes) {
            XmlElement xmlId;
            if (!xmlType.getName().equals("user-type")) {
                this.report(sURI, -1, null, null, "<user-type-list> contains an illegal element: " + xmlType.getName());
            }
            if ((xmlId = xmlType.getElement("type-id")) == null) {
                fSomeMissing = true;
                if (!fSomePresent) continue;
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
                continue;
            }
            int nTypeId = xmlId.getInt(-1);
            if (nTypeId < 0) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that has a missing or invalid type ID value: " + xmlId.getString(null));
            }
            fSomePresent = true;
            if (fSomeMissing) {
                this.report(sURI, -1, null, null, "<user-type-list> contains a <user-type> that is missing a type ID value");
            }
            if (nTypeId <= nMaxTypeId) continue;
            nMaxTypeId = nTypeId;
        }
        int cPortableTypes = mapPortableTypes.size();
        int nMinPortableTypeId = cPortableTypes == 0 ? 0 : (Integer)mapPortableTypes.values().stream().reduce(Integer::min).get();
        boolean fAutoNumber = fSomeMissing || nMinPortableTypeId == -1;
        WeakHashMap mapTypeIdByClass = new WeakHashMap();
        NullableConcurrentMap<String, Integer> mapTypeIdByClassName = new NullableConcurrentMap<String, Integer>();
        ConcurrentHashMap<Integer, String> mapClassNameByTypeId = new ConcurrentHashMap<Integer, String>();
        ConcurrentHashMap mapClzByTypeId = new ConcurrentHashMap();
        ConcurrentHashMap<Integer, PofSerializer> mapSerByTypeId = new ConcurrentHashMap<Integer, PofSerializer>();
        int cTypeIds = 0;
        for (XmlElement xmlElement : listTypes) {
            String sClass;
            int nTypeId;
            int n = nTypeId = fAutoNumber ? cTypeIds : xmlElement.getElement("type-id").getInt();
            if (mapClzByTypeId.containsKey(nTypeId)) {
                this.report(sURI, nTypeId, null, null, "Duplicate user type id");
            }
            if ((sClass = xmlElement.getSafeElement("class-name").getString()) == null || sClass.length() == 0) {
                this.report(sURI, nTypeId, null, null, "Missing class name");
            }
            ITypeId = nTypeId;
            clz = this.loadClass(sURI, sClass, nTypeId);
            this.validateClass(sURI, sClass, clz, nTypeId, fAllowInterfaces, fAllowSubclasses);
            XmlElement xmlSer = xmlElement.getElement("serializer");
            PofSerializer<Object> serializer = null;
            if (xmlSer == null) {
                if (clz.isAnnotationPresent(PortableType.class)) {
                    serializer = clz.isEnum() ? new EnumPofSerializer() : this.instantiateSerializer(clz.getAnnotation(PortableType.class).serializer(), (Integer)nTypeId, clz);
                } else if (PortableObject.class.isAssignableFrom(clz)) {
                    serializer = new PortableObjectSerializer(nTypeId);
                } else if (clz.getAnnotation(Portable.class) == null) {
                    this.report(sURI, nTypeId, clz.getName(), null, "Missing PofSerializer configuration");
                } else {
                    serializer = new PofAnnotationSerializer(nTypeId, clz);
                }
            } else {
                serializer = this.instantiateSerializer(xmlSer, nTypeId, clz);
            }
            if (serializer instanceof XmlConfigurable) {
                try {
                    SimpleElement xmlParams = new SimpleElement("config");
                    XmlHelper.transformInitParams(xmlParams, xmlSer.getSafeElement("init-params"));
                    ((XmlConfigurable)((Object)serializer)).setConfig(xmlParams);
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to configure PofSerializer");
                }
            }
            if (serializer instanceof ClassLoaderAware) {
                try {
                    ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(this.getContextClassLoader());
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, sClass, e, "Unable to set ContextClassLoader for PofSerializer");
                }
            }
            mapTypeIdByClass.put(clz, ITypeId);
            mapTypeIdByClassName.put(sClass, ITypeId);
            mapClassNameByTypeId.put(ITypeId, sClass);
            mapClzByTypeId.put(nTypeId, new WeakReference(clz));
            mapSerByTypeId.put(nTypeId, serializer);
            ++cTypeIds;
        }
        for (Map.Entry entry : mapPortableTypes.entrySet()) {
            String sClass = (String)entry.getKey();
            int nTypeId = (Integer)entry.getValue();
            ITypeId = nTypeId;
            if (mapClassNameByTypeId.containsKey(ITypeId)) {
                this.report(sURI, nTypeId, null, null, "Duplicate user type id from PortableType annotation");
            }
            clz = this.loadClass(sURI, sClass, nTypeId);
            this.validateClass(sURI, sClass, clz, nTypeId, fAllowInterfaces, fAllowSubclasses);
            mapTypeIdByClass.put(clz, ITypeId);
            mapTypeIdByClassName.put(sClass, ITypeId);
            mapClassNameByTypeId.put(ITypeId, sClass);
            mapClzByTypeId.put(nTypeId, new WeakReference(clz));
            EnumPofSerializer serializer = clz.isEnum() ? new EnumPofSerializer() : this.instantiateSerializer(clz.getAnnotation(PortableType.class).serializer(), (Integer)nTypeId, clz);
            mapSerByTypeId.put(nTypeId, serializer);
        }
        PofConfig cfg = new PofConfig();
        cfg.m_mapTypeIdByClass = new CopyOnWriteMap(mapTypeIdByClass);
        cfg.m_mapTypeIdByClassName = mapTypeIdByClassName;
        cfg.m_mapClassNameByTypeId = mapClassNameByTypeId;
        cfg.m_mapPortableTypes = mapPortableTypes;
        cfg.m_mapClzByTypeId = mapClzByTypeId;
        cfg.m_mapSerByTypeId = mapSerByTypeId;
        cfg.m_fInterfaceAllowed = fAllowInterfaces;
        cfg.m_fSubclassAllowed = fAllowSubclasses;
        cfg.m_fReferenceEnabled = fEnableReferences;
        cfg.m_fPreferJavaTime = fPreferJavaTime;
        cfg.m_fEnableTypeDiscovery = fEnableTypeDiscovery;
        cfg.m_fEnableConfigDiscovery = fEnableConfigDiscovery;
        return cfg;
    }

    private Class<?> loadClass(String sURI, String sClass, int nTypeId) {
        Class clz = null;
        try {
            clz = this.loadClass(sClass);
        }
        catch (RuntimeException e) {
            this.report(sURI, nTypeId, sClass, e, "Unable to load class for user type");
        }
        return clz;
    }

    private void validateClass(String sURI, String sClass, Class<?> clz, int nTypeId, boolean fAllowInterfaces, boolean fAllowSubclasses) {
        if (clz.isInterface()) {
            if (!fAllowInterfaces) {
                this.report(sURI, nTypeId, sClass, null, "User Type cannot be an interface (allow-interfaces=false)");
            }
        } else if (Modifier.isAbstract(clz.getModifiers()) && !fAllowSubclasses) {
            this.report(sURI, nTypeId, sClass, null, "User Type cannot be an abstract class (allow-subclasses=false)");
        }
    }

    protected PofSerializer instantiateSerializer(XmlElement xmlSer, int nTypeId, final Class clz) {
        final Integer ITypeId = nTypeId;
        PofSerializer serializer = null;
        String sURI = this.m_sUri;
        if (xmlSer != null) {
            Iterator iterParam;
            XmlElement xmlParams;
            String sSerClass = xmlSer.getElement("class-name").getString();
            if (sSerClass == null || sSerClass.length() == 0) {
                this.report(sURI, nTypeId, clz.getName(), null, "Missing PofSerializer class name");
            }
            Class clzSer = null;
            try {
                clzSer = this.loadClass(sSerClass);
            }
            catch (RuntimeException e) {
                this.report(sURI, nTypeId, clz.getName(), e, "Unable to load PofSerializer class: " + sSerClass);
            }
            if (!PofSerializer.class.isAssignableFrom(clzSer)) {
                this.report(sURI, nTypeId, clz.getName(), null, "Class is not a PofSerializer: " + sSerClass);
            }
            if ((xmlParams = xmlSer.getElement("init-params")) == null || (iterParam = xmlParams.getElements("init-param")).hasNext() && ((XmlElement)iterParam.next()).getElement("param-type") == null) {
                serializer = this.instantiateSerializer(clzSer, (Integer)nTypeId, clz);
            } else {
                XmlHelper.ParameterResolver resolver = new XmlHelper.ParameterResolver(){

                    @Override
                    public Object resolveParameter(String sType, String sValue) {
                        if (sValue.equals("{type-id}")) {
                            return ITypeId;
                        }
                        if (sValue.equals("{class-name}")) {
                            return clz.getName();
                        }
                        if (sValue.equals("{class}")) {
                            return clz;
                        }
                        if (sValue.equals("{class-loader}")) {
                            return ConfigurablePofContext.this.getContextClassLoader();
                        }
                        return sValue;
                    }
                };
                Object[] aoParams = null;
                try {
                    aoParams = XmlHelper.parseInitParams(xmlParams, resolver);
                }
                catch (RuntimeException e) {
                    this.report(sURI, nTypeId, clz.getName(), e, "Error parsing constructor parameters for PofSerializer:" + sSerClass);
                }
                try {
                    serializer = (PofSerializer)ClassHelper.newInstance(clzSer, aoParams);
                }
                catch (Throwable e) {
                    this.report(sURI, nTypeId, clz.getName(), e, "Unable to instantiate PofSerializer class: " + sSerClass);
                }
            }
        }
        return serializer;
    }

    protected PofSerializer<?> instantiateSerializer(Class<? extends PofSerializer> clzSer, Integer nTypeId, Class<?> clz) {
        try {
            return (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{nTypeId, clz, this.getContextClassLoader()});
        }
        catch (Throwable throwable) {
            try {
                return (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{nTypeId, clz});
            }
            catch (Throwable throwable2) {
                try {
                    return (PofSerializer)ClassHelper.newInstance(clzSer, new Object[]{nTypeId});
                }
                catch (Throwable throwable3) {
                    try {
                        return clzSer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable e) {
                        this.report(this.m_sUri, nTypeId, clz.getName(), e, "Unable to instantiate PofSerializer class using predefined constructors: " + clzSer.getName());
                        return null;
                    }
                }
            }
        }
    }

    protected Class loadClass(String sClass) {
        try {
            return ExternalizableHelper.loadClass(sClass, this.getContextClassLoader(), null);
        }
        catch (ClassNotFoundException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void report(String sURI, int nTypeId, String sClass, Throwable e, String sText) {
        StringBuffer sb = new StringBuffer();
        if (sURI != null && sURI.length() > 0) {
            sb.append("Config=").append(sURI);
        }
        if (nTypeId >= 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Type-Id=").append(nTypeId);
        }
        if (sClass != null && sClass.length() > 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Class-Name=").append(sClass);
        }
        if (sb.length() > 0) {
            sText = (String)sText + " (" + String.valueOf(sb) + ")";
        }
        throw e == null ? new IllegalStateException((String)sText) : Base.ensureRuntimeException(e, (String)sText);
    }

    public static void mergeIncludes(String sURI, XmlElement xmlConfig, ClassLoader loader) {
        boolean fAllowInterfaces = xmlConfig.getSafeElement("allow-interfaces").getBoolean();
        boolean fAllowSubclasses = xmlConfig.getSafeElement("allow-subclasses").getBoolean();
        boolean fEnableReferences = xmlConfig.getSafeElement("enable-references").getBoolean();
        boolean fEnableTypeDiscovery = xmlConfig.getSafeElement("enable-type-discovery").getBoolean();
        boolean fEnableConfigDiscovery = xmlConfig.getSafeElement("enable-config-discovery").getBoolean(true);
        boolean fAddedDiscovered = false;
        XmlElement xmlAllTypes = xmlConfig.getElement("user-type-list");
        if (!fEnableConfigDiscovery) {
            Logger.info("POF config discovery is disabled in " + sURI);
        }
        ConfigurablePofContext.appendDefaultSerializerToUserTypes(xmlConfig);
        Set setDiscovered = ServiceLoader.load(PofConfigProvider.class).stream().flatMap(p -> ((PofConfigProvider)p.get()).getConfigURIs().stream()).filter(Objects::nonNull).filter(s -> !s.isBlank()).collect(Collectors.toSet());
        if (fEnableConfigDiscovery && !xmlAllTypes.getElements("include").hasNext()) {
            fAddedDiscovered = true;
            for (String sDiscovered : setDiscovered) {
                xmlAllTypes.addElement("include").setString(sDiscovered);
            }
        }
        ArrayList<String> listURI = null;
        while (xmlAllTypes.getElement("include") != null) {
            if (listURI == null) {
                listURI = new ArrayList<String>();
                listURI.add(sURI);
            }
            ArrayList<XmlDocument> listInclude = new ArrayList<XmlDocument>();
            String sIncludeURI = null;
            Iterator iter = xmlAllTypes.getElements("include");
            while (iter.hasNext()) {
                sIncludeURI = ((XmlElement)iter.next()).getString();
                iter.remove();
                if (listURI.contains(sIncludeURI)) continue;
                listURI.add(sIncludeURI);
                String string = fAddedDiscovered && setDiscovered.contains(sIncludeURI) ? "discovered" : "included";
                listInclude.add(XmlHelper.loadFileOrResource(sIncludeURI, string + " POF configuration", loader));
            }
            for (XmlElement xmlElement : listInclude) {
                XmlElement xmlIncludeTypes = xmlElement.getSafeElement("user-type-list");
                ConfigurablePofContext.appendDefaultSerializerToUserTypes(xmlElement);
                fAllowInterfaces |= xmlElement.getSafeElement("allow-interfaces").getBoolean();
                fAllowSubclasses |= xmlElement.getSafeElement("allow-subclasses").getBoolean();
                fEnableReferences |= xmlElement.getSafeElement("enable-references").getBoolean();
                fEnableTypeDiscovery |= xmlElement.getSafeElement("enable-type-discovery").getBoolean();
                if (!(fEnableConfigDiscovery &= xmlElement.getSafeElement("enable-config-discovery").getBoolean(true))) {
                    Logger.info("POF config discovery is disabled in " + sIncludeURI);
                }
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("user-type"));
                XmlHelper.addElements(xmlAllTypes, xmlIncludeTypes.getElements("include"));
            }
            if (!fEnableConfigDiscovery || xmlAllTypes.getElements("include").hasNext() || fAddedDiscovered) continue;
            fAddedDiscovered = true;
            for (String string : setDiscovered) {
                if (listURI.contains(string)) continue;
                xmlAllTypes.addElement("include").setString(string);
            }
        }
        xmlConfig.ensureElement("allow-interfaces").setBoolean(fAllowInterfaces);
        xmlConfig.ensureElement("allow-subclasses").setBoolean(fAllowSubclasses);
        xmlConfig.ensureElement("enable-type-discovery").setBoolean(fEnableTypeDiscovery);
        xmlConfig.ensureElement("enable-references").setBoolean(fEnableReferences);
        xmlConfig.ensureElement("enable-config-discovery").setBoolean(fEnableConfigDiscovery);
    }

    protected static void appendDefaultSerializerToUserTypes(XmlElement xmlConfig) {
        XmlElement xmlDefaultSerializer = xmlConfig.getElement("default-serializer");
        if (xmlDefaultSerializer != null) {
            XmlElement xmlAllTypes = xmlConfig.getElement("user-type-list");
            Iterator iter = xmlAllTypes.getElements("user-type");
            while (iter.hasNext()) {
                XmlElement xmlType = (XmlElement)iter.next();
                XmlElement xmlSer = xmlType.getElement("serializer");
                if (xmlSer != null) continue;
                XmlElement xmlNewSer = (XmlElement)xmlDefaultSerializer.clone();
                xmlNewSer.setName("serializer");
                xmlType.getElementList().add(xmlNewSer);
            }
        }
    }

    protected static class PofConfig {
        public Map<Class<?>, Integer> m_mapTypeIdByClass;
        public Map<String, Integer> m_mapTypeIdByClassName;
        public Map<Integer, WeakReference<Class<?>>> m_mapClzByTypeId;
        public Map<Integer, PofSerializer> m_mapSerByTypeId;
        public boolean m_fInterfaceAllowed;
        public boolean m_fSubclassAllowed;
        public boolean m_fReferenceEnabled;
        public boolean m_fPreferJavaTime;
        public Map<Integer, String> m_mapClassNameByTypeId;
        public Map<String, Integer> m_mapPortableTypes;
        public boolean m_fEnableTypeDiscovery;
        public boolean m_fEnableConfigDiscovery = true;

        protected PofConfig() {
        }
    }
}

