/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ByteBufferWriteBuffer
extends AbstractWriteBuffer
implements WriteBuffer {
    private final ByteBuffer m_buf;
    private transient ByteBufferReadBuffer m_bufUnsafe;

    public ByteBufferWriteBuffer(ByteBuffer buf) {
        if (buf.order() != ByteOrder.BIG_ENDIAN) {
            buf = buf.slice();
            buf.order(ByteOrder.BIG_ENDIAN);
        } else if (buf.position() != 0) {
            buf = buf.slice();
        }
        this.m_buf = buf;
    }

    protected ByteBufferWriteBuffer(ByteBufferWriteBuffer that) {
        this.m_buf = that.m_buf.duplicate();
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    @Override
    public void write(int ofDest, byte b) {
        ByteBuffer buf = this.getByteBuffer();
        int ofCur = buf.position();
        if (ofDest == ofCur) {
            buf.put(b);
        } else {
            buf.put(ofDest, b);
            if (ofDest > ofCur) {
                buf.position(ofDest + 1);
            }
        }
    }

    @Override
    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        ByteBuffer bufDest = this.getByteBuffer();
        int ofCur = bufDest.position();
        int ofEnd = ofDest + cbSrc;
        if (ofEnd > bufDest.limit()) {
            throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", cbSrc=" + cbSrc + ", getCapacity()=" + bufDest.limit());
        }
        if (ofDest != ofCur) {
            bufDest.position(ofDest);
        }
        try {
            bufDest.put(abSrc, ofSrc, cbSrc);
        }
        catch (RuntimeException e) {
            bufDest.position(ofCur);
            throw e;
        }
        if (ofEnd < ofCur) {
            bufDest.position(ofCur);
        }
    }

    @Override
    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        if (bufSrc instanceof Binary) {
            Binary binSrc = bufSrc.toBinary(ofSrc, cbSrc);
            ByteBuffer bufDest = this.getByteBuffer();
            int ofCur = bufDest.position();
            int ofEnd = ofDest + cbSrc;
            if (ofEnd > bufDest.limit()) {
                throw new IndexOutOfBoundsException("ofDest=" + ofDest + ", cbSrc=" + cbSrc + ", getCapacity()=" + bufDest.limit());
            }
            if (ofDest != ofCur) {
                bufDest.position(ofDest);
            }
            try {
                binSrc.writeTo(bufDest);
            }
            catch (RuntimeException e) {
                bufDest.position(ofCur);
                throw e;
            }
            if (ofEnd < ofCur) {
                bufDest.position(ofCur);
            }
        } else {
            super.write(ofDest, bufSrc, ofSrc, cbSrc);
        }
    }

    @Override
    public int length() {
        return this.getByteBuffer().position();
    }

    public void setLength(int cb) {
        int cbMax = this.getCapacity();
        if (cb < 0 || cb > cbMax) {
            throw new IndexOutOfBoundsException("cb=" + cb + ", getCapacity()=" + cbMax);
        }
        this.getByteBuffer().position(cb);
    }

    @Override
    public void retain(int of, int cb) {
        ByteBuffer buf = this.getByteBuffer();
        int cbBuf = buf.limit();
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", getCapacity()=" + cbBuf);
        }
        buf.position(of);
        buf.limit(of + cb);
        buf.compact();
        buf.limit(cbBuf);
        buf.position(cb);
    }

    @Override
    public int getCapacity() {
        return this.getByteBuffer().limit();
    }

    @Override
    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new ByteBufferOutput(of);
    }

    @Override
    public ReadBuffer getReadBuffer() {
        return this.toBinary();
    }

    @Override
    public ReadBuffer getUnsafeReadBuffer() {
        ByteBufferReadBuffer bufUnsafe = this.m_bufUnsafe;
        if (bufUnsafe == null) {
            this.m_bufUnsafe = bufUnsafe = new ByteBufferReadBuffer(this.getByteBuffer().duplicate().flip());
        } else {
            bufUnsafe.getByteBuffer().limit(this.getByteBuffer().position());
        }
        return bufUnsafe;
    }

    @Override
    public byte[] toByteArray() {
        return this.getUnsafeReadBuffer().toByteArray();
    }

    @Override
    public Binary toBinary() {
        return this.getUnsafeReadBuffer().toBinary();
    }

    @Override
    public Object clone() {
        ByteBuffer bufThis = this.getByteBuffer();
        int cbCur = bufThis.position();
        int cbMax = bufThis.limit();
        ByteBuffer bufThat = bufThis.isDirect() ? ByteBuffer.allocateDirect(cbMax) : ByteBuffer.allocate(cbMax);
        bufThis.limit(cbCur).position(0);
        bufThat.put(bufThis);
        bufThis.limit(cbMax).position(cbCur);
        return new ByteBufferWriteBuffer(bufThat);
    }

    public ByteBufferWriteBuffer getUnsafeWriteBuffer() {
        return new ByteBufferWriteBuffer(this);
    }

    public final class ByteBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        public ByteBufferOutput(int of) {
            super(of);
        }

        @Override
        public ByteBuffer getByteBuffer(int cb) {
            ByteBuffer buf = this.getByteBuffer();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + cb;
            buf.position(ofFinal);
            this.m_ofWrite = ofFinal;
            return buf.slice(ofStream, cb);
        }

        @Override
        public void writeShort(int n) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 2;
            if (ofBuf == ofStream) {
                buf.putShort((short)n);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putShort((short)n);
            } else {
                buf.putShort(ofStream, (short)n);
            }
            this.m_ofWrite = ofFinal;
        }

        @Override
        public void writeChar(int ch) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 2;
            if (ofBuf == ofStream) {
                buf.putChar((char)ch);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putChar((char)ch);
            } else {
                buf.putChar(ofStream, (char)ch);
            }
            this.m_ofWrite = ofFinal;
        }

        @Override
        public void writeInt(int n) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 4;
            if (ofBuf == ofStream) {
                buf.putInt(n);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putInt(n);
            } else {
                buf.putInt(ofStream, n);
            }
            this.m_ofWrite = ofFinal;
        }

        @Override
        public void writeLong(long l) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 8;
            if (ofBuf == ofStream) {
                buf.putLong(l);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putLong(l);
            } else {
                buf.putLong(ofStream, l);
            }
            this.m_ofWrite = ofFinal;
        }

        @Override
        public void writeFloat(float fl) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 4;
            if (ofBuf == ofStream) {
                buf.putFloat(fl);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putFloat(fl);
            } else {
                buf.putFloat(ofStream, fl);
            }
            this.m_ofWrite = ofFinal;
        }

        @Override
        public void writeDouble(double dfl) throws IOException {
            ByteBuffer buf = this.getByteBuffer();
            int ofBuf = buf.position();
            int ofStream = this.m_ofWrite;
            int ofFinal = ofStream + 8;
            if (ofBuf == ofStream) {
                buf.putDouble(dfl);
            } else if (ofFinal > ofBuf) {
                buf.position(ofStream);
                buf.putDouble(dfl);
            } else {
                buf.putDouble(ofStream, dfl);
            }
            this.m_ofWrite = ofFinal;
        }

        private ByteBuffer getByteBuffer() {
            return ByteBufferWriteBuffer.this.getByteBuffer();
        }
    }
}

