/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.bdb;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.io.AbstractBinaryStore;
import com.tangosol.io.bdb.DatabaseFactory;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BerkeleyDBBinaryStore
extends AbstractBinaryStore {
    protected volatile DatabaseHolder m_db;
    protected DatabaseFactory m_factory;
    protected final Lock f_lock = new ReentrantLock();

    public BerkeleyDBBinaryStore(String sDbName, DatabaseFactory dbFactory) throws DatabaseException {
        BerkeleyDBBinaryStore.azzert(dbFactory != null);
        this.init(sDbName, dbFactory);
    }

    protected void init(String sDbName, DatabaseFactory dbFactory) throws DatabaseException {
        this.m_factory = dbFactory;
        this.m_db = new DatabaseHolder(sDbName);
    }

    public String toString() {
        return "BerkeleyDBBinaryStore { DB Holder: " + String.valueOf(this.getDbHolder()) + " Environment Directory: " + String.valueOf(this.m_factory.getEnvHolder().getDirEnv()) + "}";
    }

    @Override
    public Binary load(Binary binKey) {
        DatabaseEntry dbeKey = new DatabaseEntry(binKey.toByteArray());
        DatabaseEntry dbeValue = new DatabaseEntry();
        DatabaseHolder db = this.getDbHolder();
        this.f_lock.lock();
        try {
            OperationStatus status = db.getDb().get(null, dbeKey, dbeValue, null);
            if (status == OperationStatus.SUCCESS) {
                Binary binary = new Binary(dbeValue.getData());
                return binary;
            }
            if (status == OperationStatus.NOTFOUND) {
                Binary binary = null;
                return binary;
            }
            try {
                throw new IllegalStateException("Unexpected status result from Berkeley DB load, status=" + String.valueOf((Object)status));
            }
            catch (DatabaseException e) {
                throw Base.ensureRuntimeException(e, "Berkeley DB load operation failed");
            }
        }
        finally {
            this.f_lock.unlock();
        }
    }

    @Override
    public void store(Binary binKey, Binary binValue) {
        DatabaseEntry dbeKey = new DatabaseEntry(binKey.toByteArray());
        DatabaseEntry dbeValue = new DatabaseEntry(binValue.toByteArray());
        DatabaseHolder db = this.getDbHolder();
        this.f_lock.lock();
        try {
            OperationStatus status = db.getDb().put(null, dbeKey, dbeValue);
            if (status != OperationStatus.SUCCESS) {
                throw new IllegalStateException("Unexpected Berkeley DB status result while storing an entry, status=" + String.valueOf((Object)status));
            }
        }
        catch (DatabaseException e) {
            throw Base.ensureRuntimeException(e, "Berkeley DB store operation failed.");
        }
        finally {
            this.f_lock.unlock();
        }
    }

    @Override
    public void erase(Binary binKey) {
        DatabaseEntry dbeKey = new DatabaseEntry(binKey.toByteArray());
        DatabaseHolder db = this.getDbHolder();
        this.f_lock.lock();
        try {
            OperationStatus status = db.getDb().delete(null, dbeKey);
            if (status != OperationStatus.SUCCESS && status != OperationStatus.NOTFOUND) {
                throw new IllegalStateException("Unexpected Berkeley DB status result while deleting an entry, status=" + String.valueOf((Object)status));
            }
        }
        catch (DatabaseException e) {
            throw Base.ensureRuntimeException(e, "Berkeley DB delete operation failed.");
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseAll() {
        block14: {
            if (this.m_db.isTemporary()) {
                try {
                    this.m_db = new DatabaseHolder(null);
                }
                catch (DatabaseException e) {
                    throw Base.ensureRuntimeException(e, "Failed to allocate a new Berkeley DB as part of the eraseAll operation.");
                }
            }
            this.f_lock.lock();
            try {
                DatabaseHolder db = this.getDbHolder();
                try (Cursor cursor = null;){
                    OperationStatus status;
                    block15: {
                        cursor = db.getDb().openCursor(null, CursorConfig.READ_UNCOMMITTED);
                        DatabaseEntry dbeTmp = new DatabaseEntry();
                        do {
                            if ((status = cursor.getNext(dbeTmp, dbeTmp, null)) == OperationStatus.NOTFOUND) {
                                break block14;
                            }
                            if (status != OperationStatus.SUCCESS) break block15;
                        } while ((status = cursor.delete()) == OperationStatus.SUCCESS);
                        throw new IllegalStateException("Unexpected Berkeley DB status result while performing eraseAll, status=" + String.valueOf((Object)status));
                    }
                    throw new IllegalStateException("Unexpected Berkeley DB status result while performing eraseAll, status=" + String.valueOf((Object)status));
                }
            }
            catch (DatabaseException e) {
                throw Base.ensureRuntimeException(e, "Error while performing eraseAll on Berkeley DB.");
            }
            finally {
                this.f_lock.unlock();
            }
        }
    }

    @Override
    public Iterator keys() {
        try {
            Cursor cursor;
            final DatabaseHolder db = this.getDbHolder();
            this.f_lock.lock();
            try {
                cursor = db.getDb().openCursor(null, CursorConfig.READ_UNCOMMITTED);
            }
            finally {
                this.f_lock.unlock();
            }
            return new Iterator(){
                private DatabaseEntry m_dbeKey = new DatabaseEntry();
                private DatabaseEntry m_dbeValue = new DatabaseEntry();
                private Binary m_binNext = this.readNext();

                @Override
                public boolean hasNext() {
                    return this.m_binNext != null;
                }

                public Object next() {
                    Binary binKey = this.m_binNext;
                    if (binKey == null) {
                        throw new NoSuchElementException();
                    }
                    this.m_binNext = this.readNext();
                    return binKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Binary readNext() {
                    byte[] abKey = null;
                    BerkeleyDBBinaryStore.this.f_lock.lock();
                    try {
                        DatabaseEntry dbeKey = this.m_dbeKey;
                        DatabaseEntry dbeValue = this.m_dbeValue;
                        dbeValue.setPartial(0, 0, true);
                        OperationStatus status = cursor.getNext(dbeKey, this.m_dbeValue, null);
                        if (status == OperationStatus.SUCCESS) {
                            abKey = dbeKey.getData();
                        }
                    }
                    catch (DatabaseException databaseException) {
                    }
                    finally {
                        BerkeleyDBBinaryStore.this.f_lock.unlock();
                    }
                    if (abKey == null || db != BerkeleyDBBinaryStore.this.getDbHolder()) {
                        this.invalidate();
                        return null;
                    }
                    return new Binary(abKey);
                }

                private void invalidate() {
                    BerkeleyDBBinaryStore.this.f_lock.lock();
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        BerkeleyDBBinaryStore.this.f_lock.unlock();
                    }
                }

                protected void finalize() throws Throwable {
                    this.invalidate();
                    super.finalize();
                }
            };
        }
        catch (DatabaseException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void close() {
        this.m_db = null;
    }

    public DatabaseHolder getDbHolder() {
        DatabaseHolder db = this.m_db;
        if (db == null) {
            throw new IllegalStateException("The Berkeley DB BinaryStore has been closed.");
        }
        return db;
    }

    public DatabaseFactory getFactory() {
        return this.m_factory;
    }

    protected class DatabaseHolder {
        protected Database m_db;
        protected String m_sDbName;
        protected boolean m_fTemporary;

        public DatabaseHolder(String sDbName) throws DatabaseException {
            DatabaseFactory factory = BerkeleyDBBinaryStore.this.getFactory();
            if (sDbName == null) {
                sDbName = factory.getUniqueDbName();
                this.m_fTemporary = true;
            } else {
                this.m_fTemporary = false;
            }
            this.m_db = factory.createNamedDatabase(sDbName);
            this.m_sDbName = sDbName;
        }

        public String toString() {
            return "DatabaseHolder {DB Name: " + this.getName() + " Temporary: " + this.isTemporary() + "}";
        }

        protected void finalize() throws Throwable {
            this.closeDb();
            super.finalize();
        }

        public Database getDb() {
            return this.m_db;
        }

        public String getName() {
            return this.m_sDbName;
        }

        public boolean isTemporary() {
            return this.m_fTemporary;
        }

        protected void closeDb() throws DatabaseException {
            boolean fRemove;
            Database db = this.m_db;
            BerkeleyDBBinaryStore.this.getFactory().forgetDatabase(db);
            if (this.isTemporary()) {
                fRemove = true;
            } else {
                DatabaseEntry dbEntry = new DatabaseEntry();
                Cursor csr = db.openCursor(null, CursorConfig.READ_UNCOMMITTED);
                OperationStatus status = csr.getNext(dbEntry, dbEntry, null);
                csr.close();
                boolean bl = fRemove = status == OperationStatus.NOTFOUND;
            }
            if (fRemove) {
                Environment env = db.getEnvironment();
                db.close();
                env.removeDatabase(null, this.m_sDbName);
            } else {
                db.close();
            }
        }
    }
}

