/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.internal.net.MessageComponent;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.IOException;

public class WrapperBufferInput
extends WrapperDataInputStream
implements ReadBuffer.BufferInput {
    private final ReadBuffer.BufferInput m_bufIn;

    public WrapperBufferInput(DataInput in) {
        this(in, null);
    }

    public WrapperBufferInput(DataInput in, ClassLoader loader) {
        super(in, loader);
        this.m_bufIn = in instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)in : null;
    }

    @Override
    public ReadBuffer getBuffer() {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? null : bufIn.getBuffer();
    }

    @Override
    public String readSafeUTF() throws IOException {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? ExternalizableHelper.readSafeUTF(this.m_in) : bufIn.readSafeUTF();
    }

    @Override
    public int readPackedInt() throws IOException {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? ExternalizableHelper.readInt(this.m_in) : bufIn.readPackedInt();
    }

    @Override
    public long readPackedLong() throws IOException {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? ExternalizableHelper.readLong(this.m_in) : bufIn.readPackedLong();
    }

    @Override
    public ReadBuffer readBuffer(int cb) throws IOException {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        if (bufIn == null) {
            byte[] ab = new byte[cb];
            this.readFully(ab);
            return new ByteArrayReadBuffer(ab);
        }
        return bufIn.readBuffer(cb);
    }

    @Override
    public int getOffset() {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? 0 : bufIn.getOffset();
    }

    @Override
    public void setOffset(int of) {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        if (bufIn == null) {
            throw new UnsupportedOperationException();
        }
        bufIn.setOffset(of);
    }

    @Override
    public Object getObjectInputFilter() {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        return bufIn == null ? null : bufIn.getObjectInputFilter();
    }

    @Override
    public void setObjectInputFilter(Object filter) {
        ReadBuffer.BufferInput bufIn = this.m_bufIn;
        if (bufIn != null) {
            bufIn.setObjectInputFilter(filter);
        }
    }

    @Override
    public DataInput getDataInput() {
        return this.m_in;
    }

    public static class VersionAwareBufferInput
    extends WrapperBufferInput {
        protected final MessageComponent f_message;

        public VersionAwareBufferInput(DataInput in, ClassLoader loader, MessageComponent msg) {
            super(in, loader);
            this.f_message = msg;
        }

        public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
            return this.f_message.isSenderCompatible(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        }

        public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
            return this.f_message.isSenderCompatible(nYear, nMonth, nPatch);
        }

        public boolean isVersionCompatible(int nEncodedVersion) {
            return this.f_message.isSenderCompatible(nEncodedVersion);
        }

        public boolean isPatchCompatible(int nEncodedVersion) {
            return this.f_message.isSenderPatchCompatible(nEncodedVersion);
        }
    }
}

