/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public interface Serializer {
    public void serialize(WriteBuffer.BufferOutput var1, Object var2) throws IOException;

    default public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        return this.deserialize(in, Object.class);
    }

    default public <T> T deserialize(ReadBuffer.BufferInput in, Class<? extends T> clazz) throws IOException {
        return (T)this.deserialize(in);
    }

    default public String getName() {
        Named named = this.getClass().getAnnotation(Named.class);
        return named == null ? null : named.value();
    }

    public static Map<String, SerializerFactory> discoverSerializers() {
        return Serializer.discoverSerializers(Classes.getContextClassLoader());
    }

    public static Map<String, SerializerFactory> discoverSerializers(ClassLoader loader) {
        HashMap<String, SerializerFactory> map = new HashMap<String, SerializerFactory>();
        map.putAll(Serializer.loadSerializers(ServiceLoader.load(SerializerFactory.class, loader), SerializerFactory.class));
        map.putAll(Serializer.loadSerializers(ServiceLoader.load(Serializer.class, loader), Serializer.class));
        return map;
    }

    private static <T> Map<String, SerializerFactory> loadSerializers(ServiceLoader<T> serviceLoader, Class<T> clz) {
        HashMap<String, SerializerFactory> mapSerializer = new HashMap<String, SerializerFactory>();
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                Object service = iterator.next();
                String sName = null;
                SerializerFactory factory = null;
                if (service instanceof SerializerFactory) {
                    factory = (SerializerFactory)service;
                    sName = factory.getName();
                } else {
                    sName = ((Serializer)service).getName();
                    factory = clzLoader -> {
                        try {
                            Serializer serializer = (Serializer)service.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                            if (serializer instanceof ClassLoaderAware) {
                                ((ClassLoaderAware)((Object)serializer)).setContextClassLoader(clzLoader);
                            }
                            return serializer;
                        }
                        catch (Exception e) {
                            throw Base.ensureRuntimeException(e, String.format("Unable to create serializer type [%s]", service.getClass().getName()));
                        }
                    };
                }
                if (mapSerializer.putIfAbsent(sName, factory) == null) continue;
                Logger.warn(String.format("serializer factory already defined for %s, type [%s]; ignoring this discovered implementation", sName, service.getClass().getName()));
            }
            catch (Throwable t) {
                Logger.err("Failed to load service of type " + String.valueOf(clz), t);
            }
        }
        return mapSerializer;
    }
}

