/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.InputStreaming;
import java.io.IOException;
import java.io.InputStream;

public class MultiByteArrayInputStream
extends InputStream
implements InputStreaming {
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected static final int MARK_UNSET = Integer.MAX_VALUE;
    protected boolean m_fEOF;
    protected boolean m_fDestructive;
    protected byte[][] m_aabArray;
    protected int m_iArray;
    protected byte[] m_ab;
    protected int m_of;
    protected int m_iArrayMarked = Integer.MAX_VALUE;
    protected int m_ofMarked;

    public MultiByteArrayInputStream(byte[][] aab) {
        this(aab, false);
    }

    public MultiByteArrayInputStream(byte[][] aab, boolean fDestructive) {
        this.m_aabArray = aab;
        this.m_fDestructive = fDestructive;
        if (aab == null || aab.length == 0) {
            this.m_ab = EMPTY_BYTES;
            this.m_fEOF = true;
        } else {
            this.m_ab = aab[0];
            this.m_fEOF = aab.length == 1 && aab[0].length == 0;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.m_fEOF) {
            return -1;
        }
        byte[] ab = this.m_ab;
        int cb = ab.length;
        int of = this.m_of;
        int n = ab[of++] & 0xFF;
        if (of == cb) {
            byte[][] aab = this.m_aabArray;
            int cab = aab.length;
            int iab = this.m_iArray;
            if (this.m_fDestructive && iab < this.m_iArrayMarked) {
                aab[iab] = null;
            }
            if (iab == cab - 1) {
                this.m_fEOF = true;
            } else {
                this.m_iArray = ++iab;
                this.m_ab = aab[iab];
                this.m_of = 0;
            }
        } else {
            this.m_of = of;
        }
        return n;
    }

    @Override
    public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
        if (this.m_fEOF) {
            return -1;
        }
        int cbRead = 0;
        while (true) {
            int of;
            byte[] ab;
            int cb;
            int cbLeft;
            if (cbDest < (cbLeft = (cb = (ab = this.m_ab).length) - (of = this.m_of))) {
                System.arraycopy(ab, of, abDest, ofDest, cbDest);
                this.m_of = of + cbDest;
                return cbRead += cbDest;
            }
            System.arraycopy(ab, of, abDest, ofDest, cbLeft);
            cbRead += cbLeft;
            byte[][] aab = this.m_aabArray;
            int cab = aab.length;
            int iab = this.m_iArray;
            if (this.m_fDestructive && iab < this.m_iArrayMarked) {
                aab[iab] = null;
            }
            if (iab == cab - 1) {
                this.m_of = ab.length;
                this.m_fEOF = true;
                return cbRead;
            }
            this.m_iArray = ++iab;
            this.m_ab = aab[iab];
            this.m_of = 0;
            ofDest += cbLeft;
            cbDest -= cbLeft;
        }
    }

    @Override
    public int available() {
        if (this.m_fEOF) {
            return 0;
        }
        byte[][] aab = this.m_aabArray;
        int of = this.m_of;
        int cb = 0;
        int c = aab.length;
        for (int i = this.m_iArray; i < c; ++i) {
            cb += aab[i].length - of;
            of = 0;
        }
        return cb;
    }

    @Override
    public long skip(long n) {
        if (n < 0L || n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("out of bounds: skip(n=" + n + ")");
        }
        if (this.m_fEOF) {
            return 0L;
        }
        int cbSkip = (int)n;
        byte[] ab = this.m_ab;
        int cb = ab.length;
        int of = this.m_of;
        int cbLeft = cb - of;
        if (cbSkip < cbLeft) {
            this.m_of = of + cbSkip;
            return cbSkip;
        }
        byte[][] aab = this.m_aabArray;
        int cab = aab.length;
        int iab = this.m_iArray;
        if (this.m_fDestructive && iab < this.m_iArrayMarked) {
            aab[iab] = null;
        }
        if (iab == cab - 1 && cbSkip > cbLeft) {
            this.m_of = ab.length;
            this.m_fEOF = true;
            return cbLeft;
        }
        this.m_iArray = ++iab;
        this.m_ab = aab[iab];
        this.m_of = 0;
        return (long)cbLeft + this.skip(cbSkip - cbLeft);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
        int iMarkOld;
        int iMarkNew = this.m_iArrayMarked = this.m_iArray;
        this.m_ofMarked = this.m_of;
        if (this.m_fDestructive && iMarkOld != Integer.MAX_VALUE) {
            byte[][] aabArray = this.m_aabArray;
            for (iMarkOld = this.m_iArrayMarked; iMarkOld < iMarkNew; ++iMarkOld) {
                aabArray[iMarkOld] = null;
            }
        }
    }

    @Override
    public void reset() throws IOException {
        int iMarked = this.m_iArrayMarked;
        if (iMarked == Integer.MAX_VALUE) {
            throw new IOException("the stream has not been marked");
        }
        byte[][] aabArray = this.m_aabArray;
        this.m_iArray = iMarked;
        this.m_of = this.m_ofMarked;
        this.m_ab = aabArray[iMarked];
        this.m_fEOF = iMarked == aabArray.length - 1 && this.m_of == this.m_ab.length;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

