/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MultiBufferWriteBuffer
extends AbstractWriteBuffer
implements Disposable {
    static final byte[] FILL = new byte[1024];
    private WriteBufferPool m_bufferpool;
    private WriteBuffer m_bufLast;
    private WriteBuffer m_bufOverflow;
    private int m_ofLastBuffer;
    private int m_cBuffers;
    private WriteBuffer[] m_aBuffer;
    private int[] m_aofBuffer;
    private transient int m_ofLastLookup;
    private transient int m_iBufLastAnswer;
    private MultiBufferOutput m_outInternal;
    private MultiBufferReadBuffer m_bufUnsafe;

    public MultiBufferWriteBuffer(WriteBufferPool bufferpool) {
        this(bufferpool, 0);
    }

    public MultiBufferWriteBuffer(WriteBufferPool bufferpool, int cbEstimate) {
        this.m_bufferpool = bufferpool;
        this.m_bufLast = bufferpool.allocate(cbEstimate);
        this.m_cBuffers = 1;
    }

    @Override
    public void write(int ofDest, byte b) {
        try {
            this.ensureBufferOutput(ofDest).write(b);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        try {
            this.ensureBufferOutput(ofDest).write(abSrc, ofSrc, cbSrc);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        int cbTotal = this.length();
        if (ofDest != cbTotal) {
            if (ofDest < cbTotal) {
                int cbAppend = 0;
                int ofAppend = 0;
                int ofEnd = ofDest + cbSrc;
                if (ofEnd > cbTotal) {
                    cbAppend = ofEnd - cbTotal;
                    ofAppend = ofSrc + cbSrc - cbAppend;
                    cbSrc -= cbAppend;
                }
                int iBuf = this.getBufferIndexByOffset(ofDest);
                WriteBuffer buf = this.getBuffer(iBuf);
                int ofWrite = ofDest - this.getBufferOffset(iBuf);
                int cbWrite = Math.min(buf.length() - ofWrite, cbSrc);
                buf.write(ofWrite, bufSrc, ofSrc, cbWrite);
                ofDest += cbWrite;
                ofSrc += cbWrite;
                cbSrc -= cbWrite;
                while (cbSrc > 0) {
                    buf = this.getBuffer(++iBuf);
                    cbWrite = Math.min(buf.length(), cbSrc);
                    buf.write(0, bufSrc, ofSrc, cbWrite);
                    ofDest += cbWrite;
                    ofSrc += cbWrite;
                    cbSrc -= cbWrite;
                }
                if (cbAppend == 0) {
                    return;
                }
                ofSrc = ofAppend;
                cbSrc = cbAppend;
                assert (ofDest == cbTotal);
            } else {
                this.ensureBufferOutput(ofDest);
            }
        }
        WriteBuffer buf = this.m_bufLast;
        int cbWrite = Math.min(cbSrc, this.getCurrentBufferRemaining());
        if (cbWrite > 0) {
            buf.write(buf.length(), bufSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
        while (cbSrc > 0) {
            buf = this.addBuffer();
            cbWrite = Math.min(cbSrc, buf.getCapacity());
            buf.write(0, bufSrc, ofSrc, cbWrite);
            ofSrc += cbWrite;
            cbSrc -= cbWrite;
        }
    }

    @Override
    public int length() {
        WriteBuffer bufLast = this.m_bufLast;
        return this.m_ofLastBuffer + (bufLast == null ? 0 : bufLast.length());
    }

    @Override
    public void retain(int of, int cb) {
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 1) {
            this.m_bufLast.retain(of, cb);
        } else {
            WriteBufferPool pool = this.getBufferPool();
            if (cb == 0) {
                WriteBuffer[] abuf = this.m_aBuffer;
                int[] aof = this.m_aofBuffer;
                WriteBuffer buf = abuf[0];
                buf.clear();
                this.m_bufLast = buf;
                this.m_ofLastBuffer = 0;
                this.m_cBuffers = 1;
                WriteBuffer bufOverflow = this.m_bufOverflow;
                if (cBuffers > 1 && bufOverflow != null) {
                    abuf[cBuffers - 1] = bufOverflow;
                    this.m_bufOverflow = null;
                }
                for (int i = 0; i < cBuffers; ++i) {
                    if (i > 0) {
                        pool.release(abuf[i]);
                    }
                    abuf[i] = null;
                    aof[i] = 0;
                }
            } else {
                ReadBuffer bufSrc = this.getUnsafeReadBuffer();
                WriteBuffer[] abuf = this.m_aBuffer;
                WriteBuffer bufOverflow = this.m_bufOverflow;
                if (bufOverflow != null) {
                    abuf[cBuffers - 1] = bufOverflow;
                }
                this.m_bufLast = null;
                this.m_bufOverflow = null;
                this.m_ofLastBuffer = 0;
                this.m_cBuffers = 0;
                this.m_aBuffer = null;
                this.m_aofBuffer = null;
                this.addBuffer();
                this.write(0, bufSrc, of, cb);
                for (int i = 0; i < cBuffers; ++i) {
                    pool.release(abuf[i]);
                }
            }
        }
        this.m_ofLastLookup = 0;
        this.m_iBufLastAnswer = 0;
        this.m_outInternal = null;
        this.m_bufUnsafe = null;
    }

    @Override
    public int getCapacity() {
        return this.m_ofLastBuffer + this.m_bufLast.getCapacity();
    }

    @Override
    public int getMaximumCapacity() {
        return this.getBufferPool().getMaximumCapacity();
    }

    @Override
    public ReadBuffer getReadBuffer() {
        return new ByteArrayReadBuffer(this.toByteArray());
    }

    @Override
    public ReadBuffer getUnsafeReadBuffer() {
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 1) {
            return this.getBuffer(0).getUnsafeReadBuffer();
        }
        MultiBufferReadBuffer buf = this.m_bufUnsafe;
        int cb = this.length();
        if (buf == null || buf.length() != cb) {
            ReadBuffer[] abuf = new ReadBuffer[cBuffers];
            int[] aof = new int[cBuffers];
            for (int i = 0; i < cBuffers; ++i) {
                abuf[i] = this.getBuffer(i).getUnsafeReadBuffer();
                aof[i] = this.getBufferOffset(i);
            }
            this.m_bufUnsafe = buf = new MultiBufferReadBuffer(abuf, aof, 0, cb);
        }
        return buf;
    }

    @Override
    public byte[] toByteArray() {
        int i;
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 1) {
            return this.m_bufLast.toByteArray();
        }
        int cb = this.length();
        byte[] ab = new byte[cb];
        WriteBuffer[] abuf = this.m_aBuffer;
        int[] aof = this.m_aofBuffer;
        int ofThis = aof[i];
        for (i = 0; i < cBuffers; ++i) {
            int ofNext = i + 1 >= cBuffers ? cb : aof[i + 1];
            abuf[i].getUnsafeReadBuffer().copyBytes(0, ofNext - ofThis, ab, ofThis);
            ofThis = ofNext;
        }
        return ab;
    }

    @Override
    public Binary toBinary() {
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 1) {
            return this.m_bufLast.toBinary();
        }
        int cb = this.length();
        BinaryWriteBuffer bufbin = new BinaryWriteBuffer(cb, cb);
        WriteBuffer[] abuf = this.m_aBuffer;
        int[] aof = this.m_aofBuffer;
        for (int i = 0; i < cBuffers; ++i) {
            bufbin.write(aof[i], abuf[i].getUnsafeReadBuffer());
        }
        return bufbin.toBinary();
    }

    @Override
    public WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new MultiBufferOutput(of);
    }

    @Override
    public Object clone() {
        MultiBufferWriteBuffer that = new MultiBufferWriteBuffer(this.getBufferPool());
        if (this.length() > 0) {
            that.write(0, this.getUnsafeReadBuffer());
        }
        return that;
    }

    @Override
    public void dispose() {
        int cBuffers = this.m_cBuffers;
        if (cBuffers > 0) {
            WriteBuffer bufSingle = this.m_bufLast;
            WriteBuffer[] abuf = this.m_aBuffer;
            WriteBufferPool pool = this.getBufferPool();
            if (cBuffers == 1) {
                bufSingle.clear();
                pool.release(bufSingle);
            } else {
                for (int i = 0; i < cBuffers; ++i) {
                    WriteBuffer buf = abuf[i];
                    buf.clear();
                    pool.release(buf);
                }
            }
        }
        this.m_bufLast = null;
        this.m_ofLastBuffer = 0;
        this.m_cBuffers = 0;
        this.m_aBuffer = null;
        this.m_aofBuffer = null;
        this.m_ofLastLookup = 0;
        this.m_iBufLastAnswer = 0;
        this.m_outInternal = null;
        this.m_bufUnsafe = null;
        this.m_bufferpool = null;
    }

    public WriteBufferPool getBufferPool() {
        return this.m_bufferpool;
    }

    public int getBufferCount() {
        return this.m_cBuffers;
    }

    public int getBufferOffset(int iBuffer) {
        int cBuffers = this.m_cBuffers;
        if (iBuffer < cBuffers) {
            return cBuffers == 1 ? this.m_ofLastBuffer : this.m_aofBuffer[iBuffer];
        }
        throw new IndexOutOfBoundsException("iBuffer=" + iBuffer + ", BufferCount=" + cBuffers);
    }

    public WriteBuffer getBuffer(int iBuffer) {
        int cBuffers = this.m_cBuffers;
        if (iBuffer < cBuffers) {
            return cBuffers == 1 ? this.m_bufLast : this.m_aBuffer[iBuffer];
        }
        throw new IndexOutOfBoundsException("iBuffer=" + iBuffer + ", BufferCount=" + cBuffers);
    }

    protected int getBufferIndexByOffset(int of) {
        int iBuf;
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 1 || of == 0) {
            return 0;
        }
        if (of >= this.m_ofLastBuffer) {
            assert (of <= this.length());
            return cBuffers - 1;
        }
        int[] aof = this.m_aofBuffer;
        if (of >= this.m_ofLastLookup && ((iBuf = this.m_iBufLastAnswer) + 1 >= cBuffers || of < aof[iBuf + 1])) {
            return iBuf;
        }
        iBuf = 0;
        int iLow = 0;
        int iHigh = cBuffers - 2;
        while (iLow <= iHigh) {
            int iRoot = iLow + iHigh >> 1;
            int ofRoot = aof[iRoot];
            if (of == ofRoot) {
                iBuf = iRoot;
                break;
            }
            if (of < ofRoot) {
                iHigh = iRoot - 1;
                continue;
            }
            iLow = iRoot + 1;
            iBuf = iRoot;
        }
        this.m_ofLastLookup = of;
        this.m_iBufLastAnswer = iBuf;
        return iBuf;
    }

    protected WriteBuffer addBuffer() {
        WriteBuffer bufNew;
        WriteBufferPool bufferfactory = this.getBufferPool();
        int cBuffers = this.m_cBuffers;
        if (cBuffers == 0) {
            this.m_bufLast = bufNew = bufferfactory.allocate(0);
            this.m_cBuffers = 1;
        } else {
            int cElements;
            if (this.getCapacity() == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("buffer has reached its max capacity of 2GB");
            }
            WriteBuffer buf = this.m_bufLast;
            int of = this.m_ofLastBuffer;
            WriteBuffer[] abuf = this.m_aBuffer;
            int[] aof = this.m_aofBuffer;
            int n = cElements = abuf == null ? 0 : abuf.length;
            if (cBuffers >= cElements) {
                int cNew = Math.max(16, cElements << 1);
                WriteBuffer[] abufNew = new WriteBuffer[cNew];
                int[] aofNew = new int[cNew];
                if (abuf == null) {
                    abufNew[0] = this.m_bufLast;
                    aofNew[0] = this.m_ofLastBuffer;
                } else {
                    System.arraycopy(abuf, 0, abufNew, 0, cBuffers);
                    System.arraycopy(aof, 0, aofNew, 0, cBuffers);
                }
                abuf = abufNew;
                this.m_aBuffer = abufNew;
                aof = aofNew;
                this.m_aofBuffer = aofNew;
            }
            if ((of += buf.length()) + (bufNew = bufferfactory.allocate(of)).getCapacity() < of) {
                this.m_bufOverflow = bufNew;
                bufNew = bufNew.getWriteBuffer(0, Integer.MAX_VALUE - of);
            }
            abuf[cBuffers] = bufNew;
            aof[cBuffers] = of;
            this.m_bufLast = bufNew;
            this.m_ofLastBuffer = of;
            this.m_cBuffers = ++cBuffers;
        }
        this.m_bufUnsafe = null;
        return bufNew;
    }

    protected WriteBuffer getCurrentBuffer() {
        return this.m_bufLast;
    }

    protected int getCurrentBufferAbsoluteOffset() {
        return this.m_ofLastBuffer;
    }

    protected int getCurrentBufferRemaining() {
        WriteBuffer buf = this.m_bufLast;
        return buf.getCapacity() - buf.length();
    }

    protected MultiBufferOutput ensureBufferOutput(int of) {
        MultiBufferOutput outInternal = this.m_outInternal;
        if (outInternal == null) {
            this.m_outInternal = outInternal = (MultiBufferOutput)this.getBufferOutput(of);
        } else if (of != outInternal.m_ofWrite) {
            outInternal.setOffset(of);
        }
        return outInternal;
    }

    public static interface WriteBufferPool {
        public int getMaximumCapacity();

        public WriteBuffer allocate(int var1);

        public void release(WriteBuffer var1);
    }

    public final class MultiBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        private int m_iBuffer;
        private WriteBuffer.BufferOutput m_out;
        private int m_ofNextBuffer;

        public MultiBufferOutput(int of) {
            this.setOffset(of);
            this.sync();
        }

        @Override
        public ByteBuffer getByteBuffer(int cb) {
            if (this.m_ofNextBuffer - this.m_ofWrite < cb) {
                this.advance();
            }
            this.m_ofWrite += cb;
            return this.m_out.getByteBuffer(cb);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 1) {
                this.advance();
            }
            this.m_out.write(b);
            ++this.m_ofWrite;
        }

        @Override
        public void write(byte[] ab) throws IOException {
            this.write(ab, 0, ab.length);
        }

        @Override
        public void write(byte[] ab, int of, int cb) throws IOException {
            int ofWrite = this.m_ofWrite;
            int cbMax = this.m_ofNextBuffer - ofWrite;
            while (cb > cbMax) {
                this.m_out.write(ab, of, cbMax);
                of += cbMax;
                cb -= cbMax;
                this.advance();
                cbMax = this.m_ofNextBuffer - (ofWrite += cbMax);
            }
            this.m_out.write(ab, of, cb);
            this.m_ofWrite = ofWrite + cb;
        }

        @Override
        public void writeShort(int n) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 2) {
                super.writeShort(n);
            } else {
                this.m_out.writeShort(n);
                this.m_ofWrite += 2;
            }
        }

        @Override
        public void writeChar(int ch) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 2) {
                super.writeChar(ch);
            } else {
                this.m_out.writeChar(ch);
                this.m_ofWrite += 2;
            }
        }

        @Override
        public void writeInt(int n) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 4) {
                super.writeInt(n);
            } else {
                this.m_out.writeInt(n);
                this.m_ofWrite += 4;
            }
        }

        @Override
        public void writePackedInt(int n) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 5) {
                super.writePackedInt(n);
            } else {
                WriteBuffer.BufferOutput out = this.m_out;
                int of = out.getOffset();
                out.writePackedInt(n);
                this.m_ofWrite += out.getOffset() - of;
            }
        }

        @Override
        public void writeLong(long l) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 8) {
                super.writeLong(l);
            } else {
                this.m_out.writeLong(l);
                this.m_ofWrite += 8;
            }
        }

        @Override
        public void writePackedLong(long n) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 10) {
                super.writePackedLong(n);
            } else {
                WriteBuffer.BufferOutput out = this.m_out;
                int of = out.getOffset();
                out.writePackedLong(n);
                this.m_ofWrite += out.getOffset() - of;
            }
        }

        @Override
        public void writeFloat(float fl) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 4) {
                super.writeFloat(fl);
            } else {
                this.m_out.writeFloat(fl);
                this.m_ofWrite += 4;
            }
        }

        @Override
        public void writeDouble(double dfl) throws IOException {
            if (this.m_ofNextBuffer - this.m_ofWrite < 8) {
                super.writeDouble(dfl);
            } else {
                this.m_out.writeDouble(dfl);
                this.m_ofWrite += 8;
            }
        }

        @Override
        public void writeBuffer(ReadBuffer buf) throws IOException {
            this.writeBuffer(buf, 0, buf.length());
        }

        @Override
        public void writeBuffer(ReadBuffer buf, int of, int cb) throws IOException {
            while (true) {
                int cbMax;
                int cbWrite;
                if ((cbWrite = Math.min(cb, cbMax = this.m_ofNextBuffer - this.m_ofWrite)) > 0) {
                    this.m_out.writeBuffer(buf, of, cbWrite);
                    this.m_ofWrite += cbWrite;
                    of += cbWrite;
                    cb -= cbWrite;
                }
                if (cb <= 0) break;
                this.advance();
            }
        }

        @Override
        public void writeStream(InputStreaming stream) throws IOException {
            super.writeStream(stream);
            this.sync();
        }

        @Override
        public void writeStream(InputStreaming stream, int cb) throws IOException {
            while (true) {
                int cbMax;
                int cbWrite;
                if ((cbWrite = Math.min(cb, cbMax = this.m_ofNextBuffer - this.m_ofWrite)) > 0) {
                    this.m_out.writeStream(stream, cbWrite);
                    this.m_ofWrite += cbWrite;
                    cb -= cbWrite;
                }
                if (cb <= 0) break;
                this.advance();
            }
        }

        @Override
        public void setOffset(int of) {
            int ofPrev = this.m_ofWrite;
            if (of != ofPrev) {
                int cb;
                if (ofPrev < 0) {
                    throw new IllegalStateException("BufferOutput is closed");
                }
                MultiBufferWriteBuffer bufMulti = MultiBufferWriteBuffer.this;
                super.setOffset(Math.min(of, cb));
                if (of > bufMulti.length()) {
                    int cbWrite;
                    byte[] abFill = FILL;
                    int cbFill = abFill.length;
                    for (cb = bufMulti.length(); cb < of; cb += cbWrite) {
                        cbWrite = Math.min(of - cb, cbFill);
                        try {
                            this.write(abFill, 0, cbWrite);
                            continue;
                        }
                        catch (IOException e) {
                            throw Base.ensureRuntimeException(e);
                        }
                    }
                    if (!this.hasRemaining(1)) {
                        this.advance();
                    }
                } else if (of >= this.m_ofNextBuffer || of < ofPrev && of < bufMulti.getBufferOffset(this.m_iBuffer)) {
                    this.sync();
                } else {
                    this.m_out.setOffset(of - bufMulti.getBufferOffset(this.m_iBuffer));
                }
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.m_out = null;
            this.m_iBuffer = -1;
            this.m_ofWrite = -1;
            this.m_ofNextBuffer = -1;
        }

        protected WriteBuffer.BufferOutput getOut() {
            return this.m_out;
        }

        protected boolean hasRemaining(int cb) {
            return this.m_ofNextBuffer - this.m_ofWrite >= cb;
        }

        protected void adjust(int cb) {
            this.m_ofWrite += cb;
        }

        protected void advance() {
            MultiBufferWriteBuffer bufMulti = MultiBufferWriteBuffer.this;
            int iBuffer = this.m_iBuffer + 1;
            if (iBuffer <= 0) {
                throw new IllegalStateException("BufferOutput is closed");
            }
            if (iBuffer >= bufMulti.getBufferCount()) {
                bufMulti.addBuffer();
            }
            int of = bufMulti.getBufferOffset(iBuffer);
            WriteBuffer buf = bufMulti.getBuffer(iBuffer);
            this.m_iBuffer = iBuffer;
            this.m_out = buf.getBufferOutput();
            this.m_ofWrite = of;
            this.m_ofNextBuffer = of + buf.getCapacity();
        }

        protected void sync() {
            MultiBufferWriteBuffer bufMulti = MultiBufferWriteBuffer.this;
            int of = this.m_ofWrite;
            int iBuf = bufMulti.getBufferIndexByOffset(of);
            WriteBuffer buf = bufMulti.getBuffer(iBuf);
            int ofBuf = bufMulti.getBufferOffset(iBuf);
            of -= ofBuf;
            WriteBuffer.BufferOutput outPrev = this.m_out;
            if (outPrev != null && buf == outPrev.getBuffer()) {
                outPrev.setOffset(of);
            } else {
                this.m_iBuffer = iBuf;
                this.m_out = buf.getBufferOutput(of);
                this.m_ofNextBuffer = ofBuf + buf.getCapacity();
            }
        }
    }
}

