/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.io.OutputStreaming;
import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.BinaryDeltaCompressor;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.IOException;

public class DecoratedBinaryDeltaCompressor
extends ExternalizableHelper
implements DeltaCompressor {
    private static final byte DECO_NO_CHANGES = -3;
    private static final byte DECO_DELETE_ALL = -4;
    private static final byte DECO_INSERT = -5;
    private static final byte DECO_UPDATE = -6;
    private static final byte DECO_DELETE = -7;
    private static final byte DECO_TERM = -8;
    private static final byte VALUE_NO_CHANGES = -3;
    private static final byte VALUE_CHANGES = -4;
    private static final Binary NO_BINARY = AbstractReadBuffer.NO_BINARY;
    private static final BinaryDeltaCompressor s_compressorBinary = new BinaryDeltaCompressor();
    private DeltaCompressor m_compressorValue;

    public DecoratedBinaryDeltaCompressor(DeltaCompressor compressorValue) {
        Base.azzert(compressorValue != null, "DeltaCompressor is required");
        this.m_compressorValue = compressorValue;
    }

    @Override
    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        if (Base.equals(bufOld, bufNew)) {
            return null;
        }
        BinaryWriteBuffer bufDelta = null;
        if (DecoratedBinaryDeltaCompressor.isDecorated(bufNew)) {
            ReadBuffer[] abufDecoOld = DecoratedBinaryDeltaCompressor.getDecorations(bufOld);
            ReadBuffer[] abufDecoNew = DecoratedBinaryDeltaCompressor.getDecorations(bufNew);
            int cDecoOld = abufDecoOld.length;
            int cDecoNew = abufDecoNew.length;
            OutputStreaming outDelta = null;
            try {
                int c = Math.max(cDecoOld, cDecoNew);
                for (int i = 1; i < c; ++i) {
                    ReadBuffer bufDecoNew;
                    ReadBuffer bufDecoOld = i < cDecoOld ? abufDecoOld[i] : null;
                    ReadBuffer readBuffer = bufDecoNew = i < cDecoNew ? abufDecoNew[i] : null;
                    if (Base.equals(bufDecoOld, bufDecoNew)) continue;
                    if (bufDelta == null) {
                        bufDelta = new BinaryWriteBuffer(64);
                        outDelta = bufDelta.getAppendingBufferOutput();
                    }
                    if (bufDecoOld == null) {
                        outDelta.write(-5);
                        outDelta.writePackedInt(i);
                        outDelta.writePackedInt(bufDecoNew.length());
                        outDelta.writeBuffer(bufDecoNew);
                        continue;
                    }
                    if (bufDecoNew == null) {
                        outDelta.write(-7);
                        outDelta.writePackedInt(i);
                        continue;
                    }
                    outDelta.write(-6);
                    outDelta.writePackedInt(i);
                    ReadBuffer bufDecoDelta = s_compressorBinary.extractDelta(bufDecoOld, bufDecoNew);
                    Base.azzert(bufDecoDelta != null);
                    outDelta.writePackedInt(bufDecoDelta.length());
                    outDelta.writeBuffer(bufDecoDelta);
                }
                if (outDelta != null) {
                    outDelta.write(-8);
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            bufOld = abufDecoOld[0];
            bufNew = abufDecoNew[0];
        } else if (DecoratedBinaryDeltaCompressor.isDecorated(bufOld)) {
            bufDelta = new BinaryWriteBuffer(64);
            bufDelta.write(0, (byte)-4);
            bufOld = DecoratedBinaryDeltaCompressor.getUndecorated(bufOld);
        }
        ReadBuffer bufValueDelta = this.m_compressorValue.extractDelta(bufOld, bufNew);
        if (bufValueDelta == null) {
            if (bufDelta != null) {
                bufDelta.write(bufDelta.length(), (byte)-3);
            }
        } else if (bufDelta == null) {
            boolean fAmbiguous = true;
            if (bufValueDelta.length() >= 1) {
                switch (bufValueDelta.byteAt(0)) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        break;
                    }
                    default: {
                        fAmbiguous = false;
                    }
                }
            }
            if (fAmbiguous) {
                bufDelta = new BinaryWriteBuffer(1 + bufValueDelta.length());
                bufDelta.write(0, (byte)-3);
                bufDelta.write(1, bufValueDelta);
            }
        } else {
            boolean fAmbiguous = true;
            if (bufValueDelta.length() >= 1) {
                switch (bufValueDelta.byteAt(0)) {
                    case -4: 
                    case -3: {
                        break;
                    }
                    default: {
                        fAmbiguous = false;
                    }
                }
            }
            if (fAmbiguous) {
                bufDelta.write(bufDelta.length(), (byte)-4);
            }
            bufDelta.write(bufDelta.length(), bufValueDelta);
        }
        return bufDelta == null ? (bufValueDelta == null ? null : bufValueDelta) : bufDelta.toBinary();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
        ReadBuffer[] abufDeco;
        block22: {
            byte b;
            ReadBuffer.BufferInput inDelta;
            if (bufDelta == null) {
                return bufOld;
            }
            abufDeco = EMPTY_BINARY_ARRAY;
            switch (bufDelta.byteAt(0)) {
                case -3: {
                    abufDeco = DecoratedBinaryDeltaCompressor.getDecorations(bufOld);
                    bufDelta = bufDelta.getReadBuffer(1, bufDelta.length() - 1);
                    break block22;
                }
                case -4: {
                    bufDelta = DecoratedBinaryDeltaCompressor.parseValueDelta(bufDelta, 1);
                    break block22;
                }
                case -7: 
                case -6: 
                case -5: {
                    abufDeco = DecoratedBinaryDeltaCompressor.getDecorations(bufOld);
                    inDelta = bufDelta.getBufferInput();
                    try {}
                    catch (IOException e) {
                        throw Base.ensureRuntimeException(e);
                    }
                    break;
                }
                default: {
                    abufDeco = DecoratedBinaryDeltaCompressor.getDecorations(bufOld);
                    break block22;
                }
            }
            while ((b = inDelta.readByte()) != -8) {
                int iDeco = inDelta.readPackedInt();
                ReadBuffer bufDeco = null;
                switch (b) {
                    case -5: {
                        if (iDeco >= abufDeco.length) {
                            ReadBuffer[] abufNew = new ReadBuffer[iDeco + 1];
                            System.arraycopy(abufDeco, 0, abufNew, 0, abufDeco.length);
                            abufDeco = abufNew;
                        }
                        int cbBin = inDelta.readPackedInt();
                        int ofBin = inDelta.getOffset();
                        bufDeco = bufDelta.getReadBuffer(ofBin, cbBin);
                        inDelta.setOffset(ofBin + cbBin);
                        break;
                    }
                    case -6: {
                        ReadBuffer bufDecoOld;
                        int cbDelta = inDelta.readPackedInt();
                        int ofDelta = inDelta.getOffset();
                        try {
                            bufDecoOld = abufDeco[iDeco];
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw Base.ensureRuntimeException(e, "update decoration " + iDeco);
                        }
                        ReadBuffer bufDecoDelta = bufDelta.getReadBuffer(ofDelta, cbDelta);
                        inDelta.setOffset(ofDelta + cbDelta);
                        bufDeco = s_compressorBinary.applyDelta(bufDecoOld, bufDecoDelta);
                        break;
                    }
                    case -7: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("byte=" + Base.toHexEscape(b));
                    }
                }
                try {
                    abufDeco[iDeco] = bufDeco;
                }
                catch (IndexOutOfBoundsException e) {
                    throw Base.ensureRuntimeException(e, "decoration " + iDeco);
                }
            }
            bufDelta = DecoratedBinaryDeltaCompressor.parseValueDelta(bufDelta, inDelta.getOffset());
        }
        if (abufDeco.length > 0) {
            bufOld = abufDeco[0];
            abufDeco[0] = null;
        } else if ((bufOld = DecoratedBinaryDeltaCompressor.getUndecorated(bufOld)).length() == 0 && abufDeco.length > 1) {
            bufOld = AbstractReadBuffer.NO_BINARY;
        }
        ReadBuffer bufNew = bufDelta == null ? bufOld : this.m_compressorValue.applyDelta(bufOld, bufDelta);
        return DecoratedBinaryDeltaCompressor.decorate(bufNew, abufDeco);
    }

    private static ReadBuffer parseValueDelta(ReadBuffer bufDelta, int of) {
        int cb = bufDelta.length();
        if (cb <= of) {
            return NO_BINARY;
        }
        switch (bufDelta.byteAt(of)) {
            case -3: {
                return null;
            }
            case -4: {
                return bufDelta.getReadBuffer(of + 1, cb - of - 1);
            }
        }
        return bufDelta.getReadBuffer(of, cb - of);
    }

    public String toString() {
        return "DecoratedBinaryDeltaCompressor {" + String.valueOf(this.m_compressorValue) + "}";
    }
}

