/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.InputStreaming;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class ByteArrayWriteBuffer
extends AbstractWriteBuffer {
    protected byte[] m_ab;
    protected int m_cb;
    protected int m_cbMax;
    protected transient ByteArrayReadBuffer m_bufUnsafe;
    private boolean m_fPrivate;

    protected ByteArrayWriteBuffer() {
    }

    public ByteArrayWriteBuffer(byte[] ab) {
        this.m_ab = ab;
        this.m_cbMax = ab.length;
    }

    public ByteArrayWriteBuffer(int cbCap) {
        this(cbCap, Integer.MAX_VALUE);
    }

    public ByteArrayWriteBuffer(int cbCap, int cbMax) {
        if (cbCap < 0 || cbMax < 0 || cbCap > cbMax) {
            throw new IllegalArgumentException("cap=" + cbCap + "; max=" + cbMax);
        }
        this.m_ab = ByteArrayWriteBuffer.createBytes(cbCap);
        this.m_cbMax = cbMax;
    }

    public ByteArrayWriteBuffer(WriteBuffer buffer, int i, int cb) {
        this.m_cbMax = cb - i;
        this.m_ab = ByteArrayWriteBuffer.createBytes(this.m_cbMax);
        this.write(0, buffer.getUnsafeReadBuffer(), i, cb);
    }

    @Override
    public final void write(int ofDest, byte b) {
        this.checkBounds(ofDest, 1);
        this.m_ab[ofDest] = b;
        this.updateLength(ofDest + 1);
    }

    @Override
    public final void write(int ofDest, byte[] abSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        System.arraycopy(abSrc, ofSrc, this.m_ab, ofDest, cbSrc);
        if (cbSrc > 0) {
            this.updateLength(ofDest + cbSrc);
        }
    }

    @Override
    public final void write(int ofDest, ReadBuffer bufSrc, int ofSrc, int cbSrc) {
        this.checkBounds(ofDest, cbSrc);
        bufSrc.copyBytes(ofSrc, ofSrc + cbSrc, this.m_ab, ofDest);
        this.updateLength(ofDest + cbSrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(int ofDest, InputStreaming stream, int cbSrc) throws IOException {
        int cbRead;
        if (stream instanceof ReadBuffer.BufferInput) {
            this.copyBufferInputPortion(ofDest, (ReadBuffer.BufferInput)stream, cbSrc);
            return;
        }
        this.checkBounds(ofDest, cbSrc);
        try {
            int cbActual;
            for (cbRead = 0; cbRead < cbSrc; cbRead += cbActual) {
                cbActual = stream.read(this.m_ab, ofDest + cbRead, cbSrc - cbRead);
                if (cbActual >= 0) continue;
                throw new EOFException("instructed to copy " + cbSrc + " bytes, but only " + cbRead + " were available");
            }
        }
        finally {
            if (cbRead > 0) {
                this.updateLength(ofDest + cbRead);
            }
        }
    }

    @Override
    public final int length() {
        return this.m_cb;
    }

    public final void setLength(int cb) {
        assert (cb <= this.m_cbMax);
        this.updateLength(cb);
    }

    @Override
    public final void retain(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.m_cb) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + this.m_cb);
        }
        if (of > 0 && cb > 0) {
            byte[] ab = this.m_ab;
            System.arraycopy(ab, of, ab, 0, cb);
        }
        this.m_cb = cb;
        this.m_bufUnsafe = null;
    }

    @Override
    public final int getCapacity() {
        return this.m_ab.length;
    }

    @Override
    public final int getMaximumCapacity() {
        return this.m_cbMax;
    }

    @Override
    public final WriteBuffer.BufferOutput getBufferOutput(int of) {
        return new ByteArrayBufferOutput(of);
    }

    @Override
    public final ReadBuffer getUnsafeReadBuffer() {
        ByteArrayReadBuffer buf = this.m_bufUnsafe;
        if (buf == null) {
            this.m_bufUnsafe = buf = new ByteArrayReadBuffer(this.m_ab, 0, this.m_cb, false, this.isByteArrayPrivate(), false);
        } else {
            buf.updateLength(this.m_cb);
        }
        return buf;
    }

    @Override
    public final byte[] toByteArray() {
        int cb = this.m_cb;
        if (cb == 0) {
            return NO_BYTES;
        }
        byte[] ab = new byte[cb];
        System.arraycopy(this.m_ab, 0, ab, 0, cb);
        return ab;
    }

    @Override
    public Binary toBinary() {
        int cb = this.m_cb;
        if (cb == 0) {
            return NO_BINARY;
        }
        return new Binary(this.m_ab, 0, cb);
    }

    public boolean isByteArrayPrivate() {
        return this.m_fPrivate;
    }

    public final void makeByteArrayPrivate() {
        this.m_fPrivate = true;
        this.m_bufUnsafe = null;
    }

    public final byte[] getRawByteArray() {
        return this.isByteArrayPrivate() ? this.toByteArray() : this.m_ab;
    }

    @Override
    protected final int copyStream(int ofDest, InputStreaming stream, int cbMax) throws IOException {
        if (stream instanceof ReadBuffer.BufferInput) {
            return this.copyBufferInputRemainder(ofDest, (ReadBuffer.BufferInput)stream, cbMax);
        }
        int ofOrig = ofDest;
        int cbRemain = cbMax;
        do {
            byte[] ab = this.m_ab;
            int cbCap = Math.min(ab.length, ofDest + cbRemain);
            while (ofDest < cbCap) {
                int cbActual;
                try {
                    cbActual = stream.read(ab, ofDest, cbCap - ofDest);
                }
                catch (EOFException e) {
                    cbActual = -1;
                }
                if (cbActual < 0) {
                    this.updateLength(ofDest);
                    return ofDest - ofOrig;
                }
                ofDest += cbActual;
                cbRemain -= cbActual;
            }
            if (cbRemain <= 0) continue;
            this.updateLength(ofDest);
            this.grow(ofDest);
        } while (ofDest < this.m_ab.length && cbRemain != 0);
        if (stream.read() < 0) {
            this.updateLength(ofDest);
            return ofDest - ofOrig;
        }
        throw new IOException("Overflow: write buffer limited to " + cbMax + " bytes, but input stream is not exhausted");
    }

    protected static byte[] createBytes(int cb) {
        try {
            return new byte[cb];
        }
        catch (OutOfMemoryError e) {
            if (cb == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("buffer has reached its max capacity of 2GB");
            }
            throw new OutOfMemoryError("Failed to allocate a byte array of the requested size: " + cb);
        }
    }

    protected void checkBounds(int of, int cb) {
        int cbTotal = of + cb;
        if (of < 0 || cb < 0 || cbTotal > this.m_cbMax || cbTotal < 0) {
            this.boundsException(of, cb);
        }
        if (cbTotal > this.m_ab.length) {
            this.grow(cbTotal);
        }
    }

    private void boundsException(int of, int cb) throws IndexOutOfBoundsException {
        if ((long)of + (long)cb > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("buffer has reached its max capacity of 2GB");
        }
        throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", max=" + this.m_cbMax);
    }

    protected final void grow(int cbCap) {
        int cbOld;
        byte[] abOld = this.m_ab;
        int cbAdd = Math.max(1024, (cbOld = abOld.length) > 0x100000 ? cbOld >>> 1 : cbOld);
        int cbNew = (int)Math.min((long)this.m_cbMax, Math.max((long)cbCap + 1024L, (long)cbOld + (long)cbAdd));
        if (cbNew > cbOld) {
            byte[] abNew;
            ExternalizableHelper.validateBufferSize(cbNew);
            while (true) {
                try {
                    abNew = ByteArrayWriteBuffer.createBytes(cbNew);
                }
                catch (OutOfMemoryError | UnsupportedOperationException e) {
                    if (cbCap != Integer.MAX_VALUE) continue;
                    throw e;
                    if ((cbNew -= (cbNew - cbCap) / 2) - 1 > cbCap) continue;
                    throw e;
                }
                break;
            }
            int cbData = this.m_cb;
            if (cbData > 0) {
                System.arraycopy(abOld, 0, abNew, 0, cbData);
            }
            this.m_ab = abNew;
            this.m_bufUnsafe = null;
        }
    }

    protected final void updateLength(int cb) {
        if (cb > this.m_cb) {
            this.m_cb = cb;
        }
    }

    public final class ByteArrayBufferOutput
    extends AbstractWriteBuffer.AbstractBufferOutput {
        public ByteArrayBufferOutput() {
        }

        public ByteArrayBufferOutput(int of) {
            super(of);
        }

        @Override
        public void writeShort(int n) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 2);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            ab[of] = (byte)(n >>> 8);
            ab[of + 1] = (byte)n;
            this.moveOffset(2);
        }

        @Override
        public void writeInt(int n) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 4);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            ab[of] = (byte)(n >>> 24);
            ab[of + 1] = (byte)(n >>> 16);
            ab[of + 2] = (byte)(n >>> 8);
            ab[of + 3] = (byte)n;
            this.moveOffset(4);
        }

        @Override
        public void writeLong(long l) throws IOException {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, 8);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int n = (int)(l >>> 32);
            ab[of] = (byte)(n >>> 24);
            ab[of + 1] = (byte)(n >>> 16);
            ab[of + 2] = (byte)(n >>> 8);
            ab[of + 3] = (byte)n;
            n = (int)l;
            ab[of + 4] = (byte)(n >>> 24);
            ab[of + 5] = (byte)(n >>> 16);
            ab[of + 6] = (byte)(n >>> 8);
            ab[of + 7] = (byte)n;
            this.moveOffset(8);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int of = this.m_ofWrite;
            int cb = s.length();
            ByteArrayWriteBuffer.this.checkBounds(of, cb);
            s.getBytes(0, cb, ByteArrayWriteBuffer.this.m_ab, of);
            this.moveOffset(cb);
        }

        @Override
        public void writeChars(String s) throws IOException {
            int cch = s.length();
            int of = this.m_ofWrite;
            int cb = cch << 1;
            ByteArrayWriteBuffer.this.checkBounds(of, cb);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            for (int ofch = 0; ofch < cch; ++ofch) {
                char ch = s.charAt(ofch);
                ab[of] = (byte)(ch >>> 8);
                ab[of + 1] = (byte)ch;
                of += 2;
            }
            this.moveOffset(cb);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            if (s.isEmpty()) {
                this.writeShort(0);
            } else {
                int cbEstimate = s.length();
                int ofHeader = this.m_ofWrite;
                if (cbEstimate > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cbEstimate + ", max=65535");
                }
                int ofValue = ofHeader + 2;
                ByteArrayWriteBuffer.this.checkBounds(ofValue, cbEstimate * 3);
                int cb = this.formatModifiedUTF(s, ByteArrayWriteBuffer.this.m_ab, ofValue);
                if (cb > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cbEstimate + ", max=65535");
                }
                ByteArrayWriteBuffer.this.m_ab[ofHeader] = (byte)(cb >>> 8);
                ByteArrayWriteBuffer.this.m_ab[ofHeader + 1] = (byte)cb;
                this.moveOffset(2 + cb);
            }
        }

        public void writeUTF(CharBuffer bufCh) throws IOException {
            if (bufCh.isEmpty()) {
                this.writeShort(0);
            } else {
                int cbEstimate = bufCh.length();
                int ofHeader = this.m_ofWrite;
                if (cbEstimate > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cbEstimate + ", max=65535");
                }
                int ofValue = ofHeader + 2;
                ByteArrayWriteBuffer.this.checkBounds(ofValue, cbEstimate * 3);
                int cb = this.formatModifiedUTF(bufCh, ByteArrayWriteBuffer.this.m_ab, ofValue);
                if (cb > 65535) {
                    throw new UTFDataFormatException("UTF binary length=" + cbEstimate + ", max=65535");
                }
                ByteArrayWriteBuffer.this.m_ab[ofHeader] = (byte)(cb >>> 8);
                ByteArrayWriteBuffer.this.m_ab[ofHeader + 1] = (byte)cb;
                this.moveOffset(2 + cb);
            }
        }

        @Override
        public ByteBuffer getByteBuffer(int cb) {
            int of = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(of, cb);
            this.moveOffset(cb);
            return ByteBuffer.wrap(ByteArrayWriteBuffer.this.m_ab, of, cb);
        }

        @Override
        public void writeSafeUTF(String s) throws IOException {
            if (s == null) {
                this.writePackedInt(-1);
            } else if (s.isEmpty()) {
                this.writePackedInt(0);
            } else if (ByteArrayWriteBuffer.this.isLatin1(s)) {
                byte[] abString = ByteArrayWriteBuffer.this.value(s);
                if (ByteArrayWriteBuffer.this.isAscii(abString)) {
                    this.writePackedInt(abString.length);
                    this.write(abString);
                } else {
                    int cb = abString.length + ByteArrayBufferOutput.countNegatives(abString);
                    this.writePackedInt(cb);
                    int of = this.m_ofWrite;
                    ByteArrayWriteBuffer.this.checkBounds(of, cb);
                    byte[] ab = ByteArrayWriteBuffer.this.m_ab;
                    for (byte b : abString) {
                        if (b < 0) {
                            ab[of++] = (byte)(0xC0 | (b & 0xFF) >> 6);
                            ab[of++] = (byte)(0x80 | b & 0x3F);
                            continue;
                        }
                        ab[of++] = b;
                    }
                    this.moveOffset(cb);
                }
            } else {
                int cbEstimate = s.length();
                int ofHeader = this.m_ofWrite;
                this.writePackedInt(cbEstimate);
                int ofValue = this.m_ofWrite;
                ByteArrayWriteBuffer.this.checkBounds(ofValue, cbEstimate * 3);
                int cb = this.formatUTF(s, ByteArrayWriteBuffer.this.m_ab, ofValue);
                if (cb != cbEstimate) {
                    int cbActual;
                    int cbHeader = ofValue - ofHeader;
                    int n = cbActual = cb < 64 ? 1 : (39 - Integer.numberOfLeadingZeros(cb)) / 7;
                    if (cbHeader != cbActual) {
                        ByteArrayWriteBuffer.this.checkBounds(ofHeader, cbActual + cb);
                        int ofValueNew = ofValue + cbActual - cbHeader;
                        System.arraycopy(ByteArrayWriteBuffer.this.m_ab, ofValue, ByteArrayWriteBuffer.this.m_ab, ofValueNew, cb);
                        ofValue = ofValueNew;
                    }
                    this.m_ofWrite = ofHeader;
                    this.writePackedInt(cb);
                    this.m_ofWrite = ofValue;
                }
                this.moveOffset(cb);
            }
        }

        public void writeSafeUTF(CharBuffer bufCh) throws IOException {
            if (bufCh.isEmpty()) {
                this.writePackedInt(0);
            } else {
                int cbEstimate = bufCh.length();
                int ofHeader = this.m_ofWrite;
                this.writePackedInt(cbEstimate);
                int ofValue = this.m_ofWrite;
                ByteArrayWriteBuffer.this.checkBounds(ofValue, cbEstimate << 2);
                int cb = this.formatUTF(bufCh, ByteArrayWriteBuffer.this.m_ab, ofValue);
                if (cb != cbEstimate) {
                    int cbActual;
                    int cbHeader = ofValue - ofHeader;
                    int n = cbActual = cb < 64 ? 1 : (39 - Integer.numberOfLeadingZeros(cb)) / 7;
                    if (cbHeader != cbActual) {
                        ByteArrayWriteBuffer.this.checkBounds(ofHeader, cbActual + cb);
                        int ofValueNew = ofValue + cbActual - cbHeader;
                        System.arraycopy(ByteArrayWriteBuffer.this.m_ab, ofValue, ByteArrayWriteBuffer.this.m_ab, ofValueNew, cb);
                        ofValue = ofValueNew;
                    }
                    this.m_ofWrite = ofHeader;
                    this.writePackedInt(cb);
                    this.m_ofWrite = ofValue;
                }
                this.moveOffset(cb);
            }
        }

        @Override
        public void writePackedInt(int n) throws IOException {
            int b = 0;
            if (n < 0) {
                b = 64;
                n ^= 0xFFFFFFFF;
            }
            int ofb = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(ofb, n < 64 ? 1 : (39 - Integer.numberOfLeadingZeros(n)) / 7);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int ofOrig = ofb;
            b |= (byte)(n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                ab[ofb++] = (byte)(b |= 0x80);
                b = n & 0x7F;
                n >>>= 7;
            }
            ab[ofb++] = (byte)b;
            this.moveOffset(ofb - ofOrig);
        }

        @Override
        public void writePackedLong(long l) throws IOException {
            int b = 0;
            if (l < 0L) {
                b = 64;
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            int ofb = this.m_ofWrite;
            ByteArrayWriteBuffer.this.checkBounds(ofb, l < 64L ? 1 : (71 - Long.numberOfLeadingZeros(l)) / 7);
            byte[] ab = ByteArrayWriteBuffer.this.m_ab;
            int ofOrig = ofb;
            b |= (byte)((int)l & 0x3F);
            l >>>= 6;
            while (l != 0L) {
                ab[ofb++] = (byte)(b |= 0x80);
                b = (int)l & 0x7F;
                l >>>= 7;
            }
            ab[ofb++] = (byte)b;
            this.moveOffset(ofb - ofOrig);
        }

        private void moveOffset(int cb) {
            int of;
            this.m_ofWrite = of = this.m_ofWrite + cb;
            ByteArrayWriteBuffer.this.updateLength(of);
        }
    }

    public static class Allocator
    implements MultiBufferWriteBuffer.WriteBufferPool {
        protected int m_cb;

        public Allocator(int cb) {
            this.m_cb = cb;
        }

        @Override
        public int getMaximumCapacity() {
            return this.m_cb;
        }

        @Override
        public WriteBuffer allocate(int cbPreviousTotal) {
            return new ByteArrayWriteBuffer(ByteArrayWriteBuffer.createBytes(this.m_cb));
        }

        @Override
        public void release(WriteBuffer buffer) {
        }
    }
}

