/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Formatting;
import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ReadBuffer;

public class ByteArrayReadBuffer
extends AbstractByteArrayReadBuffer {
    private transient boolean m_fPrivate;
    private transient boolean m_fShallowClone;

    protected ByteArrayReadBuffer() {
    }

    public ByteArrayReadBuffer(byte[] ab) {
        this(ab, 0, ab.length);
    }

    public ByteArrayReadBuffer(byte[] ab, int of, int cb) {
        this(ab, of, cb, false, false, false);
    }

    public ByteArrayReadBuffer(byte[] ab, int of, int cb, boolean fCopy, boolean fPrivate, boolean fShallowClone) {
        super(fCopy ? (byte[])ab.clone() : ab, of, cb);
        this.m_fPrivate = fPrivate;
        this.m_fShallowClone = fShallowClone;
    }

    @Override
    public final void resetRange(int of, int cb) {
        super.resetRange(of, cb);
    }

    public final byte[] getRawByteArray() {
        return this.isByteArrayPrivate() ? this.toByteArray() : this.m_ab;
    }

    public final int getRawOffset() {
        return this.isByteArrayPrivate() ? 0 : this.m_of;
    }

    @Override
    protected final ReadBuffer instantiateReadBuffer(int of, int cb) {
        return new ByteArrayReadBuffer(this.m_ab, this.m_of + of, cb, false, this.isByteArrayPrivate(), this.isShallowCloneable());
    }

    @Override
    public Object clone() {
        byte[] abNew;
        if (this.isShallowCloneable()) {
            return this;
        }
        byte[] ab = this.m_ab;
        int of = this.m_of;
        int cb = this.m_cb;
        if (of == 0 && cb == ab.length) {
            abNew = (byte[])ab.clone();
        } else {
            abNew = new byte[cb];
            System.arraycopy(ab, of, abNew, 0, cb);
        }
        boolean fPrivate = this.isByteArrayPrivate();
        return new ByteArrayReadBuffer(abNew, 0, cb, false, fPrivate, fPrivate);
    }

    public String toString() {
        return "ByteArrayReadBuffer(length=" + this.m_cb + ", value" + (String)(this.m_cb > 2048 ? " (truncated by " + (this.m_cb - 2048) + " bytes)=" : "=") + Formatting.toHexEscape(this.m_ab, this.m_of, Math.min(2048, this.m_cb)) + ")";
    }

    @Override
    protected final boolean isByteArrayPrivate() {
        return this.m_fPrivate;
    }

    protected final boolean isShallowCloneable() {
        return this.m_fShallowClone;
    }

    void updateLength(int cb) {
        this.m_cb = cb;
    }
}

