/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import java.io.IOException;

public class BinaryDeltaCompressor
implements DeltaCompressor {
    protected static final byte FMT_EMPTY = -10;
    protected static final byte FMT_REPLACE = -11;
    protected static final byte FMT_BINDIFF = -12;
    protected static final byte OP_EXTRACT = 1;
    protected static final byte OP_APPEND = 2;
    protected static final byte OP_TERM = 3;
    protected static final int MIN_BLOCK = 12;
    protected static final Binary NO_BINARY = AbstractReadBuffer.NO_BINARY;
    protected static final Binary DELTA_TRUNCATE = new Binary(new byte[]{-10});

    @Override
    public ReadBuffer extractDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        int cbNew;
        int cbOld = bufOld == null ? 0 : bufOld.length();
        if (cbOld == (cbNew = bufNew.length()) && bufNew.equals(bufOld)) {
            return null;
        }
        if (cbNew == 0) {
            return DELTA_TRUNCATE;
        }
        if (cbOld == 0 || cbNew < 64) {
            return this.encodeReplace(bufNew);
        }
        return this.createDelta(bufOld, bufNew);
    }

    @Override
    public ReadBuffer applyDelta(ReadBuffer bufOld, ReadBuffer bufDelta) {
        if (bufDelta == null) {
            return bufOld;
        }
        switch (bufDelta.byteAt(0)) {
            case -10: {
                return NO_BINARY;
            }
            case -12: {
                try {
                    byte nOp;
                    ReadBuffer.BufferInput inDelta = bufDelta.getBufferInput();
                    inDelta.skipBytes(1);
                    BinaryWriteBuffer bufNew = new BinaryWriteBuffer(Math.max(bufOld.length(), bufDelta.length()));
                    WriteBuffer.BufferOutput outNew = bufNew.getBufferOutput();
                    block12: while (true) {
                        nOp = inDelta.readByte();
                        switch (nOp) {
                            case 1: {
                                outNew.writeBuffer(bufOld, inDelta.readPackedInt(), inDelta.readPackedInt());
                                continue block12;
                            }
                            case 2: {
                                outNew.writeStream(inDelta, inDelta.readPackedInt());
                                continue block12;
                            }
                            case 3: {
                                return bufNew.toBinary();
                            }
                        }
                        break;
                    }
                    throw new IllegalStateException("Unknown delta operation (" + Base.toHexEscape(nOp) + ") encountered at offset " + (inDelta.getOffset() - 1));
                }
                catch (IOException e) {
                    throw Base.ensureRuntimeException(e);
                }
            }
            case -11: {
                return bufDelta.getReadBuffer(1, bufDelta.length() - 1);
            }
        }
        return bufDelta;
    }

    protected ReadBuffer createDelta(ReadBuffer bufOld, ReadBuffer bufNew) {
        int ofNewStart;
        byte[] abNew;
        int ofOldStart;
        byte[] abOld;
        if (bufOld instanceof AbstractByteArrayReadBuffer) {
            AbstractByteArrayReadBuffer abarbOld = (AbstractByteArrayReadBuffer)bufOld;
            abOld = abarbOld.m_ab;
            ofOldStart = abarbOld.m_of;
        } else {
            abOld = bufOld.toByteArray();
            ofOldStart = 0;
        }
        if (bufNew instanceof AbstractByteArrayReadBuffer) {
            AbstractByteArrayReadBuffer abarbNew = (AbstractByteArrayReadBuffer)bufNew;
            abNew = abarbNew.m_ab;
            ofNewStart = abarbNew.m_of;
        } else {
            abNew = bufNew.toByteArray();
            ofNewStart = 0;
        }
        int ofOld = ofOldStart;
        int ofNew = ofNewStart;
        int cbOld = bufOld.length();
        int cbNew = bufNew.length();
        int cbMax = Math.min(cbOld, cbNew);
        int ofOldStop = ofOldStart + cbMax;
        while (ofOld < ofOldStop && abOld[ofOld] == abNew[ofNew]) {
            ++ofOld;
            ++ofNew;
        }
        int cbHead = ofOld - ofOldStart;
        int cbTail = 0;
        if (cbHead == cbMax) {
            if (cbOld == cbNew) {
                return null;
            }
        } else {
            ofOld = ofOldStart + cbOld - 1;
            ofNew = ofNewStart + cbNew - 1;
            int cbMaxTail = cbMax - cbHead;
            while (--cbMaxTail >= 0 && abOld[ofOld] == abNew[ofNew]) {
                --ofOld;
                --ofNew;
            }
            cbTail = ofOldStart + cbOld - 1 - ofOld;
        }
        int cbDone = 0;
        WriteBuffer.BufferOutput outDelta = null;
        int cbDiffThreshold = Math.max(12, Math.min(cbOld, cbNew) / 4);
        if (cbHead > cbDiffThreshold) {
            outDelta = BinaryDeltaCompressor.writeExtract(outDelta, cbMax, 0, cbHead);
            cbDone = cbHead;
        }
        if (cbOld == cbNew) {
            ofOld = ofOldStart + cbHead + 1;
            ofNew = ofNewStart + cbHead + 1;
            ofOldStop = ofOldStop - cbTail - cbDiffThreshold;
            while (ofOld < ofOldStop) {
                int cbRun = 0;
                while (abOld[ofOld] == abNew[ofNew]) {
                    ++cbRun;
                    ++ofOld;
                    ++ofNew;
                }
                if (cbRun > cbDiffThreshold) {
                    int cbDif = ofNew - ofNewStart - cbDone - cbRun;
                    outDelta = BinaryDeltaCompressor.writeAppend(outDelta, cbMax, abNew, ofNewStart + cbDone, cbDif);
                    outDelta = BinaryDeltaCompressor.writeExtract(outDelta, cbMax, cbDone + cbDif, cbRun);
                    cbDone += cbDif + cbRun;
                }
                while (ofOld < ofOldStop && abOld[ofOld] != abNew[ofNew]) {
                    ++ofOld;
                    ++ofNew;
                }
            }
        }
        if (cbTail > cbDiffThreshold) {
            int cbAppend = cbNew - cbDone - cbTail;
            if (cbAppend > 0) {
                outDelta = BinaryDeltaCompressor.writeAppend(outDelta, cbMax, abNew, ofNewStart + cbDone, cbAppend);
            }
            outDelta = BinaryDeltaCompressor.writeExtract(outDelta, cbMax, cbOld - cbTail, cbTail);
        } else if (outDelta != null && cbDone < cbNew) {
            outDelta = BinaryDeltaCompressor.writeAppend(outDelta, cbMax, abNew, ofNewStart + cbDone, cbNew - cbDone);
        }
        return outDelta == null ? this.encodeReplace(bufNew) : BinaryDeltaCompressor.finalizeDelta(outDelta);
    }

    private ReadBuffer encodeReplace(ReadBuffer buf) {
        switch (buf.byteAt(0)) {
            case -12: 
            case -11: 
            case -10: {
                int cb = buf.length();
                BinaryWriteBuffer bufDelta = new BinaryWriteBuffer(1 + cb);
                bufDelta.write(0, (byte)-11);
                bufDelta.write(1, buf, 0, cb);
                return bufDelta.toBinary();
            }
        }
        return buf.toBinary();
    }

    private static WriteBuffer.BufferOutput ensureDiff(WriteBuffer.BufferOutput out, int cbMax) throws IOException {
        if (out == null) {
            out = new BinaryWriteBuffer(cbMax).getBufferOutput();
            out.write(-12);
        }
        return out;
    }

    private static WriteBuffer.BufferOutput writeAppend(WriteBuffer.BufferOutput out, int cbMax, byte[] ab, int of, int cb) {
        try {
            out = BinaryDeltaCompressor.ensureDiff(out, cbMax);
            out.write(2);
            out.writePackedInt(cb);
            out.write(ab, of, cb);
            return out;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private static WriteBuffer.BufferOutput writeExtract(WriteBuffer.BufferOutput out, int cbMax, int of, int cb) {
        try {
            out = BinaryDeltaCompressor.ensureDiff(out, cbMax);
            out.write(1);
            out.writePackedInt(of);
            out.writePackedInt(cb);
            return out;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private static ReadBuffer finalizeDelta(WriteBuffer.BufferOutput out) {
        try {
            out.write(3);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return out.getBuffer().toBinary();
    }
}

