/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AsyncBinaryStore;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.util.SafeHashMap;
import java.util.Map;

public class AsyncBinaryStoreManager
implements BinaryStoreManager {
    private BinaryStoreManager m_manager;
    private Map m_mapStores = new SafeHashMap();
    private int m_cbMaxPend;

    public AsyncBinaryStoreManager(BinaryStoreManager manager) {
        this.m_manager = manager;
    }

    public AsyncBinaryStoreManager(BinaryStoreManager manager, int cbMax) {
        this(manager);
        this.m_cbMaxPend = cbMax;
    }

    @Override
    public BinaryStore createBinaryStore() {
        BinaryStore storeWrapped = this.getBinaryStoreManager().createBinaryStore();
        AsyncBinaryStore storeAsync = this.instantiateAsyncBinaryStore(storeWrapped);
        this.getBinaryStoreMap().put(storeAsync, storeWrapped);
        return storeAsync;
    }

    @Override
    public synchronized void destroyBinaryStore(BinaryStore store) {
        AsyncBinaryStore storeAsync = (AsyncBinaryStore)store;
        BinaryStore storeWrapped = (BinaryStore)this.getBinaryStoreMap().remove(storeAsync);
        if (storeWrapped != null) {
            storeAsync.internalClose(s -> this.getBinaryStoreManager().destroyBinaryStore((BinaryStore)s));
        }
    }

    protected BinaryStoreManager getBinaryStoreManager() {
        return this.m_manager;
    }

    protected Map getBinaryStoreMap() {
        return this.m_mapStores;
    }

    protected int getQueuedLimit() {
        return this.m_cbMaxPend;
    }

    protected AsyncBinaryStore instantiateAsyncBinaryStore(BinaryStore store) {
        int cbMax = this.getQueuedLimit();
        return cbMax > 0 ? new AsyncBinaryStore(store, cbMax) : new AsyncBinaryStore(store);
    }
}

