/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashEncoded;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BinaryOperator;

public abstract class AbstractReadBuffer
implements ReadBuffer,
HashEncoded {
    public static final byte[] NO_BYTES = new byte[0];
    public static final Binary NO_BINARY = new Binary(NO_BYTES);
    static final int MIN_BUF = 64;

    @Override
    public ReadBuffer.BufferInput getBufferInput() {
        return this.instantiateBufferInput();
    }

    @Override
    public ReadBuffer getReadBuffer(int of, int cb) {
        if (of == 0 && cb == this.length()) {
            return this;
        }
        this.checkBounds(of, cb);
        return this.instantiateReadBuffer(of, cb);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    @Override
    public byte[] toByteArray(int of, int cb) {
        byte[] ab;
        this.checkBounds(of, cb);
        if (cb == 0) {
            ab = NO_BYTES;
        } else {
            ab = new byte[cb];
            this.copyBytes(of, of + cb, ab, 0);
        }
        return ab;
    }

    @Override
    public Binary toBinary() {
        return this.toBinary(0, this.length());
    }

    @Override
    public Binary toBinary(int of, int cb) {
        this.checkBounds(of, cb);
        BinaryWriteBuffer buf = new BinaryWriteBuffer(cb, cb);
        buf.write(0, this, of, cb);
        return buf.toBinary();
    }

    @Override
    public ByteSequence subSequence(int ofStart, int ofEnd) {
        return this.getReadBuffer(ofStart, ofEnd - ofStart);
    }

    @Override
    public int getEncodedHash() {
        return ExternalizableHelper.isIntDecorated(this) ? AbstractReadBuffer.readPackedInt(this, 1) : Integer.MIN_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ReadBuffer) {
            int cbChunk;
            ReadBuffer that = (ReadBuffer)o;
            if (this == that) {
                return true;
            }
            int cb = this.length();
            if (cb != that.length()) {
                return false;
            }
            if (cb == 0) {
                return true;
            }
            int cbTempBuf = Math.min(cb, 32);
            byte[] abThis = new byte[cbTempBuf];
            byte[] abThat = new byte[cbTempBuf];
            int of = 0;
            do {
                cbChunk = Math.min(cb, cbTempBuf);
                int ofEnd = of + cbChunk;
                this.copyBytes(of, ofEnd, abThis, 0);
                that.copyBytes(of, ofEnd, abThat, 0);
                if (!Binary.equals(abThis, 0, abThat, 0, cbChunk)) {
                    return false;
                }
                of += cbChunk;
            } while ((cb -= cbChunk) > 0);
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    protected abstract ReadBuffer instantiateReadBuffer(int var1, int var2);

    protected abstract ReadBuffer.BufferInput instantiateBufferInput();

    protected void checkBounds(int of, int cb) {
        if (of < 0 || cb < 0 || of + cb > this.length()) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + this.length());
        }
    }

    public static int readUnsignedByte(ByteSequence bin, int of) {
        return bin.byteAt(of) & 0xFF;
    }

    public static int readPackedInt(ByteSequence bin, int of) {
        boolean fNeg;
        int b = AbstractReadBuffer.readUnsignedByte(bin, of++);
        int n = b & 0x3F;
        int cBits = 6;
        boolean bl = fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = AbstractReadBuffer.readUnsignedByte(bin, of++);
            n |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    public static int sizeofPackedInt(int n) {
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        int cb = n == 0 ? 1 : 0;
        int iShift = 6;
        while (n > 0) {
            n >>= iShift;
            ++cb;
            iShift = 7;
        }
        return cb;
    }

    public class AbstractBufferInput
    extends InputStream
    implements ReadBuffer.BufferInput {
        private int m_of;
        private int m_ofMark = -1;
        private static ThreadLocal<char[]> s_achBuf = new ThreadLocal();
        private volatile Object m_oInputFilter;
        private volatile boolean m_fInputFilterSet = false;

        public AbstractBufferInput() {
            BinaryOperator factorySerialFilter = ExternalizableHelper.getConfigSerialFilterFactory();
            this.m_oInputFilter = factorySerialFilter == null ? ExternalizableHelper.getConfigSerialFilter() : factorySerialFilter.apply(null, ExternalizableHelper.getConfigSerialFilter());
        }

        @Override
        public int read() throws IOException {
            try {
                int of = this.getOffset();
                int b = AbstractReadBuffer.this.byteAt(of) & 0xFF;
                this.setOffsetInternal(of + 1);
                return b;
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
        }

        @Override
        public int read(byte[] ab) throws IOException {
            return this.read(ab, 0, ab.length);
        }

        @Override
        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbDest = ab.length;
            if (of < 0 || cb < 0 || of + cb > cbDest) {
                throw new IndexOutOfBoundsException("ab.length=" + cbDest + ", of=" + of + ", cb=" + cb);
            }
            if (cb == 0) {
                return 0;
            }
            int ofIn = this.getOffset();
            int cbRead = Math.min(cb, AbstractReadBuffer.this.length() - ofIn);
            if (cbRead == 0) {
                return -1;
            }
            int ofEnd = ofIn + cbRead;
            AbstractReadBuffer.this.copyBytes(ofIn, ofEnd, ab, of);
            this.setOffsetInternal(ofEnd);
            return cbRead;
        }

        @Override
        public long skip(long cb) throws IOException {
            int cbReq = cb > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)cb;
            return this.skipBytes(cbReq);
        }

        @Override
        public int available() throws IOException {
            return AbstractReadBuffer.this.length() - this.getOffset();
        }

        @Override
        public void close() throws IOException {
            s_achBuf.remove();
        }

        @Override
        public void mark(int cbReadLimit) {
            this.setMarkInternal(this.getOffset());
        }

        @Override
        public void reset() throws IOException {
            int of = this.getMarkInternal();
            if (of < 0) {
                throw new IOException("not marked");
            }
            this.setOffsetInternal(of);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void readFully(byte[] ab) throws IOException {
            this.readFully(ab, 0, ab.length);
        }

        @Override
        public void readFully(byte[] ab, int of, int cb) throws IOException {
            int cbRead = this.read(ab, of, cb);
            if (cbRead < cb) {
                throw new EOFException("requested=" + cb + ", read=" + cbRead);
            }
        }

        @Override
        public int skipBytes(int cb) throws IOException {
            int of = this.getOffset();
            int cbRem = AbstractReadBuffer.this.length() - of;
            int cbSkip = Math.min(cb, cbRem);
            this.setOffsetInternal(of + cbSkip);
            return cbSkip;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public byte readByte() throws IOException {
            try {
                int of = this.getOffset();
                byte b = AbstractReadBuffer.this.byteAt(of);
                this.setOffsetInternal(of + 1);
                return b;
            }
            catch (IndexOutOfBoundsException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.readByte() & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            return (short)this.readUnsignedShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        @Override
        public char readChar() throws IOException {
            return (char)this.readUnsignedShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        @Override
        public long readLong() throws IOException {
            return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public String readLine() throws IOException {
            return new DataInputStream(this).readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTF(this.readUnsignedShort());
        }

        @Override
        public ReadBuffer getBuffer() {
            return AbstractReadBuffer.this;
        }

        @Override
        public String readSafeUTF() throws IOException {
            return this.readUTF(this.readPackedInt());
        }

        @Override
        public int readPackedInt() throws IOException {
            boolean fNeg;
            int b = this.readUnsignedByte();
            int n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = this.readUnsignedByte();
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
            return n;
        }

        @Override
        public long readPackedLong() throws IOException {
            boolean fNeg;
            int b = this.readUnsignedByte();
            long l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                b = this.readUnsignedByte();
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return l;
        }

        @Override
        public ReadBuffer readBuffer(int cb) throws IOException {
            if (cb < 0) {
                throw new IllegalArgumentException("cb=" + cb);
            }
            if (cb == 0) {
                return NO_BINARY;
            }
            int of = this.getOffset();
            if (this.skipBytes(cb) < cb) {
                throw new EOFException();
            }
            return AbstractReadBuffer.this.getReadBuffer(of, cb);
        }

        @Override
        public int getOffset() {
            return this.m_of;
        }

        @Override
        public void setOffset(int of) {
            if (of < 0 || of > AbstractReadBuffer.this.length()) {
                throw new IndexOutOfBoundsException("of=" + of + ", getBuffer().length()=" + AbstractReadBuffer.this.length());
            }
            this.setOffsetInternal(of);
        }

        @Override
        public final Object getObjectInputFilter() {
            return this.m_oInputFilter;
        }

        @Override
        public final synchronized void setObjectInputFilter(Object oInputFilter) {
            Object oInputFilterNext;
            Object oInputFilterCurrent = this.m_oInputFilter;
            BinaryOperator factorySerialFilter = ExternalizableHelper.getConfigSerialFilterFactory();
            if (this.m_fInputFilterSet) {
                throw new IllegalStateException("filter can not be set more than once");
            }
            Object object = oInputFilterNext = factorySerialFilter == null ? oInputFilter : factorySerialFilter.apply(oInputFilterCurrent, oInputFilter);
            if (oInputFilterCurrent != null && oInputFilterNext == null) {
                throw new IllegalStateException("filter can not be replaced by null filter");
            }
            this.m_oInputFilter = oInputFilterNext;
            this.m_fInputFilterSet = true;
        }

        protected void setOffsetInternal(int of) {
            this.m_of = of;
        }

        protected void adjustOffsetInternal(int cb) {
            this.m_of += cb;
        }

        protected int getMarkInternal() {
            return this.m_ofMark;
        }

        protected void setMarkInternal(int of) {
            this.m_ofMark = of;
        }

        protected char[] getCharBuf(int cchMax) {
            char[] ach = s_achBuf.get();
            if (ach == null || ach.length < cchMax) {
                ach = new char[Math.max(64, cchMax)];
                s_achBuf.set(ach);
            }
            return ach;
        }

        protected String readUTF(int cb) throws IOException {
            int cbBuf;
            if (cb < 0) {
                return null;
            }
            if (cb == 0) {
                return "";
            }
            int of = this.getOffset();
            if (of + cb > (cbBuf = AbstractReadBuffer.this.length())) {
                this.setOffsetInternal(cbBuf);
                throw new EOFException();
            }
            this.setOffsetInternal(of + cb);
            return this.convertUTF(of, cb);
        }

        protected String convertUTF(int of, int cb) throws IOException {
            return ExternalizableHelper.convertUTF(AbstractReadBuffer.this.toByteArray(of, cb), 0, cb, this.getCharBuf(cb));
        }
    }
}

