/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public class SummingLongCollector<T>
implements RemoteCollector<T, long[], Long>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="mapper")
    protected ToLongFunction<? super T> m_mapper;

    public SummingLongCollector() {
    }

    public SummingLongCollector(Remote.ToLongFunction<? super T> mapper) {
        this.m_mapper = mapper;
    }

    @Override
    public Supplier<long[]> supplier() {
        return () -> new long[1];
    }

    @Override
    public BiConsumer<long[], T> accumulator() {
        ToLongFunction mapper = this.m_mapper;
        return (a, t) -> {
            a[0] = a[0] + mapper.applyAsLong(t);
        };
    }

    @Override
    public BinaryOperator<long[]> combiner() {
        return (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        };
    }

    @Override
    public Function<long[], Long> finisher() {
        return a -> a[0];
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (ToLongFunction)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (ToLongFunction)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
    }
}

