/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

public class SummingIntCollector<T>
implements RemoteCollector<T, int[], Integer>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="mapper")
    protected ToIntFunction<? super T> m_mapper;

    public SummingIntCollector() {
    }

    public SummingIntCollector(Remote.ToIntFunction<? super T> mapper) {
        this.m_mapper = mapper;
    }

    @Override
    public Supplier<int[]> supplier() {
        return () -> new int[1];
    }

    @Override
    public BiConsumer<int[], T> accumulator() {
        ToIntFunction mapper = this.m_mapper;
        return (a, t) -> {
            a[0] = a[0] + mapper.applyAsInt(t);
        };
    }

    @Override
    public BinaryOperator<int[]> combiner() {
        return (a, b) -> {
            a[0] = a[0] + b[0];
            return a;
        };
    }

    @Override
    public Function<int[], Integer> finisher() {
        return a -> a[0];
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (ToIntFunction)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (ToIntFunction)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
    }
}

