/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.IntSummaryStatistics;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

public class SummarizingIntCollector<T>
implements RemoteCollector<T, IntSummaryStatistics, IntSummaryStatistics>,
ExternalizableLite,
PortableObject {
    protected static final Set<Collector.Characteristics> S_CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    @JsonbProperty(value="mapper")
    protected ToIntFunction<? super T> m_mapper;

    public SummarizingIntCollector() {
    }

    public SummarizingIntCollector(Remote.ToIntFunction<? super T> mapper) {
        this.m_mapper = Lambdas.ensureRemotable(mapper);
    }

    @Override
    public Supplier<IntSummaryStatistics> supplier() {
        return IntSummaryStatistics::new;
    }

    @Override
    public BiConsumer<IntSummaryStatistics, T> accumulator() {
        ToIntFunction mapper = this.m_mapper;
        return (a, t) -> a.accept(mapper.applyAsInt(t));
    }

    @Override
    public BinaryOperator<IntSummaryStatistics> combiner() {
        return (a, b) -> {
            a.combine((java.util.IntSummaryStatistics)b);
            return a;
        };
    }

    @Override
    public Function<IntSummaryStatistics, IntSummaryStatistics> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (ToIntFunction)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (ToIntFunction)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
    }
}

