/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MappingCollector<T, U, A, R>
implements RemoteCollector<T, A, R>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="mapper")
    protected Function<? super T, ? extends U> m_mapper;
    @JsonbProperty(value="downstream")
    protected RemoteCollector<U, A, R> m_downstream;

    public MappingCollector() {
    }

    public MappingCollector(Function<? super T, ? extends U> mapper, RemoteCollector<U, A, R> downstream) {
        this.m_mapper = Lambdas.ensureRemotable((Remote.Function)mapper);
        this.m_downstream = downstream;
    }

    public MappingCollector(Remote.Function<? super T, ? extends U> mapper, RemoteCollector<U, A, R> downstream) {
        this.m_mapper = Lambdas.ensureRemotable(mapper);
        this.m_downstream = downstream;
    }

    @Override
    public Supplier<A> supplier() {
        return this.m_downstream.supplier();
    }

    @Override
    public BiConsumer<A, T> accumulator() {
        Function mapper = this.m_mapper;
        BiConsumer accumulator = this.m_downstream.accumulator();
        return (a, t) -> accumulator.accept(a, mapper.apply(t));
    }

    @Override
    public BinaryOperator<A> combiner() {
        return this.m_downstream.combiner();
    }

    @Override
    public Function<A, R> finisher() {
        return this.m_downstream.finisher();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.m_downstream.characteristics();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (Function)ExternalizableHelper.readObject(in);
        this.m_downstream = (RemoteCollector)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
        ExternalizableHelper.writeObject(out, this.m_downstream);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (Function)in.readObject(0);
        this.m_downstream = (RemoteCollector)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
        out.writeObject(1, this.m_downstream);
    }
}

