/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MapCollector<T, K, V, M extends Map<K, V>>
extends AbstractEvolvable
implements RemoteCollector<T, M, M>,
ExternalizableLite,
PortableObject {
    private static final int VERSION = 1;
    static final Set<Collector.Characteristics> S_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    @JsonbProperty(value="keyMapper")
    protected Function<? super T, ? extends K> m_keyMapper;
    @JsonbProperty(value="valueMapper")
    protected Function<? super T, ? extends V> m_valueMapper;
    @JsonbProperty(value="mergeFunction")
    protected BinaryOperator<V> m_mergeFunction;
    @JsonbProperty(value="supplier")
    protected Supplier<M> m_supplier;
    @JsonbProperty(value="finisher")
    protected Function<M, M> m_finisher;

    public MapCollector() {
    }

    public MapCollector(Remote.Function<? super T, ? extends K> keyMapper, Remote.Function<? super T, ? extends V> valueMapper, Remote.BinaryOperator<V> mergeFunction, Remote.Supplier<M> supplier) {
        this(keyMapper, valueMapper, mergeFunction, supplier, null);
    }

    public MapCollector(Remote.Function<? super T, ? extends K> keyMapper, Remote.Function<? super T, ? extends V> valueMapper, Remote.BinaryOperator<V> mergeFunction, Remote.Supplier<M> supplier, Remote.Function<M, M> finisher) {
        this.m_keyMapper = Lambdas.ensureRemotable(keyMapper);
        this.m_valueMapper = Lambdas.ensureRemotable(valueMapper);
        this.m_mergeFunction = mergeFunction;
        this.m_supplier = supplier;
        this.m_finisher = finisher;
    }

    @Override
    public Supplier<M> supplier() {
        return this.m_supplier;
    }

    @Override
    public BiConsumer<M, T> accumulator() {
        Function keyMapper = this.m_keyMapper;
        Function valueMapper = this.m_valueMapper;
        BinaryOperator mergeFunction = this.getMergeFunction();
        return (map, t) -> map.merge(keyMapper.apply(t), valueMapper.apply(t), mergeFunction);
    }

    @Override
    public BinaryOperator<M> combiner() {
        BinaryOperator<V> mergeFunction = this.getMergeFunction();
        return Remote.BinaryOperator.mapMerger(mergeFunction);
    }

    @Override
    public Function<M, M> finisher() {
        return this.m_finisher == null ? Function.identity() : this.m_finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    protected BinaryOperator<V> getMergeFunction() {
        return this.m_mergeFunction == null ? this.throwingMerger() : this.m_mergeFunction;
    }

    protected BinaryOperator<V> throwingMerger() {
        return (v1, v2) -> {
            throw new IllegalStateException(String.format("Duplicate key for values %s and %s", v1, v2));
        };
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_keyMapper = (Function)ExternalizableHelper.readObject(in);
        this.m_valueMapper = (Function)ExternalizableHelper.readObject(in);
        this.m_mergeFunction = (BinaryOperator)ExternalizableHelper.readObject(in);
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
        try {
            this.m_finisher = (Function)ExternalizableHelper.readObject(in);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_keyMapper);
        ExternalizableHelper.writeObject(out, this.m_valueMapper);
        ExternalizableHelper.writeObject(out, this.m_mergeFunction);
        ExternalizableHelper.writeObject(out, this.m_supplier);
        ExternalizableHelper.writeObject(out, this.m_finisher);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_keyMapper = (Function)in.readObject(0);
        this.m_valueMapper = (Function)in.readObject(1);
        this.m_mergeFunction = (BinaryOperator)in.readObject(2);
        this.m_supplier = (Supplier)in.readObject(3);
        if (in.getVersionId() >= 1) {
            this.m_finisher = (Function)in.readObject(4);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_keyMapper);
        out.writeObject(1, this.m_valueMapper);
        out.writeObject(2, this.m_mergeFunction);
        out.writeObject(3, this.m_supplier);
        out.writeObject(4, this.m_finisher);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }
}

