/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class CollectionCollector<T, C extends Collection<T>>
extends AbstractEvolvable
implements RemoteCollector<T, C, C>,
ExternalizableLite,
PortableObject {
    private static final int VERSION = 1;
    static final Set<Collector.Characteristics> S_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    @JsonbProperty(value="supplier")
    protected Supplier<C> m_supplier;
    @JsonbProperty(value="finisher")
    protected Function<C, C> m_finisher;

    public CollectionCollector() {
    }

    public CollectionCollector(Supplier<C> supplier) {
        this(supplier, null);
    }

    public CollectionCollector(Supplier<C> supplier, Function<C, C> finisher) {
        this.m_supplier = supplier;
        this.m_finisher = finisher;
    }

    public CollectionCollector(Remote.Supplier<C> supplier) {
        this.m_supplier = supplier;
    }

    @Override
    public Supplier<C> supplier() {
        return this.m_supplier;
    }

    @Override
    public BiConsumer<C, T> accumulator() {
        return Collection::add;
    }

    @Override
    public BinaryOperator<C> combiner() {
        return (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        };
    }

    @Override
    public Function<C, C> finisher() {
        return this.m_finisher == null ? Function.identity() : this.m_finisher;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
        try {
            this.m_finisher = (Function)ExternalizableHelper.readObject(in);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_supplier);
        ExternalizableHelper.writeObject(out, this.m_finisher);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_supplier = (Supplier)in.readObject(0);
        if (in.getVersionId() >= 1) {
            this.m_finisher = (Function)in.readObject(1);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_supplier);
        out.writeObject(1, this.m_finisher);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }
}

