/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.oracle.coherence.common.base.Holder;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SimpleHolder;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class BiReducingCollector<T, U>
implements RemoteCollector<T, SimpleHolder<U>, U>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="identity")
    protected U m_identity;
    @JsonbProperty(value="mapper")
    protected BiFunction<? super U, ? super T, ? extends U> m_mapper;
    @JsonbProperty(value="operator")
    protected BinaryOperator<U> m_operator;

    public BiReducingCollector() {
    }

    public BiReducingCollector(U identity, Remote.BiFunction<? super U, ? super T, ? extends U> mapper, Remote.BinaryOperator<U> operator) {
        this.m_identity = identity;
        this.m_mapper = mapper;
        this.m_operator = operator;
    }

    public BiReducingCollector(U identity, BiFunction<? super U, ? super T, ? extends U> mapper, BinaryOperator<U> operator) {
        this.m_identity = identity;
        this.m_mapper = mapper;
        this.m_operator = operator;
    }

    @Override
    public Supplier<SimpleHolder<U>> supplier() {
        Object identity = this.m_identity;
        return () -> new SimpleHolder<Object>(identity);
    }

    @Override
    public BiConsumer<SimpleHolder<U>, T> accumulator() {
        BiFunction mapper = this.m_mapper;
        BinaryOperator<U> op = this.m_operator;
        return (a, t) -> {
            if (t != null) {
                a.set(mapper.apply((Object)a.get(), (Object)t));
            }
        };
    }

    @Override
    public BinaryOperator<SimpleHolder<U>> combiner() {
        BinaryOperator op = this.m_operator;
        return (a, b) -> {
            if (b.isPresent()) {
                if (a.isPresent()) {
                    a.set(op.apply(a.get(), b.get()));
                } else {
                    a.set(b.get());
                }
            }
            return a;
        };
    }

    @Override
    public Function<SimpleHolder<U>, U> finisher() {
        return Holder::get;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_identity = ExternalizableHelper.readObject(in);
        this.m_mapper = (BiFunction)ExternalizableHelper.readObject(in);
        this.m_operator = (BinaryOperator)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_identity);
        ExternalizableHelper.writeObject(out, this.m_mapper);
        ExternalizableHelper.writeObject(out, this.m_operator);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_identity = in.readObject(0);
        this.m_mapper = (BiFunction)in.readObject(1);
        this.m_operator = (BinaryOperator)in.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_identity);
        out.writeObject(1, this.m_mapper);
        out.writeObject(2, this.m_operator);
    }
}

