/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.stream.collectors.SummingDoubleCollector;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.function.Remote;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class AveragingDoubleCollector<T>
extends SummingDoubleCollector<T>
implements ExternalizableLite,
PortableObject {
    public AveragingDoubleCollector() {
    }

    public AveragingDoubleCollector(Remote.ToDoubleFunction<? super T> mapper) {
        super(mapper);
    }

    @Override
    public Supplier<double[]> supplier() {
        return () -> new double[4];
    }

    @Override
    public BiConsumer<double[], T> accumulator() {
        ToDoubleFunction mapper = this.m_mapper;
        return (a, t) -> {
            double dblValue = mapper.applyAsDouble(t);
            AveragingDoubleCollector.sumWithCompensation(a, dblValue);
            a[2] = a[2] + 1.0;
            a[3] = a[3] + dblValue;
        };
    }

    @Override
    public BinaryOperator<double[]> combiner() {
        return (a, b) -> {
            AveragingDoubleCollector.sumWithCompensation(a, b[0]);
            AveragingDoubleCollector.sumWithCompensation(a, b[1]);
            a[2] = a[2] + b[2];
            a[3] = a[3] + b[3];
            return a;
        };
    }

    @Override
    public Function<double[], Double> finisher() {
        return a -> a[2] == 0.0 ? 0.0 : AveragingDoubleCollector.computeFinalSum(a) / a[2];
    }
}

