/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.internal.util.LongBag;
import com.tangosol.internal.util.LongSummaryStatistics;
import com.tangosol.internal.util.stream.AbstractPipeline;
import com.tangosol.internal.util.stream.DoublePipeline;
import com.tangosol.internal.util.stream.IntPipeline;
import com.tangosol.internal.util.stream.LongCollectorAggregator;
import com.tangosol.internal.util.stream.ReferencePipeline;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteDoubleStream;
import com.tangosol.util.stream.RemoteIntStream;
import com.tangosol.util.stream.RemoteLongStream;
import com.tangosol.util.stream.RemotePipeline;
import com.tangosol.util.stream.RemoteStream;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;

public abstract class LongPipeline<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
extends AbstractPipeline<K, V, E_IN, Long, S_IN, LongStream>
implements RemoteLongStream {
    public LongPipeline() {
    }

    protected LongPipeline(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Function<S_IN, LongStream> intermediateOp) {
        super(previousStage, intermediateOp);
    }

    @Override
    public RemoteLongStream sequential() {
        this.setParallel(false);
        return this;
    }

    @Override
    public RemoteLongStream parallel() {
        this.setParallel(true);
        return this;
    }

    @Override
    public RemoteLongStream unordered() {
        return new StatelessOp(this, s -> (LongStream)s.unordered());
    }

    @Override
    public RemoteLongStream filter(LongPredicate predicate) {
        return new StatelessOp(this, s -> s.filter(predicate));
    }

    @Override
    public RemoteLongStream map(LongUnaryOperator mapper) {
        return new StatelessOp(this, s -> s.map(mapper));
    }

    @Override
    public <U> RemoteStream<U> mapToObj(LongFunction<? extends U> mapper) {
        return new ReferencePipeline.StatelessOp(this, s -> s.mapToObj(mapper));
    }

    @Override
    public RemoteIntStream mapToInt(LongToIntFunction mapper) {
        return new IntPipeline.StatelessOp(this, s -> s.mapToInt(mapper));
    }

    @Override
    public RemoteDoubleStream mapToDouble(LongToDoubleFunction mapper) {
        return new DoublePipeline.StatelessOp(this, s -> s.mapToDouble(mapper));
    }

    @Override
    public RemoteLongStream flatMap(LongFunction<? extends LongStream> mapper) {
        return new StatelessOp(this, s -> s.flatMap(mapper));
    }

    @Override
    public RemoteLongStream peek(LongConsumer action) {
        return new StatelessOp(this, s -> s.peek(action));
    }

    @Override
    public LongStream limit(long maxSize) {
        StatefulOp op = new StatefulOp(this, s -> s.limit(maxSize));
        return Arrays.stream(this.collectToBag(op).toArray()).limit(maxSize);
    }

    @Override
    public LongStream skip(long n) {
        return Arrays.stream(this.collectToBag(this).toArray()).skip(n);
    }

    @Override
    public LongStream distinct() {
        StatefulOp op = new StatefulOp(this, s -> s.distinct());
        return Arrays.stream(this.collectToBag(op).toArray());
    }

    @Override
    public LongStream sorted() {
        StatefulOp op = new StatefulOp(this, s -> s.sorted());
        return Arrays.stream(this.collectToBag(op).toArray()).sorted();
    }

    @Override
    public RemoteDoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp(this, s -> s.asDoubleStream());
    }

    @Override
    public RemoteStream<Long> boxed() {
        return new ReferencePipeline.StatelessOp(this, s -> s.boxed());
    }

    @Override
    public void forEach(LongConsumer action) {
        this.collectToBag(this).forEach(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.forEach(action);
    }

    @Override
    public long[] toArray() {
        return this.collectToBag(this).toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        return ((long[])this.collect(() -> new long[]{identity}, (a, t) -> {
            a[0] = op.applyAsLong(a[0], t);
        }, (a, b) -> {
            a[0] = op.applyAsLong(a[0], b[0]);
        }))[0];
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        Optional result = (Optional)this.collect(() -> new Optional(op), Optional::accept, (a, b) -> {
            if (b.isPresent()) {
                a.accept(b.getValue());
            }
        });
        return result.isPresent() ? OptionalLong.of(result.getValue()) : OptionalLong.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.collect((RemotePipeline<LongStream>)this, supplier, accumulator, combiner);
    }

    @Override
    public long sum() {
        return this.reduce(0L, Long::sum);
    }

    @Override
    public OptionalLong min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalLong max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.map(e -> 1L).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(() -> new long[2], (a, t) -> {
            a[0] = a[0] + 1L;
            a[1] = a[1] + t;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return (LongSummaryStatistics)this.collect(LongSummaryStatistics::new, java.util.LongSummaryStatistics::accept, java.util.LongSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.anyMatch(predicate), p -> p));
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.allMatch(predicate), p -> p == false));
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.noneMatch(predicate), p -> p == false));
    }

    @Override
    public OptionalLong findFirst() {
        return (OptionalLong)this.invoke(new FinderAggregator(this, LongStream::findFirst));
    }

    @Override
    public OptionalLong findAny() {
        return (OptionalLong)this.invoke(new FinderAggregator(this, LongStream::findAny));
    }

    @Override
    public final PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.toArray(), 0);
    }

    protected LongBag collectToBag(RemotePipeline<LongStream> pipeline) {
        return (LongBag)this.collect(pipeline, LongBag::new, LongBag::add, LongBag::addAll);
    }

    protected <R> R collect(RemotePipeline<LongStream> pipeline, Remote.Supplier<R> supplier, Remote.ObjLongConsumer<R> accumulator, Remote.BiConsumer<R, R> combiner) {
        return this.invoke(new LongCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    protected <R> R collect(RemotePipeline<LongStream> pipeline, Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.invoke(new LongCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    public static class StatelessOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends LongPipeline<K, V, E_IN, S_IN> {
        public StatelessOp() {
        }

        StatelessOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, LongStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class StatefulOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends LongPipeline<K, V, E_IN, S_IN> {
        public StatefulOp() {
        }

        StatefulOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, LongStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class Optional
    implements Remote.LongConsumer,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="op")
        private LongBinaryOperator m_op;
        @JsonbProperty(value="value")
        private long m_value = 0L;
        @JsonbProperty(value="isPresent")
        private boolean m_fPresent = false;

        public Optional() {
        }

        public Optional(LongBinaryOperator op) {
            this.m_op = op;
        }

        public long getValue() {
            return this.m_value;
        }

        public boolean isPresent() {
            return this.m_fPresent;
        }

        @Override
        public void accept(long t) {
            if (this.m_fPresent) {
                this.m_value = this.m_op.applyAsLong(this.m_value, t);
            } else {
                this.m_value = t;
                this.m_fPresent = true;
            }
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_op = (LongBinaryOperator)ExternalizableHelper.readObject(in);
            this.m_value = in.readLong();
            this.m_fPresent = in.readBoolean();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_op);
            out.writeLong(this.m_value);
            out.writeBoolean(this.m_fPresent);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_op = (LongBinaryOperator)reader.readObject(0);
            this.m_value = reader.readLong(1);
            this.m_fPresent = reader.readBoolean(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_op);
            writer.writeLong(1, this.m_value);
            writer.writeBoolean(2, this.m_fPresent);
        }
    }

    public static class MatcherAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, Boolean, Boolean>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends LongStream> m_pipeline;
        @JsonbProperty(value="fnMatcher")
        private Remote.Function<LongStream, Boolean> m_fnMatcher;
        @JsonbProperty(value="predShortCircuit")
        private Remote.Predicate<Boolean> m_predShortCircuit;
        private transient Boolean m_fResult;
        private transient boolean m_fDone;

        public MatcherAggregator() {
        }

        MatcherAggregator(RemotePipeline<? extends LongStream> pipeline, Remote.Function<LongStream, Boolean> fnMatcher, Remote.Predicate<Boolean> predShortCircuit) {
            this.m_pipeline = pipeline;
            this.m_fnMatcher = fnMatcher;
            this.m_predShortCircuit = predShortCircuit;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, Boolean, Boolean> supply() {
            return new MatcherAggregator<K, V>(this.m_pipeline, this.m_fnMatcher, this.m_predShortCircuit);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            LongStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_fResult = (Boolean)this.m_fnMatcher.apply(stream);
            return !this.m_predShortCircuit.test(this.m_fResult);
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(Boolean partialResult) {
            if (!this.m_fDone) {
                this.m_fResult = partialResult;
                this.m_fDone = this.m_predShortCircuit.test(this.m_fResult);
            }
            return !this.m_fDone;
        }

        @Override
        public Boolean getPartialResult() {
            return this.m_fResult;
        }

        @Override
        public Boolean finalizeResult() {
            return this.m_fResult;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnMatcher = (Remote.Function)ExternalizableHelper.readObject(in);
            this.m_predShortCircuit = (Remote.Predicate)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnMatcher);
            ExternalizableHelper.writeObject(out, this.m_predShortCircuit);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnMatcher = (Remote.Function)reader.readObject(1);
            this.m_predShortCircuit = (Remote.Predicate)reader.readObject(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnMatcher);
            writer.writeObject(2, this.m_predShortCircuit);
        }
    }

    public static class FinderAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, OptionalLong, OptionalLong>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends LongStream> m_pipeline;
        @JsonbProperty(value="fnFinder")
        private Remote.Function<LongStream, OptionalLong> m_fnFinder;
        private transient OptionalLong m_result = OptionalLong.empty();
        private transient boolean m_fDone;

        public FinderAggregator() {
        }

        FinderAggregator(RemotePipeline<? extends LongStream> pipeline, Remote.Function<LongStream, OptionalLong> fnFinder) {
            this.m_pipeline = pipeline;
            this.m_fnFinder = fnFinder;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, OptionalLong, OptionalLong> supply() {
            return new FinderAggregator<K, V>(this.m_pipeline, this.m_fnFinder);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            LongStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_result = (OptionalLong)this.m_fnFinder.apply(stream);
            return !this.m_result.isPresent();
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(OptionalLong partialResult) {
            if (!this.m_fDone) {
                this.m_result = partialResult;
                this.m_fDone = this.m_result.isPresent();
            }
            return !this.m_fDone;
        }

        @Override
        public OptionalLong getPartialResult() {
            return this.m_result;
        }

        @Override
        public OptionalLong finalizeResult() {
            return this.m_result;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnFinder = (Remote.Function)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnFinder);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnFinder = (Remote.Function)reader.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnFinder);
        }
    }
}

