/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.internal.util.IntBag;
import com.tangosol.internal.util.IntSummaryStatistics;
import com.tangosol.internal.util.stream.AbstractPipeline;
import com.tangosol.internal.util.stream.DoublePipeline;
import com.tangosol.internal.util.stream.IntCollectorAggregator;
import com.tangosol.internal.util.stream.LongPipeline;
import com.tangosol.internal.util.stream.ReferencePipeline;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteDoubleStream;
import com.tangosol.util.stream.RemoteIntStream;
import com.tangosol.util.stream.RemoteLongStream;
import com.tangosol.util.stream.RemotePipeline;
import com.tangosol.util.stream.RemoteStream;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;

public abstract class IntPipeline<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
extends AbstractPipeline<K, V, E_IN, Integer, S_IN, IntStream>
implements RemoteIntStream {
    public IntPipeline() {
    }

    protected IntPipeline(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Function<S_IN, IntStream> intermediateOp) {
        super(previousStage, intermediateOp);
    }

    @Override
    public RemoteIntStream sequential() {
        this.setParallel(false);
        return this;
    }

    @Override
    public RemoteIntStream parallel() {
        this.setParallel(true);
        return this;
    }

    @Override
    public RemoteIntStream unordered() {
        return new StatelessOp(this, s -> (IntStream)s.unordered());
    }

    @Override
    public RemoteIntStream filter(IntPredicate predicate) {
        return new StatelessOp(this, s -> s.filter(predicate));
    }

    @Override
    public RemoteIntStream map(IntUnaryOperator mapper) {
        return new StatelessOp(this, s -> s.map(mapper));
    }

    @Override
    public <U> RemoteStream<U> mapToObj(IntFunction<? extends U> mapper) {
        return new ReferencePipeline.StatelessOp(this, s -> s.mapToObj(mapper));
    }

    @Override
    public RemoteLongStream mapToLong(IntToLongFunction mapper) {
        return new LongPipeline.StatelessOp(this, s -> s.mapToLong(mapper));
    }

    @Override
    public RemoteDoubleStream mapToDouble(IntToDoubleFunction mapper) {
        return new DoublePipeline.StatelessOp(this, s -> s.mapToDouble(mapper));
    }

    @Override
    public RemoteIntStream flatMap(IntFunction<? extends IntStream> mapper) {
        return new StatelessOp(this, s -> s.flatMap(mapper));
    }

    @Override
    public RemoteIntStream peek(IntConsumer action) {
        return new StatelessOp(this, s -> s.peek(action));
    }

    @Override
    public IntStream limit(long maxSize) {
        StatefulOp op = new StatefulOp(this, s -> s.limit(maxSize));
        return Arrays.stream(this.collectToBag(op).toArray()).limit(maxSize);
    }

    @Override
    public IntStream skip(long n) {
        return Arrays.stream(this.collectToBag(this).toArray()).skip(n);
    }

    @Override
    public IntStream distinct() {
        StatefulOp op = new StatefulOp(this, s -> s.distinct());
        return Arrays.stream(this.collectToBag(op).toArray());
    }

    @Override
    public IntStream sorted() {
        StatefulOp op = new StatefulOp(this, s -> s.sorted());
        return Arrays.stream(this.collectToBag(op).toArray()).sorted();
    }

    @Override
    public RemoteLongStream asLongStream() {
        return new LongPipeline.StatelessOp(this, s -> s.asLongStream());
    }

    @Override
    public RemoteDoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp(this, s -> s.asDoubleStream());
    }

    @Override
    public RemoteStream<Integer> boxed() {
        return new ReferencePipeline.StatelessOp(this, s -> s.boxed());
    }

    @Override
    public void forEach(IntConsumer action) {
        this.collectToBag(this).forEach(action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.forEach(action);
    }

    @Override
    public int[] toArray() {
        return this.collectToBag(this).toArray();
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return ((int[])this.collect(() -> new int[]{identity}, (a, t) -> {
            a[0] = op.applyAsInt(a[0], t);
        }, (a, b) -> {
            a[0] = op.applyAsInt(a[0], b[0]);
        }))[0];
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        Optional result = (Optional)this.collect(() -> new Optional(op), Optional::accept, (a, b) -> {
            if (b.isPresent()) {
                a.accept(b.getValue());
            }
        });
        return result.isPresent() ? OptionalInt.of(result.getValue()) : OptionalInt.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.collect((RemotePipeline<IntStream>)this, supplier, accumulator, combiner);
    }

    @Override
    public int sum() {
        return this.reduce(0, Integer::sum);
    }

    @Override
    public OptionalInt min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalInt max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        return this.mapToLong(e -> 1L).sum();
    }

    @Override
    public OptionalDouble average() {
        long[] avg = (long[])this.collect(() -> new long[2], (a, t) -> {
            a[0] = a[0] + 1L;
            a[1] = a[1] + (long)t;
        }, (a, b) -> {
            a[0] = a[0] + b[0];
            a[1] = a[1] + b[1];
        });
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return (IntSummaryStatistics)this.collect(IntSummaryStatistics::new, java.util.IntSummaryStatistics::accept, java.util.IntSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.anyMatch(predicate), p -> p));
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.allMatch(predicate), p -> p == false));
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return (Boolean)this.invoke(new MatcherAggregator(this, s -> s.noneMatch(predicate), p -> p == false));
    }

    @Override
    public OptionalInt findFirst() {
        return (OptionalInt)this.invoke(new FinderAggregator(this, IntStream::findFirst));
    }

    @Override
    public OptionalInt findAny() {
        return (OptionalInt)this.invoke(new FinderAggregator(this, IntStream::findAny));
    }

    @Override
    public final PrimitiveIterator.OfInt iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.toArray(), 0);
    }

    protected IntBag collectToBag(RemotePipeline<IntStream> pipeline) {
        return (IntBag)this.collect(pipeline, IntBag::new, IntBag::add, IntBag::addAll);
    }

    protected <R> R collect(RemotePipeline<IntStream> pipeline, Remote.Supplier<R> supplier, Remote.ObjIntConsumer<R> accumulator, Remote.BiConsumer<R, R> combiner) {
        return this.invoke(new IntCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    protected <R> R collect(RemotePipeline<IntStream> pipeline, Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.invoke(new IntCollectorAggregator(pipeline, supplier, accumulator, combiner));
    }

    public static class StatelessOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends IntPipeline<K, V, E_IN, S_IN> {
        public StatelessOp() {
        }

        StatelessOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, IntStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class StatefulOp<K, V, E_IN, S_IN extends BaseStream<E_IN, S_IN>>
    extends IntPipeline<K, V, E_IN, S_IN> {
        public StatefulOp() {
        }

        StatefulOp(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Remote.Function<S_IN, IntStream> intermediateOp) {
            super(previousStage, intermediateOp);
        }
    }

    public static class Optional
    implements Remote.IntConsumer,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="op")
        private IntBinaryOperator m_op;
        @JsonbProperty(value="value")
        private int m_value = 0;
        @JsonbProperty(value="isPresent")
        private boolean m_fPresent = false;

        public Optional() {
        }

        public Optional(IntBinaryOperator op) {
            this.m_op = op;
        }

        public int getValue() {
            return this.m_value;
        }

        public boolean isPresent() {
            return this.m_fPresent;
        }

        @Override
        public void accept(int t) {
            if (this.m_fPresent) {
                this.m_value = this.m_op.applyAsInt(this.m_value, t);
            } else {
                this.m_value = t;
                this.m_fPresent = true;
            }
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_op = (IntBinaryOperator)ExternalizableHelper.readObject(in);
            this.m_value = in.readInt();
            this.m_fPresent = in.readBoolean();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_op);
            out.writeInt(this.m_value);
            out.writeBoolean(this.m_fPresent);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_op = (IntBinaryOperator)reader.readObject(0);
            this.m_value = reader.readInt(1);
            this.m_fPresent = reader.readBoolean(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_op);
            writer.writeInt(1, this.m_value);
            writer.writeBoolean(2, this.m_fPresent);
        }
    }

    public static class MatcherAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, Boolean, Boolean>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends IntStream> m_pipeline;
        @JsonbProperty(value="fnMatcher")
        private Remote.Function<IntStream, Boolean> m_fnMatcher;
        @JsonbProperty(value="predShortCircuit")
        private Remote.Predicate<Boolean> m_predShortCircuit;
        private transient Boolean m_fResult;
        private transient boolean m_fDone;

        public MatcherAggregator() {
        }

        MatcherAggregator(RemotePipeline<? extends IntStream> pipeline, Remote.Function<IntStream, Boolean> fnMatcher, Remote.Predicate<Boolean> predShortCircuit) {
            this.m_pipeline = pipeline;
            this.m_fnMatcher = fnMatcher;
            this.m_predShortCircuit = predShortCircuit;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, Boolean, Boolean> supply() {
            return new MatcherAggregator<K, V>(this.m_pipeline, this.m_fnMatcher, this.m_predShortCircuit);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            IntStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_fResult = (Boolean)this.m_fnMatcher.apply(stream);
            return !this.m_predShortCircuit.test(this.m_fResult);
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(Boolean partialResult) {
            if (!this.m_fDone) {
                this.m_fResult = partialResult;
                this.m_fDone = this.m_predShortCircuit.test(this.m_fResult);
            }
            return !this.m_fDone;
        }

        @Override
        public Boolean getPartialResult() {
            return this.m_fResult;
        }

        @Override
        public Boolean finalizeResult() {
            return this.m_fResult;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnMatcher = (Remote.Function)ExternalizableHelper.readObject(in);
            this.m_predShortCircuit = (Remote.Predicate)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnMatcher);
            ExternalizableHelper.writeObject(out, this.m_predShortCircuit);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnMatcher = (Remote.Function)reader.readObject(1);
            this.m_predShortCircuit = (Remote.Predicate)reader.readObject(2);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnMatcher);
            writer.writeObject(2, this.m_predShortCircuit);
        }
    }

    public static class FinderAggregator<K, V>
    implements InvocableMap.StreamingAggregator<K, V, OptionalInt, OptionalInt>,
    ExternalizableLite,
    PortableObject {
        @JsonbProperty(value="pipeline")
        private RemotePipeline<? extends IntStream> m_pipeline;
        @JsonbProperty(value="fnFinder")
        private Remote.Function<IntStream, OptionalInt> m_fnFinder;
        private transient OptionalInt m_result = OptionalInt.empty();
        private transient boolean m_fDone;

        public FinderAggregator() {
        }

        FinderAggregator(RemotePipeline<? extends IntStream> pipeline, Remote.Function<IntStream, OptionalInt> fnFinder) {
            this.m_pipeline = pipeline;
            this.m_fnFinder = fnFinder;
        }

        @Override
        public InvocableMap.StreamingAggregator<K, V, OptionalInt, OptionalInt> supply() {
            return new FinderAggregator<K, V>(this.m_pipeline, this.m_fnFinder);
        }

        @Override
        public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
            IntStream stream = this.m_pipeline.evaluate(streamer.stream());
            this.m_result = (OptionalInt)this.m_fnFinder.apply(stream);
            return !this.m_result.isPresent();
        }

        @Override
        public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean combine(OptionalInt partialResult) {
            if (!this.m_fDone) {
                this.m_result = partialResult;
                this.m_fDone = this.m_result.isPresent();
            }
            return !this.m_fDone;
        }

        @Override
        public OptionalInt getPartialResult() {
            return this.m_result;
        }

        @Override
        public OptionalInt finalizeResult() {
            return this.m_result;
        }

        @Override
        public int characteristics() {
            return 2;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
            this.m_fnFinder = (Remote.Function)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_pipeline);
            ExternalizableHelper.writeObject(out, this.m_fnFinder);
        }

        @Override
        public void readExternal(PofReader reader) throws IOException {
            this.m_pipeline = (RemotePipeline)reader.readObject(0);
            this.m_fnFinder = (Remote.Function)reader.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeObject(0, this.m_pipeline);
            writer.writeObject(1, this.m_fnFinder);
        }
    }
}

