/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Streamer;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemotePipeline;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public class CollectorAggregator<K, V, T, P, R>
implements InvocableMap.StreamingAggregator<K, V, P, R>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="pipeline")
    protected RemotePipeline<? extends Stream<T>> m_pipeline;
    @JsonbProperty(value="collector")
    protected RemoteCollector<? super T, P, R> m_collector;
    private transient P m_result;
    private transient BinaryOperator<P> m_combiner;

    public CollectorAggregator() {
    }

    public CollectorAggregator(RemotePipeline<? extends Stream<T>> pipeline, RemoteCollector<? super T, P, R> collector) {
        Objects.requireNonNull(pipeline);
        Objects.requireNonNull(collector);
        this.m_collector = collector;
        this.m_pipeline = pipeline;
    }

    @Override
    public R aggregate(Set<? extends InvocableMap.Entry<? extends K, ? extends V>> setEntries) {
        Stream<T> s = this.getPipeline().evaluate(setEntries.stream());
        return s.collect(this.getCollector());
    }

    @Override
    public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
        Stream<Object> stream = this.getPipeline().evaluate(streamer.stream());
        RemoteCollector<T, P, R> collector = this.getCollector();
        BiConsumer accumulator = collector.accumulator();
        Object result = collector.supplier().get();
        stream.forEach(t -> accumulator.accept(result, t));
        this.m_result = result;
        return true;
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, P, R> supply() {
        return new CollectorAggregator<K, V, T, P, R>(this.getPipeline(), this.getCollector());
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        return true;
    }

    @Override
    public boolean combine(P partialResult) {
        if (this.m_result == null) {
            this.m_result = this.getCollector().supplier().get();
            this.m_combiner = this.getCollector().combiner();
        }
        this.m_combiner.apply(this.m_result, partialResult);
        return true;
    }

    @Override
    public P getPartialResult() {
        return this.m_result;
    }

    @Override
    public R finalizeResult() {
        return this.getCollector().finisher().apply(this.m_result);
    }

    @Override
    public int characteristics() {
        return (this.getPipeline().isParallel() ? 1 : 2) | 0x10;
    }

    public RemotePipeline<? extends Stream<T>> getPipeline() {
        RemotePipeline<Stream<T>> pipeline = this.m_pipeline;
        if (pipeline == null) {
            pipeline = this.m_pipeline = this.createPipeline();
        }
        return pipeline;
    }

    protected RemotePipeline<? extends Stream<T>> createPipeline() {
        return null;
    }

    public RemoteCollector<? super T, P, R> getCollector() {
        RemoteCollector<Object, P, R> collector = this.m_collector;
        if (collector == null) {
            collector = this.m_collector = this.createCollector();
        }
        return collector;
    }

    protected RemoteCollector<? super T, P, R> createCollector() {
        return null;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_pipeline = (RemotePipeline)ExternalizableHelper.readObject(in);
        this.m_collector = (RemoteCollector)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_pipeline);
        ExternalizableHelper.writeObject(out, this.m_collector);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_pipeline = (RemotePipeline)in.readObject(0);
        this.m_collector = (RemoteCollector)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_pipeline);
        out.writeObject(1, this.m_collector);
    }
}

