/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.stream.BaseRemoteStream;
import com.tangosol.util.stream.RemoteCollector;
import com.tangosol.util.stream.RemoteCollectors;
import com.tangosol.util.stream.RemotePipeline;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.Stream;

public abstract class AbstractPipeline<K, V, E_IN, E_OUT, S_IN extends BaseStream<E_IN, S_IN>, S_OUT extends BaseStream<E_OUT, S_OUT>>
implements BaseRemoteStream<E_OUT, S_OUT>,
RemotePipeline<S_OUT>,
ExternalizableLite,
PortableObject {
    private static final String MSG_STREAM_LINKED = "stream has already been operated upon or closed";
    private transient AggregatorInvoker<K, V> m_invoker;
    private transient boolean m_fLinkedOrConsumed;
    private transient Runnable m_sourceCloseAction;
    @JsonbProperty(value="isParallel")
    private boolean m_fParallel;
    @JsonbProperty(value="comparator")
    private Comparator<? super E_OUT> m_comparator;
    @JsonbProperty(value="previousStage")
    private AbstractPipeline<K, V, ?, E_IN, ?, S_IN> m_previousStage;
    @JsonbProperty(value="intermediateOp")
    private Function<S_IN, S_OUT> m_intermediateOp;

    protected AbstractPipeline() {
    }

    protected AbstractPipeline(InvocableMap<K, V> map, boolean fParallel, Collection<? extends K> colKeys, Filter filter, Function<S_IN, S_OUT> intermediateOp) {
        this.m_invoker = new AggregatorInvoker<K, V>(map, colKeys, filter);
        this.m_previousStage = null;
        this.m_fParallel = fParallel;
        this.m_intermediateOp = intermediateOp;
    }

    protected AbstractPipeline(AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage, Function<S_IN, S_OUT> intermediateOp) {
        if (previousStage.m_fLinkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        previousStage.m_fLinkedOrConsumed = true;
        this.m_previousStage = previousStage;
        this.m_intermediateOp = intermediateOp;
    }

    @Override
    public <K, V> S_OUT evaluate(Stream<? extends InvocableMap.Entry<? extends K, ? extends V>> stream) {
        AbstractPipeline<K, V, ?, E_IN, ?, S_IN> previousStage = this.m_previousStage;
        return (S_OUT)(previousStage == null ? (BaseStream)this.m_intermediateOp.apply(stream) : (BaseStream)this.m_intermediateOp.apply(previousStage.evaluate(stream)));
    }

    @Override
    public void close() {
        this.m_fLinkedOrConsumed = true;
        this.m_invoker = null;
        if (this.head().m_sourceCloseAction != null) {
            Runnable closeAction = this.head().m_sourceCloseAction;
            this.head().m_sourceCloseAction = null;
            closeAction.run();
        }
    }

    @Override
    public S_OUT onClose(Runnable closeHandler) {
        Runnable existingHandler = this.head().m_sourceCloseAction;
        this.head().m_sourceCloseAction = existingHandler == null ? closeHandler : this.composeWithExceptions(existingHandler, closeHandler);
        return (S_OUT)this;
    }

    @Override
    public RemotePipeline<S_OUT> pipeline() {
        return this;
    }

    @Override
    public final boolean isParallel() {
        return this.head().m_fParallel;
    }

    protected void setParallel(boolean fParallel) {
        this.head().m_fParallel = fParallel;
    }

    public Comparator<? super E_OUT> getComparator() {
        return this.m_comparator;
    }

    protected void setComparator(Comparator<? super E_OUT> comparator) {
        this.m_comparator = comparator;
    }

    protected boolean isSorted() {
        boolean fSorted = false;
        AbstractPipeline<K, V, ?, E_IN, ?, S_IN> curr = this;
        while (curr.m_previousStage != null && !fSorted) {
            fSorted = curr.m_comparator != null;
            curr = curr.m_previousStage;
        }
        return fSorted;
    }

    protected InvocableMap<K, V> getMap() {
        return this.head().m_invoker.getMap();
    }

    protected boolean isPartitionable() {
        if (this.getInvoker().getKeys() != null) {
            return false;
        }
        InvocableMap<K, V> map = this.getMap();
        return map instanceof NamedCache && (!(map instanceof ContinuousQueryCache) || !((ContinuousQueryCache)map).isCacheValues()) && ((NamedCache)map).getCacheService() instanceof PartitionedService;
    }

    protected <R> R invoke(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return this.head().m_invoker.invoke(aggregator);
    }

    public AggregatorInvoker<K, V> getInvoker() {
        return this.head().m_invoker;
    }

    protected AbstractPipeline<K, V, ?, ?, ?, ?> head() {
        AbstractPipeline<K, V, ?, E_IN, ?, S_IN> head = this;
        while (head.m_previousStage != null) {
            head = head.m_previousStage;
        }
        return head;
    }

    protected RemoteCollector<E_OUT, ?, ? extends Collection<E_OUT>> toCollection() {
        return this.isSorted() ? RemoteCollectors.toSortedBag(this.getComparator()) : RemoteCollectors.toList();
    }

    protected RemoteCollector<E_OUT, ?, ? extends Set<E_OUT>> toSet() {
        return this.isSorted() ? RemoteCollectors.toSortedSet(this.getComparator()) : RemoteCollectors.toSet();
    }

    private Runnable composeWithExceptions(final Runnable a, final Runnable b) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    a.run();
                }
                catch (Throwable e1) {
                    try {
                        b.run();
                    }
                    catch (Throwable e2) {
                        try {
                            e1.addSuppressed(e2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw e1;
                }
                b.run();
            }
        };
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fParallel = in.readBoolean();
        this.m_comparator = (Comparator)ExternalizableHelper.readObject(in);
        this.m_previousStage = (AbstractPipeline)ExternalizableHelper.readObject(in);
        this.m_intermediateOp = (Function)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fParallel);
        ExternalizableHelper.writeObject(out, this.m_comparator);
        ExternalizableHelper.writeObject(out, this.m_previousStage);
        ExternalizableHelper.writeObject(out, this.m_intermediateOp);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_fParallel = reader.readBoolean(0);
        this.m_comparator = (Comparator)reader.readObject(1);
        this.m_previousStage = (AbstractPipeline)reader.readObject(2);
        this.m_intermediateOp = (Function)reader.readObject(3);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeBoolean(0, this.m_fParallel);
        writer.writeObject(1, this.m_comparator);
        writer.writeObject(2, this.m_previousStage);
        writer.writeObject(3, this.m_intermediateOp);
    }

    protected static class AggregatorInvoker<K, V> {
        private InvocableMap<K, V> m_map;
        private Collection<? extends K> m_colKeys;
        private Filter m_filter;

        public AggregatorInvoker(InvocableMap<K, V> map, Collection<? extends K> colKeys, Filter filter) {
            this.m_map = map;
            this.m_colKeys = colKeys;
            this.m_filter = filter;
        }

        public <R> R invoke(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
            return this.m_colKeys == null ? this.getMap().aggregate(this.m_filter, aggregator) : this.getMap().aggregate(this.m_colKeys, aggregator);
        }

        public InvocableMap<K, V> getMap() {
            InvocableMap<K, V> map = this.m_map;
            if (map == null) {
                throw new IllegalStateException("Cannot invoke terminal operation on a pipeline builder");
            }
            return map;
        }

        public Collection<? extends K> getKeys() {
            return this.m_colKeys;
        }

        public Filter getFilter() {
            return this.m_filter;
        }
    }
}

