/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class BinaryProcessors {
    private BinaryProcessors() {
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> get() {
        return BinaryGetProcessor.INSTANCE;
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> put(Binary value, long ttl) {
        return new BinaryPutProcessor(value, ttl);
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> blindPut(Binary value, long ttl) {
        return new BinaryBlindPutProcessor(value, ttl);
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> putAll(Map<Binary, Binary> map) {
        return new BinaryPutAllProcessor(map);
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> putAll(Map<Binary, Binary> map, long cMillis) {
        return cMillis == 0L ? new BinaryPutAllProcessor(map) : new BinaryPutAllWithExpiryProcessor(map, cMillis);
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> putIfAbsent(Binary value, long ttl) {
        return new BinaryPutIfAbsentProcessor(value, ttl);
    }

    public static InvocableMap.EntryProcessor<Binary, Binary, Binary> remove() {
        return BinaryRemoveProcessor.INSTANCE;
    }

    public static class BinaryGetProcessor
    extends BaseProcessor<Binary> {
        public static final BinaryGetProcessor INSTANCE = new BinaryGetProcessor();

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            Binary prevValue = null;
            if (entry.isPresent()) {
                prevValue = ((BinaryEntry)entry).getBinaryValue();
            } else {
                entry.getValue();
                if (entry.isPresent()) {
                    prevValue = ((BinaryEntry)entry).getBinaryValue();
                }
            }
            return prevValue;
        }

        @Override
        public Map<Binary, Binary> processAll(Set<? extends InvocableMap.Entry<Binary, Binary>> setEntries) {
            LiteMap<Binary, Binary> mapResults = new LiteMap<Binary, Binary>();
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<? extends InvocableMap.Entry<Binary, Binary>> iter = setEntries.iterator();
            while (iter.hasNext()) {
                InvocableMap.Entry<Binary, Binary> entry = iter.next();
                if (entry.isPresent()) {
                    mapResults.put(((BinaryEntry)entry).getBinaryKey(), (Binary)this.process((InvocableMap.Entry)entry));
                } else {
                    entry.getValue();
                    if (entry.isPresent()) {
                        mapResults.put(((BinaryEntry)entry).getBinaryKey(), (Binary)this.process((InvocableMap.Entry)entry));
                    }
                }
                iter.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return mapResults;
        }
    }

    public static class BinaryPutProcessor
    extends BaseProcessor<Binary> {
        protected Binary m_binValue;
        protected long m_cTtl;

        public BinaryPutProcessor() {
        }

        BinaryPutProcessor(Binary value, long cTtl) {
            this.m_binValue = value;
            this.m_cTtl = cTtl;
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            BinaryEntry binaryEntry = (BinaryEntry)entry;
            Binary result = null;
            if (entry.isPresent()) {
                result = binaryEntry.getBinaryValue();
            }
            binaryEntry.updateBinaryValue(this.m_binValue);
            binaryEntry.expire(this.m_cTtl);
            return result;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_binValue = (Binary)ExternalizableHelper.readObject(in);
            this.m_cTtl = in.readLong();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_binValue);
            out.writeLong(this.m_cTtl);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_binValue = in.readBinary(0);
            this.m_cTtl = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeBinary(0, this.m_binValue);
            out.writeLong(1, this.m_cTtl);
        }

        protected Binary getValue() {
            return this.m_binValue;
        }

        protected long getTtl() {
            return this.m_cTtl;
        }
    }

    public static class BinaryBlindPutProcessor
    extends BaseProcessor<Binary> {
        protected Binary m_binValue;
        protected long m_cTtl;

        public BinaryBlindPutProcessor() {
        }

        BinaryBlindPutProcessor(Binary value, long cTtl) {
            this.m_binValue = value;
            this.m_cTtl = cTtl;
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            BinaryEntry binaryEntry = (BinaryEntry)entry;
            binaryEntry.updateBinaryValue(this.m_binValue);
            binaryEntry.expire(this.m_cTtl);
            return null;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_binValue = (Binary)ExternalizableHelper.readObject(in);
            this.m_cTtl = in.readLong();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_binValue);
            out.writeLong(this.m_cTtl);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_binValue = in.readBinary(0);
            this.m_cTtl = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeBinary(0, this.m_binValue);
            out.writeLong(1, this.m_cTtl);
        }

        protected Binary getValue() {
            return this.m_binValue;
        }

        protected long getTtl() {
            return this.m_cTtl;
        }
    }

    public static class BinaryPutAllProcessor
    extends BaseProcessor<Binary> {
        protected Map<Binary, Binary> m_map;

        public BinaryPutAllProcessor() {
            this(new HashMap<Binary, Binary>());
        }

        BinaryPutAllProcessor(Map<Binary, Binary> map) {
            this.m_map = map;
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            BinaryEntry binaryEntry = (BinaryEntry)entry;
            Binary binaryKey = binaryEntry.getBinaryKey();
            Binary binary = this.m_map.get(binaryKey);
            if (binary == null) {
                Binary binNoDeco = ExternalizableHelper.getUndecorated((ReadBuffer)binaryKey).toBinary();
                binary = this.m_map.get(binNoDeco);
            }
            if (binary == null) {
                entry.setValue(null);
            } else {
                binaryEntry.updateBinaryValue(binary);
            }
            return null;
        }

        @Override
        public Map<Binary, Binary> processAll(Set<? extends InvocableMap.Entry<Binary, Binary>> entries) {
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<? extends InvocableMap.Entry<Binary, Binary>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                InvocableMap.Entry<Binary, Binary> entry = iterator.next();
                this.process((InvocableMap.Entry)entry);
                iterator.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return new LiteMap<Binary, Binary>();
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            ExternalizableHelper.readMap(in, this.m_map, null);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeMap(out, this.m_map);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_map = in.readMap(0, new HashMap());
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeMap(0, this.m_map, Binary.class, Binary.class);
        }

        Map<Binary, Binary> getMap() {
            return this.m_map;
        }
    }

    public static class BinaryPutAllWithExpiryProcessor
    extends BaseProcessor<Binary> {
        protected Map<Binary, Binary> m_map;
        protected long m_cMillis;

        public BinaryPutAllWithExpiryProcessor() {
            this(new HashMap<Binary, Binary>(), 0L);
        }

        BinaryPutAllWithExpiryProcessor(Map<Binary, Binary> map, long cMillis) {
            this.m_map = map;
            this.m_cMillis = cMillis;
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            BinaryEntry binaryEntry = (BinaryEntry)entry;
            Binary binaryKey = binaryEntry.getBinaryKey();
            Binary binary = this.m_map.get(binaryKey);
            if (binary == null) {
                Binary binNoDeco = ExternalizableHelper.getUndecorated((ReadBuffer)binaryKey).toBinary();
                binary = this.m_map.get(binNoDeco);
            }
            if (binary == null) {
                entry.setValue(null);
            } else {
                binaryEntry.updateBinaryValue(binary);
            }
            binaryEntry.expire(this.m_cMillis);
            return null;
        }

        @Override
        public Map<Binary, Binary> processAll(Set<? extends InvocableMap.Entry<Binary, Binary>> entries) {
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<? extends InvocableMap.Entry<Binary, Binary>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                InvocableMap.Entry<Binary, Binary> entry = iterator.next();
                this.process((InvocableMap.Entry)entry);
                iterator.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return new LiteMap<Binary, Binary>();
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            ExternalizableHelper.readMap(in, this.m_map, null);
            this.m_cMillis = in.readLong();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeMap(out, this.m_map);
            out.writeLong(this.m_cMillis);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_map = in.readMap(0, new HashMap());
            this.m_cMillis = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeMap(0, this.m_map, Binary.class, Binary.class);
            out.writeLong(1, this.m_cMillis);
        }

        Map<Binary, Binary> getMap() {
            return this.m_map;
        }

        public long getExpiry() {
            return this.m_cMillis;
        }
    }

    public static class BinaryPutIfAbsentProcessor
    extends BinaryPutProcessor {
        public BinaryPutIfAbsentProcessor() {
        }

        BinaryPutIfAbsentProcessor(Binary value, long cTtl) {
            super(value, cTtl);
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            if (entry.isPresent()) {
                BinaryEntry<Binary, Binary> binaryEntry = entry.asBinaryEntry();
                Binary binNull = (Binary)binaryEntry.getContext().getValueToInternalConverter().convert(null);
                Binary binary = binaryEntry.getBinaryValue();
                if (!ExternalizableHelper.getUndecorated(binary).equals(binNull)) {
                    return binary;
                }
            }
            return super.process((InvocableMap.Entry)entry);
        }
    }

    public static class BinaryRemoveProcessor
    extends BaseProcessor<Binary> {
        public static final BinaryRemoveProcessor INSTANCE = new BinaryRemoveProcessor();

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            Binary prevValue = null;
            if (entry.isPresent()) {
                prevValue = ((BinaryEntry)entry).getBinaryValue();
                entry.remove(false);
            } else {
                entry.getValue();
                if (entry.isPresent()) {
                    prevValue = ((BinaryEntry)entry).getBinaryValue();
                    entry.remove(false);
                }
            }
            return prevValue;
        }
    }

    public static class BinaryReplaceMappingProcessor
    extends BinaryProcessorWithValue<Boolean> {
        protected Binary m_binNewValue;

        public BinaryReplaceMappingProcessor() {
        }

        public BinaryReplaceMappingProcessor(Binary previousValue, Binary newValue) {
            super(previousValue);
            this.m_binNewValue = newValue;
        }

        public static BinaryReplaceMappingProcessor create(Binary previousValue, Binary newValue) {
            return new BinaryReplaceMappingProcessor(previousValue, newValue);
        }

        @Override
        public Boolean process(InvocableMap.Entry<Binary, Binary> entry) {
            Binary prevValue;
            boolean result = false;
            if (entry.isPresent() && (prevValue = ((BinaryEntry)entry).getBinaryValue()).equals(this.getValue())) {
                ((BinaryEntry)entry).updateBinaryValue(this.m_binNewValue);
                result = true;
            }
            return result;
        }

        protected Binary getNewValue() {
            return this.m_binNewValue;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            super.readExternal(in);
            this.m_binNewValue = (Binary)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            super.writeExternal(out);
            ExternalizableHelper.writeObject(out, this.m_binNewValue);
        }

        @Override
        public void readExternal(PofReader pofReader) throws IOException {
            super.readExternal(pofReader);
            this.m_binNewValue = pofReader.readBinary(5);
        }

        @Override
        public void writeExternal(PofWriter pofWriter) throws IOException {
            super.writeExternal(pofWriter);
            pofWriter.writeBinary(5, this.m_binNewValue);
        }
    }

    public static class BinaryReplaceProcessor
    extends BinaryProcessorWithValue<Binary> {
        public BinaryReplaceProcessor() {
        }

        public BinaryReplaceProcessor(Binary value) {
            super(value);
        }

        @Override
        public Binary process(InvocableMap.Entry<Binary, Binary> entry) {
            Binary result = null;
            if (entry.isPresent()) {
                result = ((BinaryEntry)entry).getBinaryValue();
                ((BinaryEntry)entry).updateBinaryValue(this.getValue());
            }
            return result;
        }
    }

    public static class BinarySyntheticRemoveBlindProcessor
    extends BaseProcessor<Void> {
        public static final BinarySyntheticRemoveBlindProcessor INSTANCE = new BinarySyntheticRemoveBlindProcessor();

        @Override
        public Void process(InvocableMap.Entry<Binary, Binary> entry) {
            if (entry.isPresent()) {
                entry.remove(true);
            }
            return null;
        }

        @Override
        public Map<Binary, Void> processAll(Set<? extends InvocableMap.Entry<Binary, Binary>> entries) {
            Guardian.GuardContext ctxGuard = GuardSupport.getThreadContext();
            long cMillis = ctxGuard == null ? 0L : ctxGuard.getTimeoutMillis();
            Iterator<? extends InvocableMap.Entry<Binary, Binary>> iter = entries.iterator();
            while (iter.hasNext()) {
                InvocableMap.Entry<Binary, Binary> entry = iter.next();
                this.process((InvocableMap.Entry)entry);
                iter.remove();
                if (ctxGuard == null) continue;
                ctxGuard.heartbeat(cMillis);
            }
            return Collections.emptyMap();
        }
    }

    public static class BinaryContainsValueProcessor
    extends BinaryProcessorWithValue<Boolean> {
        public BinaryContainsValueProcessor() {
        }

        public BinaryContainsValueProcessor(Binary value) {
            super(value);
        }

        @Override
        public Boolean process(InvocableMap.Entry<Binary, Binary> entry) {
            if (entry.isPresent()) {
                Binary bin = ((BinaryEntry)entry).getBinaryValue();
                ReadBuffer buffer = ExternalizableHelper.getUndecorated((ReadBuffer)bin);
                return this.getValue().equals(buffer.toBinary());
            }
            return false;
        }
    }

    public static abstract class BinaryProcessorWithValue<T>
    extends BaseProcessor<T> {
        protected Binary m_binValue;

        protected BinaryProcessorWithValue() {
        }

        protected BinaryProcessorWithValue(Binary value) {
            this.m_binValue = value;
        }

        protected Binary getValue() {
            return this.m_binValue;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_binValue = (Binary)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_binValue);
        }

        @Override
        public void readExternal(PofReader pofReader) throws IOException {
            this.m_binValue = pofReader.readBinary(2);
        }

        @Override
        public void writeExternal(PofWriter pofWriter) throws IOException {
            pofWriter.writeBinary(2, this.m_binValue);
        }
    }

    public static abstract class BaseProcessor<R>
    implements InvocableMap.EntryProcessor<Binary, Binary, R>,
    ExternalizableLite,
    PortableObject {
        @Override
        public void readExternal(DataInput dataInput) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput dataOutput) throws IOException {
        }

        @Override
        public void readExternal(PofReader pofReader) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter pofWriter) throws IOException {
        }
    }
}

