/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.listener;

import com.tangosol.net.NamedMap;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.partition.DefaultVersionedPartitions;
import com.tangosol.net.partition.VersionAwareMapListener;
import com.tangosol.net.partition.VersionedPartitions;
import com.tangosol.util.Base;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.SparseArray;
import java.util.function.Consumer;

public class VersionAwareListeners {
    public static <K, V> MapListener<K, V> createListener(MapListener<K, V> listener) {
        return VersionAwareListeners.createListener(listener, (DefaultVersionedPartitions)null);
    }

    public static <K, V> MapListener<K, V> createListener(MapListener<K, V> listener, long lVersion, K key, NamedMap<K, V> cache) {
        PartitionedService service = (PartitionedService)((Object)cache.getService());
        int iPart = service.getKeyPartitioningStrategy().getKeyPartition(key);
        return VersionAwareListeners.createListener(listener, lVersion, iPart);
    }

    public static <K, V> MapListener<K, V> createListener(MapListener<K, V> listener, long lVersion, int iPart) {
        DefaultVersionedPartitions versions = new DefaultVersionedPartitions();
        versions.setPartitionVersion(iPart, lVersion);
        return VersionAwareListeners.createListener(listener, versions);
    }

    public static <K, V> MapListener<K, V> createListener(MapListener<K, V> listener, PrimitiveSparseArray laVersions) {
        DefaultVersionedPartitions versions = new DefaultVersionedPartitions();
        PrimitiveSparseArray.Iterator iter = laVersions.iterator();
        while (iter.hasNext()) {
            long lVersion = iter.nextPrimitive();
            versions.setPartitionVersion((int)iter.getIndex(), lVersion);
        }
        return VersionAwareListeners.createListener(listener, versions);
    }

    public static <K, V> MapListener<K, V> createListener(MapListener<K, V> listener, DefaultVersionedPartitions versions) {
        if ((!listener.isVersionAware() || listener instanceof VersionAwareMapListener) && versions == null) {
            return listener;
        }
        return listener.isSynchronous() || listener instanceof MapListenerSupport.SynchronousListener ? new DefaultVersionedSynchronousListener<K, V>(listener, versions) : new DefaultVersionedListener<K, V>(listener, versions);
    }

    public static class DefaultVersionedSynchronousListener<K, V>
    extends DefaultVersionedListener<K, V>
    implements MapListenerSupport.SynchronousListener<K, V> {
        protected DefaultVersionedSynchronousListener(MapListener<K, V> listener, DefaultVersionedPartitions versions) {
            super(listener, versions);
        }

        @Override
        public int characteristics() {
            return 3;
        }
    }

    public static class DefaultVersionedListener<K, V>
    extends MapListenerSupport.WrapperListener<K, V>
    implements VersionAwareMapListener<K, V> {
        protected static final int SHIFT_PARTITION = 40;
        protected static final int SHIFT_VERSION = 0;
        protected static final long MASK_VERSION = 0xFFFFFFFFFFL;
        protected static final int GAP_THRESHOLD = 65535;
        protected final DefaultVersionedPartitions f_partVersions;
        protected final LongArray f_laProcessedEvents = new SparseArray();

        protected DefaultVersionedListener(MapListener<K, V> listener) {
            this(listener, null);
        }

        protected DefaultVersionedListener(MapListener<K, V> listener, DefaultVersionedPartitions versions) {
            super(listener);
            this.f_partVersions = versions == null ? new DefaultVersionedPartitions() : versions;
        }

        @Override
        public void entryInserted(MapEvent<K, V> evt) {
            this.process(evt, this.f_listener::entryInserted);
        }

        @Override
        public void entryUpdated(MapEvent<K, V> evt) {
            this.process(evt, this.f_listener::entryUpdated);
        }

        @Override
        public void entryDeleted(MapEvent<K, V> evt) {
            this.process(evt, this.f_listener::entryDeleted);
        }

        @Override
        public int characteristics() {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentVersion() {
            DefaultVersionedPartitions defaultVersionedPartitions = this.f_partVersions;
            synchronized (defaultVersionedPartitions) {
                return VersionAwareMapListener.super.getCurrentVersion();
            }
        }

        @Override
        public VersionedPartitions getVersions() {
            return this.f_partVersions;
        }

        @Override
        public boolean equals(Object oThat) {
            if (oThat == null || !((MapListener)oThat).isVersionAware()) {
                return false;
            }
            return Base.equals(this.f_listener, MapListenerSupport.unwrap((MapListener)oThat));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(MapEvent<K, V> event, Consumer<MapEvent<K, V>> delegate) {
            long lEventVersion = event.getVersion();
            int iPart = event.getPartition();
            long lExpectedVersion = this.getCurrentVersion(iPart);
            if (lExpectedVersion <= 0L) {
                lExpectedVersion = lEventVersion;
            }
            long lPartVersion = DefaultVersionedListener.encodePartitionVersion(iPart, lEventVersion);
            if (lEventVersion >= lExpectedVersion && !this.f_laProcessedEvents.exists(lPartVersion)) {
                boolean fExpected;
                try {
                    if (!(event instanceof CacheEvent) || !((CacheEvent)event).isVersionUpdate()) {
                        delegate.accept(event);
                    }
                    boolean bl = fExpected = lEventVersion == lExpectedVersion;
                }
                catch (Throwable throwable) {
                    boolean fExpected2;
                    boolean bl = fExpected2 = lEventVersion == lExpectedVersion;
                    if (fExpected2) {
                        this.removeProcessed(iPart, lEventVersion);
                    } else {
                        LongArray longArray = this.f_laProcessedEvents;
                        synchronized (longArray) {
                            this.f_laProcessedEvents.set(lPartVersion, null);
                        }
                        if (lEventVersion - lExpectedVersion > 65535L) {
                            int cProcessed = 0;
                            long lNextPart = DefaultVersionedListener.encodePartitionVersion(iPart + 1, 0L);
                            LongArray.Iterator iter = this.f_laProcessedEvents.iterator(DefaultVersionedListener.encodePartitionVersion(iPart, 0L));
                            while (iter.hasNext()) {
                                iter.next();
                                if (iter.getIndex() >= lNextPart) break;
                                ++cProcessed;
                            }
                            if (cProcessed >= 65535) {
                                this.removeProcessed(iPart, lExpectedVersion);
                            }
                        }
                    }
                    throw throwable;
                }
                if (fExpected) {
                    this.removeProcessed(iPart, lEventVersion);
                } else {
                    LongArray longArray = this.f_laProcessedEvents;
                    synchronized (longArray) {
                        this.f_laProcessedEvents.set(lPartVersion, null);
                    }
                    if (lEventVersion - lExpectedVersion > 65535L) {
                        int cProcessed = 0;
                        long lNextPart = DefaultVersionedListener.encodePartitionVersion(iPart + 1, 0L);
                        LongArray.Iterator iter = this.f_laProcessedEvents.iterator(DefaultVersionedListener.encodePartitionVersion(iPart, 0L));
                        while (iter.hasNext()) {
                            iter.next();
                            if (iter.getIndex() >= lNextPart) break;
                            ++cProcessed;
                        }
                        if (cProcessed >= 65535) {
                            this.removeProcessed(iPart, lExpectedVersion);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeProcessed(int iPart, long lEventVersion) {
            long lExpectedVersion;
            long l = lExpectedVersion = lEventVersion >= 0L ? lEventVersion + 1L : lEventVersion;
            if (lExpectedVersion > 0L) {
                long lExpectedPartVersion = DefaultVersionedListener.encodePartitionVersion(iPart, lExpectedVersion);
                LongArray longArray = this.f_laProcessedEvents;
                synchronized (longArray) {
                    long lMinPartVersion = this.f_laProcessedEvents.ceilingIndex(DefaultVersionedListener.encodePartitionVersion(iPart, 0L));
                    boolean fWrap = lMinPartVersion < lExpectedPartVersion;
                    LongArray.Iterator iter = this.f_laProcessedEvents.iterator(lExpectedPartVersion);
                    while (iter.hasNext()) {
                        boolean fPartsMatch;
                        iter.next();
                        long lPartVersion = iter.getIndex();
                        boolean bl = fPartsMatch = DefaultVersionedListener.decodePartition(lPartVersion) == iPart;
                        if (lPartVersion != lExpectedPartVersion || !fPartsMatch) {
                            if (!fWrap || fPartsMatch) break;
                            iter = this.f_laProcessedEvents.iterator(lMinPartVersion);
                            lExpectedPartVersion = lMinPartVersion;
                            fWrap = false;
                        }
                        iter.remove();
                        ++lExpectedPartVersion;
                        ++lExpectedVersion;
                    }
                }
            }
            this.setCurrentVersion(iPart, lExpectedVersion);
        }

        private long getCurrentVersion(long lPart) {
            return this.f_partVersions.getVersion((int)lPart);
        }

        private void setCurrentVersion(long lPart, long lVersion) {
            this.f_partVersions.setPartitionVersion((int)lPart, lVersion);
        }

        protected static long encodePartitionVersion(int iPart, long lVersion) {
            return (long)iPart << 40 | lVersion & 0xFFFFFFFFFFL;
        }

        protected static int decodePartition(long lPartVersion) {
            return (int)(lPartVersion >> 40);
        }

        protected static long decodeVersion(long lPartVersion) {
            return lPartVersion & 0xFFFFFFFFFFL;
        }
    }
}

