/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke.lambda;

import com.tangosol.dev.assembler.Method;
import com.tangosol.internal.util.invoke.lambda.LambdaIdentity;
import com.tangosol.util.Base;
import java.lang.invoke.SerializedLambda;

public class MethodReferenceIdentity
extends LambdaIdentity {
    private static final String METHOD_REF_FORMAT = "%s.%s:%s";

    public MethodReferenceIdentity() {
    }

    public MethodReferenceIdentity(SerializedLambda lambdaMetadata, ClassLoader loader) {
        super(MethodReferenceIdentity.getInvokeClass(lambdaMetadata), lambdaMetadata.getImplMethodName(), MethodReferenceIdentity.createVersion(lambdaMetadata));
    }

    private static String getInvokeClass(SerializedLambda lambdaMetadata) {
        int nInvokeKind = lambdaMetadata.getImplMethodKind();
        switch (nInvokeKind) {
            case 5: 
            case 9: {
                String sDestType = Method.toTypes(lambdaMetadata.getInstantiatedMethodType())[1];
                return sDestType.charAt(0) == 'L' ? sDestType.substring(1, sDestType.length() - 1) : sDestType;
            }
        }
        return lambdaMetadata.getImplClass();
    }

    private static String createVersion(SerializedLambda lambdaMetadata) {
        String sReferredMethod = String.format(METHOD_REF_FORMAT, MethodReferenceIdentity.getInvokeClass(lambdaMetadata), lambdaMetadata.getImplMethodName(), lambdaMetadata.getImplMethodSignature());
        String sSAMImpl = String.format(METHOD_REF_FORMAT, lambdaMetadata.getFunctionalInterfaceClass(), lambdaMetadata.getFunctionalInterfaceMethodName(), lambdaMetadata.getFunctionalInterfaceMethodSignature());
        return Base.toHex(MethodReferenceIdentity.md5(sReferredMethod + "$" + sSAMImpl));
    }
}

