/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke.lambda;

import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LambdaIdentity
extends ClassIdentity {
    @JsonbProperty(value="implClass")
    protected String m_sImplClass;
    @JsonbProperty(value="implMethod")
    protected String m_sImplMethod;

    public LambdaIdentity() {
    }

    public LambdaIdentity(String sImplClass, String sImplMethod, String sVersion) {
        super(null, null, sVersion);
        this.m_sImplClass = sImplClass;
        this.m_sImplMethod = sImplMethod;
        this.m_sVersion = sVersion;
    }

    @Override
    public String getPackage() {
        int nIndex = this.m_sImplClass.lastIndexOf(47);
        String sPackage = nIndex > -1 ? this.m_sImplClass.substring(0, nIndex) : "";
        return (sPackage.startsWith("java/") ? "lambda/" : "") + sPackage;
    }

    @Override
    public String getBaseName() {
        int nIndex = this.m_sImplClass.lastIndexOf(47);
        String sBaseName = nIndex > -1 ? this.m_sImplClass.substring(nIndex + 1) : this.m_sImplClass;
        return sBaseName + "$" + this.m_sImplMethod;
    }

    public String getImplClass() {
        return this.m_sImplClass;
    }

    public String getImplMethod() {
        return this.m_sImplMethod;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LambdaIdentity) {
            LambdaIdentity that = (LambdaIdentity)o;
            return this == that || this.getClass() == that.getClass() && Base.equals(this.m_sImplClass, that.m_sImplClass) && Base.equals(this.m_sImplMethod, that.m_sImplMethod) && Base.equals(this.m_sVersion, that.m_sVersion);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int nHash = this.m_sImplClass.hashCode();
        nHash = 31 * nHash + this.m_sImplMethod.hashCode();
        nHash = 31 * nHash + this.m_sVersion.hashCode();
        return nHash;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{implClass='" + this.m_sImplClass + "', implMethod='" + this.m_sImplMethod + "', version='" + this.m_sVersion + "'}";
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sImplClass = ExternalizableHelper.readSafeUTF(in);
        this.m_sImplMethod = ExternalizableHelper.readSafeUTF(in);
        this.m_sVersion = ExternalizableHelper.readSafeUTF(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sImplClass);
        ExternalizableHelper.writeSafeUTF(out, this.m_sImplMethod);
        ExternalizableHelper.writeSafeUTF(out, this.m_sVersion);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sImplClass = in.readString(0);
        this.m_sImplMethod = in.readString(1);
        this.m_sVersion = in.readString(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sImplClass);
        out.writeString(1, this.m_sImplMethod);
        out.writeString(2, this.m_sVersion);
    }
}

