/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.dev.assembler.Field;
import com.tangosol.internal.asm.ClassReaderInternal;
import com.tangosol.internal.asm.ClassWriter;
import com.tangosol.internal.asm.MethodVisitor;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.commons.ClassRemapper;
import com.tangosol.internal.asm.commons.SimpleRemapper;

public class RemotableClassGenerator {
    private static final String OBJECT_NAME = Type.getType(Object.class).getInternalName();

    public static byte[] createRemoteClass(String sClassNameOld, String sClassNameNew, byte[] abClass) {
        ClassWriter writer = new ClassWriter(1);
        ClassRemapper remapper = new ClassRemapper(writer, new SimpleRemapper(sClassNameOld, sClassNameNew));
        new ClassReaderInternal(abClass).accept(remapper, 8);
        return writer.toByteArray();
    }

    protected static void coerceType(MethodVisitor mv, String sTypeSrc, String sTypeDest) {
        boolean fDestArray;
        if (sTypeSrc.equals(sTypeDest) || "V".equals(sTypeSrc) || "V".equals(sTypeDest)) {
            return;
        }
        char chSrc = sTypeSrc.charAt(0);
        char chDest = sTypeDest.charAt(0);
        boolean fSrcArray = chSrc == '[';
        boolean bl = fDestArray = chDest == '[';
        if (chSrc == 'L' && chDest == 'L' || fSrcArray || fDestArray) {
            String string = sTypeDest = fDestArray ? sTypeDest : sTypeDest.substring(1, sTypeDest.length() - 1);
            if (sTypeSrc.contains(OBJECT_NAME) && fDestArray || !OBJECT_NAME.equals(sTypeDest)) {
                mv.visitTypeInsn(192, sTypeDest);
            }
        } else if (chSrc == 'L') {
            String sRef = sTypeSrc.substring(1, sTypeSrc.length() - 1);
            if (!sRef.startsWith("java/lang") || OBJECT_NAME.equals(sRef)) {
                sRef = chDest == 'C' ? "java/lang/Character" : "java/lang/Number";
                mv.visitTypeInsn(192, sRef);
            }
            char chIntermediate = chDest;
            switch (sRef) {
                case "java/lang/Character": {
                    chIntermediate = 'C';
                    break;
                }
                case "java/lang/Boolean": {
                    chDest = 'Z';
                    chIntermediate = 'Z';
                }
            }
            mv.visitMethodInsn(182, sRef, Field.toTypeString(String.valueOf(chIntermediate)) + "Value", "()" + chIntermediate, false);
            if (chIntermediate != chDest) {
                RemotableClassGenerator.coercePrimitive(mv, chIntermediate, chDest);
            }
        } else if (chDest == 'L') {
            String sRef = sTypeDest.substring(1, sTypeDest.length() - 1);
            String sBox = sRef;
            char chBox = Field.fromBoxedType(sBox);
            if (chBox == '\u0000') {
                chBox = chSrc;
                sBox = Field.toBoxedType(sTypeSrc);
            } else {
                RemotableClassGenerator.coercePrimitive(mv, chSrc, chBox);
            }
            mv.visitMethodInsn(184, sBox, "valueOf", "(" + chBox + ")L" + sBox + ";", false);
            if (sBox != sRef) {
                mv.visitTypeInsn(192, sRef);
            }
        } else {
            RemotableClassGenerator.coercePrimitive(mv, chSrc, chDest);
        }
    }

    private static void coercePrimitive(MethodVisitor mv, char chSrc, char chDest) {
        int opCode;
        if (chSrc == chDest) {
            return;
        }
        int ofSrc = RemotableClassGenerator.getTypeOffset(chSrc);
        int ofDest = RemotableClassGenerator.getTypeOffset(chDest);
        if (ofSrc != 0 || ofDest != 0) {
            opCode = 133 + ofSrc * 3 + (ofDest + (ofSrc < ofDest ? -1 : 0));
            mv.visitInsn(opCode);
        }
        opCode = 144;
        switch (chDest) {
            case 'S': {
                ++opCode;
            }
            case 'C': {
                ++opCode;
            }
            case 'B': {
                mv.visitInsn(++opCode);
            }
        }
    }

    protected static int getLoadOpcode(String sType) {
        return 21 + RemotableClassGenerator.getTypeOffset(sType.charAt(0));
    }

    protected static int getReturnOpcode(String sType) {
        char chOp = sType.charAt(0);
        return chOp == 'V' ? 177 : 172 + RemotableClassGenerator.getTypeOffset(sType.charAt(0));
    }

    private static int getTypeOffset(char chOp) {
        switch (chOp) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
        }
        return 4;
    }

    protected static int toInvokeOp(int nMethodKind) {
        switch (nMethodKind) {
            case 6: {
                return 184;
            }
            case 8: {
                return 183;
            }
            case 5: {
                return 182;
            }
            case 9: {
                return 185;
            }
            case 7: {
                return 183;
            }
        }
        throw new IllegalStateException("Unexpected method invocation kind: " + nMethodKind);
    }
}

