/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.internal.util.CanonicalNames;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.invoke.ClassDefinition;
import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.RemotableSupport;
import com.tangosol.internal.util.invoke.lambda.AbstractRemotableLambda;
import com.tangosol.internal.util.invoke.lambda.AnonymousLambdaIdentity;
import com.tangosol.internal.util.invoke.lambda.LambdaIdentity;
import com.tangosol.internal.util.invoke.lambda.MethodReferenceIdentity;
import com.tangosol.internal.util.invoke.lambda.RemotableLambdaGenerator;
import com.tangosol.internal.util.invoke.lambda.StaticLambdaInfo;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.extractor.ReflectionExtractor;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Lambdas {
    private static final String DUMP_LAMBDAS = Config.getProperty("coherence.remotable.dumpLambdas", Config.getProperty("coherence.remotable.dumpAll"));
    public static final String LAMBDAS_SERIALIZATION_MODE_PROPERTY = "coherence.lambdas";
    private static volatile SerializationMode LAMBDAS_SERIALIZATION_MODE = null;
    private static final Set<String> EXTRACTOR_INTERFACES;
    private static final String LAMBDA_CLASS_MARKER = "$$Lambda";
    private static final int LAMBDA_CLASS_END_MARKER;

    public static boolean isLambda(Object o) {
        return o != null && Lambdas.isLambdaClass(o.getClass());
    }

    public static boolean isLambdaClass(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        String sName = clz.getName();
        int nIdx = sName.indexOf(LAMBDA_CLASS_MARKER);
        if (nIdx != -1) {
            int nOffset = nIdx + LAMBDA_CLASS_END_MARKER;
            if (nOffset > sName.length()) {
                return false;
            }
            char c = sName.charAt(nOffset);
            return c == '$' || c == '/';
        }
        return false;
    }

    public static SerializedLambda getSerializedLambda(Object oLambda) {
        if (!Lambdas.isLambda(oLambda) || !(oLambda instanceof Serializable)) {
            throw new IllegalArgumentException("Specified object is not an instance of a serializable lambda");
        }
        try {
            Class<?> clzLambda = oLambda.getClass();
            Method method = clzLambda.getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            return (SerializedLambda)method.invoke(oLambda, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to extract SerializedLambda from lambda: " + String.valueOf(oLambda), e);
        }
    }

    public static boolean isLambdaMethod(String sMethodName) {
        return sMethodName.startsWith("lambda$");
    }

    public static boolean isMethodReference(SerializedLambda lambda) {
        return lambda.getImplMethodKind() == 8 || !Lambdas.isLambdaMethod(lambda.getImplMethodName()) && lambda.getCapturedArgCount() == 0;
    }

    public static ClassDefinition createDefinition(ClassIdentity id, Serializable lambda, ClassLoader loader) {
        SerializedLambda lambdaMetadata = Lambdas.getSerializedLambda(lambda);
        if (lambdaMetadata.getImplMethodKind() == 6 || Lambdas.isMethodReference(lambdaMetadata)) {
            ClassDefinition definition = new ClassDefinition(id, RemotableLambdaGenerator.createRemoteLambdaClass(id.getName(), lambdaMetadata, loader));
            definition.dumpClass(DUMP_LAMBDAS);
            return definition;
        }
        throw new IllegalArgumentException("The specified lambda is referring to the enclosing class instance or its fields and therefore cannot be marshalled across network boundaries (" + String.valueOf(lambdaMetadata) + ")");
    }

    public static LambdaIdentity createIdentity(SerializedLambda lambdaMetadata, ClassLoader loader) {
        return Lambdas.isMethodReference(lambdaMetadata) ? new MethodReferenceIdentity(lambdaMetadata, loader) : new AnonymousLambdaIdentity(lambdaMetadata, loader);
    }

    public static Object[] getCapturedArguments(SerializedLambda lambdaMetadata) {
        int c = lambdaMetadata.getCapturedArgCount();
        Object[] aoArgs = new Object[c];
        for (int i = 0; i < c; ++i) {
            aoArgs[i] = lambdaMetadata.getCapturedArg(i);
        }
        return aoArgs;
    }

    public static <T extends Serializable> T ensureRemotable(T function) {
        if (function instanceof ReflectionExtractor || function instanceof AbstractRemotableLambda || !Lambdas.isLambda(function)) {
            return function;
        }
        SerializedLambda serializedLambda = Lambdas.getSerializedLambda(function);
        if (Lambdas.isMethodReference(serializedLambda) && serializedLambda.getImplMethodKind() == 5 && EXTRACTOR_INTERFACES.contains(serializedLambda.getFunctionalInterfaceClass())) {
            return (T)new ReflectionExtractor(serializedLambda.getImplMethodName());
        }
        if (Lambdas.isStaticLambdas()) {
            return function;
        }
        RemotableSupport support = RemotableSupport.get(function.getClass().getClassLoader());
        return support.realize(support.createRemoteConstructor(function));
    }

    public static Object ensureSerializable(Object oFunction) {
        return Lambdas.isLambda(oFunction) ? (Lambdas.isDynamicLambdas() ? Lambdas.ensureRemotable((Serializable)oFunction) : new StaticLambdaInfo<Object>(oFunction.getClass(), oFunction)) : oFunction;
    }

    public static String getValueExtractorCanonicalName(Object oLambda) {
        if (oLambda instanceof AbstractRemotableLambda) {
            return ((AbstractRemotableLambda)oLambda).getCanonicalName();
        }
        SerializedLambda lambda = Lambdas.getSerializedLambda(oLambda);
        if (Lambdas.isMethodReference(lambda)) {
            MethodReferenceIdentity id = new MethodReferenceIdentity(lambda, null);
            return CanonicalNames.computeValueExtractorCanonicalName(id.getImplMethod() + "()", null);
        }
        return null;
    }

    public static boolean isDynamicLambdas() {
        return Lambdas.ensureSerializationMode() == SerializationMode.DYNAMIC;
    }

    public static boolean isStaticLambdas() {
        return Lambdas.ensureSerializationMode() == SerializationMode.STATIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static SerializationMode ensureSerializationMode() {
        String sLambda = ExternalizableHelper.LAMBDA_SERIALIZATION;
        SerializationMode mode = null;
        String sMsg = null;
        if (LAMBDAS_SERIALIZATION_MODE != null) return LAMBDAS_SERIALIZATION_MODE;
        String string = LAMBDAS_SERIALIZATION_MODE_PROPERTY;
        synchronized (LAMBDAS_SERIALIZATION_MODE_PROPERTY) {
            if (LAMBDAS_SERIALIZATION_MODE != null) return LAMBDAS_SERIALIZATION_MODE;
            try {
                if (!sLambda.isEmpty()) {
                    mode = SerializationMode.valueOf(sLambda.toUpperCase());
                }
            }
            catch (IllegalArgumentException e) {
                sMsg = "System property \"coherence.lambdas\" or ExternalizableHelper.xml config element \"lambdas-serialization\" is set to invalid value of \"" + sLambda + "\"; valid values are: \"static\" or \"dynamic\". ";
            }
            if (mode == null) {
                String sLambdaSerializationMode = CacheFactory.getClusterConfig().getSafeElement("lambdas-serialization").getString();
                try {
                    if (!sLambdaSerializationMode.isEmpty()) {
                        mode = SerializationMode.valueOf(sLambdaSerializationMode.toUpperCase());
                    }
                }
                catch (IllegalArgumentException e) {
                    sMsg = "Operational config element cluster-config's child element \"lambdas-serialization\" is set to invalid value of \"" + sLambdaSerializationMode + "\"; valid values are: \"static\" or \"dynamic\". ";
                }
            }
            if (mode == null) {
                mode = SerializationMode.DYNAMIC;
                if (sMsg != null) {
                    Logger.err(sMsg + "Reverting to default lambdas serialization mode of " + String.valueOf((Object)mode) + ".");
                }
            }
            LAMBDAS_SERIALIZATION_MODE = mode;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return LAMBDAS_SERIALIZATION_MODE;
        }
    }

    static {
        LAMBDA_CLASS_END_MARKER = LAMBDA_CLASS_MARKER.length();
        EXTRACTOR_INTERFACES = Stream.of("com/tangosol/util/ValueExtractor", "com/tangosol/util/function/Remote$Function", "com/tangosol/util/function/Remote$ToIntFunction", "com/tangosol/util/function/Remote$ToLongFunction", "com/tangosol/util/function/Remote$ToDoubleFunction").collect(Collectors.toSet());
    }

    public static enum SerializationMode {
        DYNAMIC,
        STATIC;

    }
}

