/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal;

import com.tangosol.internal.util.graal.ScriptHandler;
import com.tangosol.util.ScriptException;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Value;

public class ScriptManager {
    private static final ScriptManager INSTANCE = new ScriptManager();
    private final Context f_context;
    private final ConcurrentMap<String, ScriptHandler> f_handlers = new ConcurrentHashMap<String, ScriptHandler>();

    private ScriptManager() {
        for (ScriptHandler handler : ServiceLoader.load(ScriptHandler.class)) {
            this.f_handlers.put(handler.getLanguage(), handler);
        }
        Context.Builder builder = Context.newBuilder((String[])new String[0]).allowAllAccess(true).allowHostAccess(HostAccess.ALL).allowPolyglotAccess(PolyglotAccess.ALL).allowExperimentalOptions(true);
        for (ScriptHandler handler : this.f_handlers.values()) {
            handler.configure(builder);
        }
        this.f_context = builder.build();
        for (ScriptHandler handler : this.f_handlers.values()) {
            handler.init(this.f_context);
        }
    }

    public Context getContext() {
        return this.f_context;
    }

    public Collection<String> getSupportedLanguages() {
        return this.f_handlers.values().stream().map(ScriptHandler::getLanguage).collect(Collectors.toCollection(HashSet::new));
    }

    public Value execute(String sLanguage, String sName, Object ... aoArgs) {
        try {
            Value value = this.f_context.getBindings(sLanguage).getMember(sName);
            if (value == null) {
                throw new ScriptException("Value '" + sName + "' is not bound to the context");
            }
            if (value.canInstantiate()) {
                value = value.newInstance(aoArgs);
            } else if (value.canExecute()) {
                value = value.execute(aoArgs);
            }
            return value;
        }
        catch (Throwable e) {
            throw new ScriptException("error ", e);
        }
    }

    public ScriptHandler getHandler(String sLanguage) {
        ScriptHandler handler = (ScriptHandler)this.f_handlers.get(sLanguage);
        if (handler != null) {
            return handler;
        }
        throw new IllegalArgumentException("Unknown language: " + sLanguage);
    }

    public static ScriptManager getInstance() {
        return INSTANCE;
    }
}

