/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.classgraph.ClassGraph;
import com.tangosol.internal.classgraph.Resource;
import com.tangosol.internal.classgraph.ResourceList;
import com.tangosol.internal.classgraph.ScanResult;
import com.tangosol.internal.util.graal.ScriptHandler;
import com.tangosol.util.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public abstract class AbstractScriptHandler
implements ScriptHandler {
    @Override
    public void init(Context context) {
        String sCurrentScript = null;
        try (ScanResult scanResult = new ClassGraph().acceptPathsNonRecursive(this.getScriptRoot()).scan();){
            ResourceList scripts = scanResult.getResourcesWithExtension(this.getScriptExtension());
            for (Resource script : scripts) {
                sCurrentScript = script.getPathRelativeToClasspathElement();
                Logger.config("Loading script %s".formatted(sCurrentScript));
                Source source = Source.newBuilder((String)this.getLanguage(), (CharSequence)script.getContentAsString(), (String)sCurrentScript).build();
                Value exports = context.eval(source);
                if (exports == null) continue;
                for (String key : exports.getMemberKeys()) {
                    context.getBindings(this.getLanguage()).putMember(key, (Object)exports.getMember(key));
                }
            }
        }
        catch (Throwable e) {
            throw new ScriptException("Failed to load script " + sCurrentScript, e);
        }
    }

    protected abstract String getScriptExtension();

    protected abstract String getScriptRoot();
}

