/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.extractor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.CopyOnWriteMap;
import com.tangosol.util.Filter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectionAllowedFilter
implements Filter<Class<?>> {
    public static final String REFLECT_ALLOW_ALL = "*";
    public static final String REFLECT_FILTER_PROPERTY = "coherence.reflect.filter";
    public static final String REFLECT_FILTER_SEPARATOR = ";";
    public static final String DEFAULT_REFLECT_ALLOWED_BLACKLIST = "!java.lang.Class;!java.lang.System;!java.lang.Runtime";
    public static final String DEFAULT_FILTER_LIST = "!java.lang.Class;!java.lang.System;!java.lang.Runtime;*";
    private static final Pattern PATTERN_INVALID_CHARS = Pattern.compile("[^A-Za-z0-9\\.;!*$]");
    public static final ReflectionAllowedFilter INSTANCE = ReflectionAllowedFilter.ensureSafeFilter(Config.getProperty("coherence.reflect.filter", "!java.lang.Class;!java.lang.System;!java.lang.Runtime;*"));
    private final String f_sPatterns;
    private final List<AbstractReflectionAllowedFilter> f_listFilter;
    private final Map<Class, Status> f_mapClassStatus = new CopyOnWriteMap<Class, Status>(new WeakHashMap());
    private final boolean f_fDisabled;

    protected ReflectionAllowedFilter(String sPatterns) {
        Objects.requireNonNull(sPatterns, "sPatterns");
        this.validate(sPatterns);
        this.f_sPatterns = sPatterns;
        this.f_fDisabled = REFLECT_ALLOW_ALL.equals(this.f_sPatterns);
        String[] asPatterns = this.f_sPatterns.split(REFLECT_FILTER_SEPARATOR);
        this.f_listFilter = new ArrayList<AbstractReflectionAllowedFilter>(asPatterns.length);
        for (String sPattern : asPatterns) {
            if (sPattern == null || sPattern.length() <= 0) continue;
            this.f_listFilter.add(this.createPatternFilter(sPattern));
        }
        if (this.f_listFilter.isEmpty()) {
            throw new IllegalArgumentException("parameter sPatterns must contain at least one valid pattern");
        }
    }

    @Override
    public boolean evaluate(Class<?> clz) {
        if (this.f_fDisabled) {
            return true;
        }
        Status status = this.f_mapClassStatus.get(clz);
        if (status == null) {
            AbstractReflectionAllowedFilter filter;
            Iterator<AbstractReflectionAllowedFilter> iterator = this.f_listFilter.iterator();
            while (iterator.hasNext() && (status = (filter = iterator.next()).process(clz)) == Status.UNDECIDED) {
            }
            this.f_mapClassStatus.put(clz, status);
        }
        return status != Status.REJECTED;
    }

    public static ReflectionAllowedFilter ensureSafeFilter(String sPattern) {
        try {
            return ReflectionAllowedFilter.ensureFilter(sPattern);
        }
        catch (Throwable t) {
            Logger.warn("Detected invalid pattern " + t.getMessage() + " for system property \"coherence.reflect.filter\"=\"" + sPattern + "\"; using default pattern: \"!java.lang.Class;!java.lang.System;!java.lang.Runtime;*\"");
            return ReflectionAllowedFilter.ensureFilter(DEFAULT_FILTER_LIST);
        }
    }

    public static ReflectionAllowedFilter ensureFilter(String sPattern) {
        return new ReflectionAllowedFilter(sPattern);
    }

    private void validate(String sPatterns) {
        Matcher match = PATTERN_INVALID_CHARS.matcher(sPatterns);
        boolean fInvalid = match.find();
        if (fInvalid) {
            throw new IllegalArgumentException("containing invalid character \"" + sPatterns.charAt(match.start()) + "\" at offset " + match.start());
        }
    }

    protected AbstractReflectionAllowedFilter createPatternFilter(String sPattern) {
        int ofPattern;
        int cPattern = sPattern.length();
        boolean fReject = sPattern.charAt(0) == '!';
        int n = ofPattern = fReject ? 1 : 0;
        if (sPattern.endsWith(REFLECT_ALLOW_ALL)) {
            if (sPattern.endsWith(".*")) {
                String sPkg = sPattern.substring(ofPattern, cPattern - 2);
                if (sPkg.isEmpty()) {
                    throw new IllegalArgumentException("package missing in: \"" + this.f_sPatterns + "\"");
                }
                return new ClassInPackageFilter(sPkg, fReject ? Status.REJECTED : Status.ALLOWED);
            }
            if (sPattern.endsWith(".**")) {
                String sPkgs = sPattern.substring(ofPattern, cPattern - 2);
                if (sPkgs.length() < 2) {
                    throw new IllegalArgumentException("package missing in: \"" + this.f_sPatterns + "\"");
                }
                return new ClassStartsWithFilter(sPkgs, fReject ? Status.REJECTED : Status.ALLOWED);
            }
            String sClassName = sPattern.substring(ofPattern, cPattern - 1);
            return new ClassStartsWithFilter(sClassName, fReject ? Status.REJECTED : Status.ALLOWED);
        }
        String sName = sPattern.substring(ofPattern);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("class or package missing in: \"" + this.f_sPatterns + "\"");
        }
        return new ClassFilter(sName, fReject ? Status.REJECTED : Status.ALLOWED);
    }

    public String toString() {
        return this.f_sPatterns;
    }

    protected static abstract class AbstractReflectionAllowedFilter {
        protected final Status f_status;

        public AbstractReflectionAllowedFilter(Status statusPatMatch) {
            this.f_status = statusPatMatch;
        }

        public Status process(Class<?> clz) {
            return this.isMatch(clz) ? this.f_status : Status.UNDECIDED;
        }

        protected abstract boolean isMatch(Class<?> var1);
    }

    static enum Status {
        ALLOWED,
        REJECTED,
        UNDECIDED;

    }

    protected static class ClassInPackageFilter
    extends AbstractReflectionAllowedFilter {
        private final String f_sPackageName;

        public ClassInPackageFilter(String sPackage, Status statusPatMatch) {
            super(statusPatMatch);
            this.f_sPackageName = sPackage;
        }

        @Override
        protected boolean isMatch(Class<?> clz) {
            return this.f_sPackageName.equals(clz.getPackage().getName());
        }
    }

    protected static class ClassStartsWithFilter
    extends AbstractReflectionAllowedFilter {
        private final String f_sPrefix;

        public ClassStartsWithFilter(String sPrefix, Status statusPatMatch) {
            super(statusPatMatch);
            this.f_sPrefix = sPrefix;
        }

        @Override
        protected boolean isMatch(Class<?> clz) {
            return clz.getName().startsWith(this.f_sPrefix);
        }
    }

    protected static class ClassFilter
    extends AbstractReflectionAllowedFilter {
        private final String f_sClassName;

        public ClassFilter(String sClassName, Status statusPatMatch) {
            super(statusPatMatch);
            this.f_sClassName = sClassName;
        }

        @Override
        protected boolean isMatch(Class<?> clz) {
            return clz.getName().equals(this.f_sClassName);
        }
    }
}

