/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.collection;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperCollections;
import com.tangosol.util.function.Remote;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PortableSet<E>
extends WrapperCollections.AbstractWrapperSet<E>
implements PortableObject,
ExternalizableLite {
    protected static final Remote.Supplier DEFAULT_SUPPLIER = HashSet::new;
    @JsonbProperty(value="supplier")
    protected Remote.Supplier<Set<E>> m_supplier;

    public PortableSet() {
    }

    public PortableSet(Remote.Supplier<Set<E>> supplier) {
        this.m_supplier = supplier;
    }

    public Remote.Supplier<Set<E>> getSupplier() {
        return this.m_supplier == null ? DEFAULT_SUPPLIER : this.m_supplier;
    }

    @Override
    protected Set<E> getDelegate() {
        Set set;
        if (this.m_colDelegate == null) {
            this.m_colDelegate = (Collection)this.getSupplier().get();
            set = (Set)this.m_colDelegate;
        } else {
            set = (Set)this.m_colDelegate;
        }
        return set;
    }

    protected void setDelegate(Set<E> setDelegate) {
        this.m_colDelegate = setDelegate;
    }

    public Set<E> unmodifiable() {
        return new Unmodifiable(this.getDelegate());
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_supplier = (Remote.Supplier)ExternalizableHelper.readObject(in);
        Set delegate = (Set)this.getSupplier().get();
        ExternalizableHelper.readCollection(in, delegate, null);
        this.setDelegate(delegate);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_supplier);
        ExternalizableHelper.writeCollection(out, this.getDelegate());
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_supplier = (Remote.Supplier)in.readObject(0);
        Set delegate = (Set)this.getSupplier().get();
        in.readCollection(1, delegate);
        this.setDelegate(delegate);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_supplier);
        out.writeCollection(1, this.getDelegate());
    }

    public static class Unmodifiable<E>
    extends PortableSet<E> {
        public Unmodifiable() {
        }

        private Unmodifiable(Set<E> setDelegate) {
            this.setDelegate(setDelegate);
        }

        @Override
        protected void setDelegate(Set<E> setDelegate) {
            this.m_colDelegate = Collections.unmodifiableSet(setDelegate);
        }
    }
}

